/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.block.BlockRedstoneEmitter;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileAtmosphereDetector
extends TileEntity
implements ITickable,
IModularInventory,
IButtonInventory,
INetworkMachine {
    IAtmosphere atmosphereToDetect = AtmosphereType.AIR;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 10L == 0L) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean detectedAtm = false;
            if (AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()) == null) {
                detectedAtm = this.atmosphereToDetect == AtmosphereType.AIR;
            } else {
                for (EnumFacing direction : EnumFacing.values()) {
                    boolean bl = detectedAtm = !this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_185914_p() && this.atmosphereToDetect == AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).getAtmosphereType(this.field_174879_c.func_177972_a(direction));
                    if (detectedAtm) break;
                }
            }
            if (((BlockRedstoneEmitter)state.func_177230_c()).getState(this.field_145850_b, state, this.field_174879_c) != detectedAtm) {
                ((BlockRedstoneEmitter)state.func_177230_c()).setState(this.field_145850_b, state, this.field_174879_c, detectedAtm);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        LinkedList<ModuleButton> btns = new LinkedList<ModuleButton>();
        Iterator<IAtmosphere> atmIter = AtmosphereRegister.getInstance().getAtmosphereList().iterator();
        int i = 0;
        while (atmIter.hasNext()) {
            IAtmosphere atm = atmIter.next();
            btns.add(new ModuleButton(60, 4 + i * 24, i, LibVulpes.proxy.getLocalizedString(atm.getUnlocalizedName()), (IButtonInventory)this, TextureResources.buttonBuild));
            ++i;
        }
        ModuleContainerPan panningContainer = new ModuleContainerPan(5, 20, btns, new LinkedList(), TextureResources.starryBG, 165, 120, 0, 500);
        modules.add((ModuleBase)panningContainer);
        return modules;
    }

    public String getModularInventoryName() {
        return "atmosphereDetector";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphereList().get(buttonId);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            PacketBuffer buf = new PacketBuffer(out);
            buf.writeShort(this.atmosphereToDetect.getUnlocalizedName().length());
            buf.func_180714_a(this.atmosphereToDetect.getUnlocalizedName());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            PacketBuffer buf = new PacketBuffer(in);
            nbt.func_74778_a("uName", buf.func_150789_c((int)buf.readShort()));
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            String name = nbt.func_74779_i("uName");
            this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphere(name);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("atmName", this.atmosphereToDetect.getUnlocalizedName());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphere(nbt.func_74779_i("atmName"));
    }
}

