/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;

public class WorldGenAlienTree
extends WorldGenAbstractTree {
    public WorldGenAlienTree(boolean p_i45461_1_) {
        super(p_i45461_1_);
    }

    protected boolean func_150523_a(Block blockType) {
        return super.func_150523_a(blockType) || blockType == AdvancedRocketryBlocks.blockAlienSapling || blockType == AdvancedRocketryBlocks.blockAlienWood || blockType == AdvancedRocketryBlocks.blockAlienLeaves;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int treeHeight = random.nextInt(10) + 20;
        boolean flag = true;
        int y = pos.func_177956_o();
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        if (y >= 1 && y + treeHeight + 1 <= 256) {
            int j1;
            for (int treeHeightIterator = y; treeHeightIterator <= y + 1 + treeHeight; ++treeHeightIterator) {
                int xzIterator = 3;
                if (treeHeightIterator == y) {
                    xzIterator = 0;
                }
                if (treeHeightIterator >= y + 1 + treeHeight - 2) {
                    xzIterator = 3;
                }
                for (j1 = x - xzIterator; j1 <= x + xzIterator && flag; ++j1) {
                    for (int k1 = z - xzIterator; k1 <= z + xzIterator && flag; ++k1) {
                        if (treeHeightIterator >= 0 && treeHeightIterator < 256) {
                            BlockPos newPos = new BlockPos(j1, treeHeightIterator, k1);
                            if (this.isReplaceable(world, newPos)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = world.func_180495_p(new BlockPos(x, y - 1, z));
            Block block2 = state.func_177230_c();
            boolean isSoil = block2.canSustainPlant(state, (IBlockAccess)world, new BlockPos(x, y - 1, z), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - treeHeight - 1) {
                int trunkY;
                int j2;
                this.onPlantGrow(world, x, y - 1, z, x, y, z);
                this.onPlantGrow(world, x + 1, y - 1, z, x, y, z);
                this.onPlantGrow(world, x + 1, y - 1, z + 1, x, y, z);
                this.onPlantGrow(world, x, y - 1, z + 1, x, y, z);
                int j3 = random.nextInt(4);
                j1 = treeHeight - random.nextInt(4);
                int trunkX = x;
                int trunkZ = z;
                int i2 = 0;
                for (j2 = 0; j2 < treeHeight; ++j2) {
                    trunkY = y + j2;
                    IBlockState state1 = world.func_180495_p(new BlockPos(trunkX, trunkY, trunkZ));
                    Block block1 = state1.func_177230_c();
                    if (!world.func_175623_d(new BlockPos(trunkX, trunkY, trunkZ)) && !block1.isLeaves(state1, (IBlockAccess)world, new BlockPos(trunkX, trunkY, trunkZ))) continue;
                    this.func_175903_a(world, new BlockPos(trunkX, trunkY, trunkZ), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                    this.func_175903_a(world, new BlockPos(trunkX + 1, trunkY, trunkZ), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                    this.func_175903_a(world, new BlockPos(trunkX, trunkY, trunkZ + 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                    this.func_175903_a(world, new BlockPos(trunkX + 1, trunkY, trunkZ + 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                    i2 = trunkY;
                }
                this.func_175903_a(world, new BlockPos(trunkX - 1, y, trunkZ), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX + 2, y, trunkZ), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX + 2, y, trunkZ + 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX - 1, y, trunkZ + 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX, y, trunkZ - 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX + 1, y, trunkZ - 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX + 1, y, trunkZ + 2), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX, y, trunkZ + 2), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX, y, trunkZ), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX + 1, y, trunkZ), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX, y, trunkZ + 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.func_175903_a(world, new BlockPos(trunkX + 1, y, trunkZ + 1), AdvancedRocketryBlocks.blockAlienWood.func_176223_P());
                this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 1, 1);
                this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, -1, -1);
                this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, -1, 1);
                this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 1, -1);
                this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 1, 0);
                this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, -1, 0);
                this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, 0, 1);
                this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 0, -1);
                this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 1, 1);
                this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, -1, -1);
                this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, -1, 1);
                this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 1, -1);
                this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 1, 0);
                this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, -1, 0);
                this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, 0, 1);
                this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 0, -1);
                for (j2 = -3; j2 <= 3; ++j2) {
                    for (trunkY = -3; trunkY <= 1; ++trunkY) {
                        int b1 = -1;
                        for (int c = 0; c < treeHeight - 4; ++c) {
                            int radius = Math.abs(trunkX + j2) + Math.abs(trunkZ + trunkY);
                            if ((c >= treeHeight / 3 || radius >= 3) && (c < treeHeight / 3 || radius >= 4)) continue;
                            this.replaceAirWithLeaves(world, trunkX + j2, i2 + b1 - c, trunkZ + trunkY);
                            this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b1 - c, trunkZ + trunkY);
                            this.replaceAirWithLeaves(world, trunkX + j2, i2 + b1 - c, 1 + trunkZ - trunkY);
                            this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b1 - c, 1 + trunkZ - trunkY);
                        }
                        if (j2 <= -2 && trunkY <= -1 || j2 == -1 && trunkY == -2) continue;
                        int b2 = 1;
                        this.replaceAirWithLeaves(world, trunkX + j2, i2 + b2, trunkZ + trunkY);
                        this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b2, trunkZ + trunkY);
                        this.replaceAirWithLeaves(world, trunkX + j2, i2 + b2, 1 + trunkZ - trunkY);
                        this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b2, 1 + trunkZ - trunkY);
                    }
                }
                if (random.nextBoolean()) {
                    this.replaceAirWithLeaves(world, trunkX, i2 + 2, trunkZ);
                    this.replaceAirWithLeaves(world, trunkX + 1, i2 + 2, trunkZ);
                    this.replaceAirWithLeaves(world, trunkX + 1, i2 + 2, trunkZ + 1);
                    this.replaceAirWithLeaves(world, trunkX, i2 + 2, trunkZ + 1);
                }
                for (j2 = -3; j2 <= 4; ++j2) {
                    for (trunkY = -3; trunkY <= 4; ++trunkY) {
                        if (j2 == -3 && trunkY == -3 || j2 == -3 && trunkY == 4 || j2 == 4 && trunkY == -3 || j2 == 4 && trunkY == 4 || Math.abs(j2) >= 3 && Math.abs(trunkY) >= 3) continue;
                        this.replaceAirWithLeaves(world, trunkX + j2, i2, trunkZ + trunkY);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void generatePod(World world, Random random, int intitalDist, int x, int y, int z, int dirX, int dirZ) {
        int branchLength = random.nextInt(5) + intitalDist;
        EnumFacing direction = EnumFacing.func_82600_a((int)(dirX != 0 && dirZ != 0 ? Math.abs(dirX) * 4 : Math.abs(dirX) * 4 + Math.abs(dirZ) * 8));
        boolean flag = true;
        for (int l = 0; l < branchLength && flag; ++l) {
            int newX = x + dirX * l;
            int newY = l >= branchLength / 2 ? y + 2 : y;
            int newZ = z + dirZ * l;
            flag = flag && this.replaceBlockWithWood(world, newX, newY, newZ, direction);
            flag = flag && this.replaceBlockWithWood(world, newX, newY - 1, newZ, direction);
            flag = flag && this.replaceBlockWithWood(world, newX + dirZ, newY, newZ + dirX, direction);
            flag = flag && this.replaceBlockWithWood(world, newX + dirZ, newY - 1, newZ + dirX, direction);
        }
        int radius = 4;
        for (int offX = -radius; offX < radius; ++offX) {
            for (int offY = -radius; offY < radius; ++offY) {
                for (int offZ = -radius; offZ < radius; ++offZ) {
                    if (offX * offX + offY * offY + offZ * offZ >= radius * radius + 1) continue;
                    this.replaceAirWithLeaves(world, x + offX + dirX * branchLength, y + offY + 1, z + offZ + dirZ * branchLength);
                }
            }
        }
    }

    private boolean replaceBlockWithWood(World world, int x, int y, int z, EnumFacing direction) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos) || block == AdvancedRocketryBlocks.blockAlienWood || block == AdvancedRocketryBlocks.blockAlienSapling) {
            this.func_175903_a(world, pos, AdvancedRocketryBlocks.blockAlienWood.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)direction.func_176740_k())));
            return true;
        }
        return false;
    }

    private void replaceAirWithLeaves(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175623_d(pos)) {
            this.func_175903_a(world, pos, AdvancedRocketryBlocks.blockAlienLeaves.func_176223_P());
        }
    }

    private void onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        BlockPos pos = new BlockPos(x, y, z);
        world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().onPlantGrow(world.func_180495_p(pos), world, pos, new BlockPos(sourceX, sourceY, sourceZ));
    }
}

