/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.ore;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MaterialRegistry;

public class OreGenerator
extends WorldGenerator
implements IWorldGenerator {
    private static IBlockState dilithiumTargetOre;

    private void generate(World world, Material material, int numPerChunk, int clumpSize, int chunkX, int chunkZ, Random random) {
        for (int i = 0; i < numPerChunk; ++i) {
            int coordX = 16 * chunkX + random.nextInt(16);
            int coordY = random.nextInt(64);
            int coordZ = 16 * chunkZ + random.nextInt(16);
            Block block = Block.func_149634_a((Item)material.getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b());
            new WorldGenMinable(block.func_176203_a(material.getMeta()), clumpSize).func_180709_b(world, random, new BlockPos(coordX, coordY, coordZ));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        OreGenEvent.GenerateMinable event = new OreGenEvent.GenerateMinable(world, random, (WorldGenerator)this, new BlockPos(chunkX, 0, chunkZ), OreGenEvent.GenerateMinable.EventType.CUSTOM);
        MinecraftForge.ORE_GEN_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DENY) {
            if (ARConfiguration.getCurrentConfig().generateCopper) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Copper"), ARConfiguration.getCurrentConfig().copperPerChunk, ARConfiguration.getCurrentConfig().copperClumpSize, chunkX, chunkZ, random);
            }
            if (ARConfiguration.getCurrentConfig().generateTin) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Tin"), ARConfiguration.getCurrentConfig().tinPerChunk, ARConfiguration.getCurrentConfig().tinClumpSize, chunkX, chunkZ, random);
            }
            if (ARConfiguration.getCurrentConfig().generateRutile) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Rutile"), ARConfiguration.getCurrentConfig().rutilePerChunk, ARConfiguration.getCurrentConfig().rutileClumpSize, chunkX, chunkZ, random);
            }
            if (ARConfiguration.getCurrentConfig().generateAluminum) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Aluminum"), ARConfiguration.getCurrentConfig().aluminumPerChunk, ARConfiguration.getCurrentConfig().aluminumClumpSize, chunkX, chunkZ, random);
            }
            if (ARConfiguration.getCurrentConfig().generateIridium) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Iridium"), ARConfiguration.getCurrentConfig().IridiumPerChunk, ARConfiguration.getCurrentConfig().IridiumClumpSize, chunkX, chunkZ, random);
            }
            if (ARConfiguration.getCurrentConfig().generateDilithium) {
                int dilithiumChance = ARConfiguration.getCurrentConfig().dilithiumPerChunk;
                if (world.field_73011_w instanceof WorldProviderPlanet) {
                    dilithiumChance = DimensionProperties.AtmosphereTypes.getAtmosphereTypeFromValue(DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension()).getAtmosphereDensity()) == DimensionProperties.AtmosphereTypes.NONE ? ARConfiguration.getCurrentConfig().dilithiumPerChunkMoon : ARConfiguration.getCurrentConfig().dilithiumPerChunk;
                }
                for (int i = 0; i < dilithiumChance; ++i) {
                    int coordX = 16 * chunkX + random.nextInt(16);
                    int coordY = random.nextInt(64);
                    int coordZ = 16 * chunkZ + random.nextInt(16);
                    new WorldGenMinable(MaterialRegistry.getMaterialFromName((String)"Dilithium").getBlock().func_176223_P(), ARConfiguration.getCurrentConfig().dilithiumClumpSize).func_180709_b(world, random, new BlockPos(coordX, coordY, coordZ));
                }
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return false;
    }
}

