/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreatorStorage;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorStorage;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class TreeRegistry {
    public static final IDropCreatorStorage globalDropCreatorStorage = new DropCreatorStorage();
    private static HashMap<ResourceLocation, ICellKit> cellKitRegistry = new HashMap();
    private static HashMap<ResourceLocation, IGrowthLogicKit> growthLogicKitRegistry = new HashMap();
    public static Map<IBlockState, Species> saplingReplacers = new HashMap<IBlockState, Species>();
    public static final ResourceLocation globalName = new ResourceLocation("dynamictrees", "global");

    public static Species findSpecies(String name) {
        return TreeRegistry.findSpecies(new ResourceLocation(name));
    }

    public static Species findSpecies(ResourceLocation name) {
        return (Species)Species.REGISTRY.getValue(name);
    }

    public static Species findSpeciesSloppy(String name) {
        ResourceLocation resloc = new ResourceLocation(name);
        if ("minecraft".equals(resloc.func_110624_b())) {
            resloc = new ResourceLocation("dynamictrees", resloc.func_110623_a());
        }
        if (Species.REGISTRY.containsKey(resloc)) {
            return (Species)Species.REGISTRY.getValue(resloc);
        }
        for (Species species : Species.REGISTRY) {
            if (!species.getRegistryName().func_110623_a().equals(resloc.func_110623_a())) continue;
            return species;
        }
        return Species.NULLSPECIES;
    }

    public static List<ResourceLocation> getSpeciesDirectory() {
        return new ArrayList<ResourceLocation>(Species.REGISTRY.getKeys());
    }

    public static List<ResourceLocation> getTransformableSpeciesLocs() {
        List<ResourceLocation> species = TreeRegistry.getSpeciesDirectory();
        species.removeIf(resLoc -> !TreeRegistry.findSpecies(resLoc).isTransformable());
        return species;
    }

    public static List<Species> getTransformableSpecies() {
        ArrayList<Species> species = new ArrayList<Species>();
        TreeRegistry.getTransformableSpeciesLocs().forEach(speciesLoc -> species.add(TreeRegistry.findSpecies(speciesLoc)));
        return species;
    }

    public static List<Species> getPotionTransformableSpecies() {
        List<Species> speciesList = TreeRegistry.getTransformableSpecies();
        speciesList.removeIf(species -> {
            TreeFamily family = species.getFamily();
            return species.getSeedStack(1) == null || species.getSeed() == Seed.NULLSEED || species != family.getCommonSpecies() && species.getSeed() == family.getCommonSpecies().getSeed();
        });
        return speciesList;
    }

    public static void registerSaplingReplacer(IBlockState state, Species species) {
        saplingReplacers.put(state, species);
    }

    public static boolean registerDropCreator(ResourceLocation speciesName, IDropCreator dropCreator) {
        if (speciesName == null || speciesName.equals((Object)globalName)) {
            return globalDropCreatorStorage.addDropCreator(dropCreator);
        }
        return TreeRegistry.findSpecies(speciesName).addDropCreator(dropCreator);
    }

    public static boolean removeDropCreator(ResourceLocation speciesName, ResourceLocation dropCreatorName) {
        if (speciesName == null || speciesName.equals((Object)globalName)) {
            return globalDropCreatorStorage.remDropCreator(dropCreatorName);
        }
        return TreeRegistry.findSpecies(speciesName).remDropCreator(dropCreatorName);
    }

    public static Map<ResourceLocation, Map<ResourceLocation, IDropCreator>> getDropCreatorsMap() {
        HashMap<ResourceLocation, Map<ResourceLocation, IDropCreator>> dir = new HashMap<ResourceLocation, Map<ResourceLocation, IDropCreator>>();
        dir.put(globalName, globalDropCreatorStorage.getDropCreators());
        Species.REGISTRY.forEach(species -> dir.put(species.getRegistryName(), species.getDropCreators()));
        return dir;
    }

    public static ICellKit registerCellKit(ResourceLocation name, ICellKit kit) {
        return cellKitRegistry.computeIfAbsent(name, k -> kit);
    }

    public static ICellKit findCellKit(ResourceLocation name) {
        return cellKitRegistry.get(name);
    }

    public static ICellKit findCellKit(String name) {
        ResourceLocation kitLocation = new ResourceLocation(name);
        if ("minecraft".equals(kitLocation.func_110624_b())) {
            kitLocation = new ResourceLocation("dynamictrees", kitLocation.func_110623_a());
        }
        return TreeRegistry.findCellKit(kitLocation);
    }

    public static void cleanupCellKit() {
        cellKitRegistry = new HashMap();
    }

    public static IGrowthLogicKit registerGrowthLogicKit(ResourceLocation name, IGrowthLogicKit kit) {
        return growthLogicKitRegistry.computeIfAbsent(name, k -> kit);
    }

    public static IGrowthLogicKit findGrowthLogicKit(ResourceLocation name) {
        return growthLogicKitRegistry.get(name);
    }

    public static IGrowthLogicKit findGrowthLogicKit(String name) {
        ResourceLocation kitLocation = new ResourceLocation(name);
        if ("minecraft".equals(kitLocation.func_110624_b())) {
            kitLocation = new ResourceLocation("dynamictrees", kitLocation.func_110623_a());
        }
        return TreeRegistry.findGrowthLogicKit(kitLocation);
    }

    public static void cleanupGrowthLogicKit() {
        growthLogicKitRegistry = new HashMap();
    }
}

