/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CommandTransform
extends SubCommand {
    public static final String TRANSFORM = "transform";

    @Override
    public String getName() {
        return TRANSFORM;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        switch (args.length) {
            case 2: 
            case 3: 
            case 4: {
                return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
            }
            case 5: {
                return CommandBase.func_175762_a((String[])args, TreeRegistry.getTransformableSpeciesLocs());
            }
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }

    @Override
    public void execute(World world, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos = BlockPos.field_177992_a;
        Species toSpecies = null;
        if (args.length < 5) {
            throw new WrongUsageException("commands.dynamictrees.transform.usage", new Object[0]);
        }
        block4: for (int arg = 0; arg < args.length; ++arg) {
            switch (arg) {
                case 3: {
                    pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
                    continue block4;
                }
                case 4: {
                    toSpecies = TreeRegistry.findSpeciesSloppy(args[4]);
                    if (toSpecies != Species.NULLSPECIES) continue block4;
                    throw new CommandException("commands.dynamictrees.setree.specieserror", new Object[]{args[4]});
                }
            }
        }
        BlockPos rootPos = TreeHelper.findRootNode(world, pos);
        Species fromSpecies = TreeHelper.getExactSpecies(world, rootPos);
        if (rootPos == BlockPos.field_177992_a) {
            throw new CommandException("commands.dynamictrees.soillife.notreeerror", new Object[]{pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p()});
        }
        if (!toSpecies.isTransformable() || !fromSpecies.isTransformable()) {
            throw new CommandException("commands.dynamictrees.transform.nottransformableerror", new Object[]{!toSpecies.isTransformable() ? args[4] : fromSpecies.getRegistryName()});
        }
        IBlockState rootyState = world.func_180495_p(rootPos);
        BlockRooty rootyBlock = TreeHelper.getRooty(rootyState);
        rootyBlock.startAnalysis(world, rootPos, new MapSignal(new NodeTransform(fromSpecies, toSpecies)));
        if (rootyBlock.getSpecies(rootyState, world, rootPos) != toSpecies) {
            toSpecies.placeRootyDirtBlock(world, rootPos, rootyBlock.getSoilLife(rootyState, (IBlockAccess)world, rootPos));
        }
    }
}

