/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.substances.IEmptiable;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceDeplete;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceFertilize;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceFreeze;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceGrowth;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceMega;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class DendroPotion
extends Item
implements ISubstanceEffectProvider,
IEmptiable {
    public static final String name = "dendropotion";

    public DendroPotion() {
        this(name);
    }

    public DendroPotion(String name) {
        this.setRegistryName(name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ModTabs.dynamicTreesTab);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (DendroPotionType type : DendroPotionType.values()) {
                if (!type.getActive()) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, type.getIndex()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.getPotionType(stack).getName();
    }

    public DendroPotionType getPotionTypeForDamage(int damage) {
        return DendroPotionType.values()[damage % DendroPotionType.values().length];
    }

    public DendroPotionType getPotionType(ItemStack stack) {
        return this.getPotionTypeForDamage(stack.func_77952_i());
    }

    @Override
    public ISubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        switch (this.getPotionType(itemStack)) {
            default: {
                return null;
            }
            case BURGEONING: {
                return new SubstanceGrowth();
            }
            case GIGAS: {
                return new SubstanceMega();
            }
            case DEPLETION: {
                return new SubstanceDeplete().setAmount(15);
            }
            case FERTILITY: {
                return new SubstanceFertilize().setAmount(15);
            }
            case PERSISTANCE: {
                return new SubstanceFreeze();
            }
            case TRANSFORM: 
        }
        return new SubstanceTransform(this.getTargetSpecies(itemStack));
    }

    public Species getTargetSpecies(ItemStack itemStack) {
        String targetTree;
        NBTTagCompound nbtTag;
        if (itemStack.func_77942_o() && (nbtTag = itemStack.func_77978_p()).func_74764_b("target") && !(targetTree = nbtTag.func_74779_i("target")).equals("")) {
            return TreeRegistry.findSpecies(new ResourceLocation(targetTree));
        }
        return null;
    }

    public ItemStack setTargetTree(ItemStack itemStack, TreeFamily family) {
        return this.setTargetSpecies(itemStack, family.getCommonSpecies());
    }

    public ItemStack setTargetSpecies(ItemStack itemStack, Species species) {
        NBTTagCompound nbtTag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        nbtTag.func_74778_a("target", species.getRegistryName().toString());
        itemStack.func_77982_d(nbtTag);
        return itemStack;
    }

    public DendroPotion registerRecipes(IForgeRegistry<IRecipe> registry) {
        ItemStack awkwardStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)((PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation("awkward"))));
        this.addRecipe(awkwardStack, new ItemStack(Items.field_151044_h, 1, 1), this.getPotionStack(DendroPotionType.BIOCHAR));
        this.addRecipe(Items.field_151123_aH, DendroPotionType.DEPLETION);
        this.addRecipe(Items.field_151080_bb, DendroPotionType.GIGAS);
        this.addRecipe(Items.field_151073_bk, DendroPotionType.BURGEONING);
        this.addRecipe(Items.field_151115_aP, DendroPotionType.FERTILITY);
        this.addRecipe((Block)Blocks.field_150328_O, 1, DendroPotionType.PERSISTANCE);
        this.addRecipe(Items.field_179563_cD, DendroPotionType.TRANSFORM);
        for (Species species : TreeRegistry.getPotionTransformableSpecies()) {
            ItemStack outputStack = this.setTargetSpecies(new ItemStack((Item)this, 1, DendroPotionType.TRANSFORM.getIndex()), species);
            this.addRecipe(this.getPotionStack(DendroPotionType.TRANSFORM), species.getSeedStack(1), outputStack);
        }
        return this;
    }

    private void addRecipe(Item ingredient, DendroPotionType typeOut) {
        this.addRecipe(new ItemStack(ingredient), typeOut);
    }

    private void addRecipe(Block ingredient, int ingredientMeta, DendroPotionType typeOut) {
        this.addRecipe(new ItemStack(ingredient, 1, ingredientMeta), typeOut);
    }

    private void addRecipe(ItemStack ingredient, DendroPotionType typeOut) {
        this.addRecipe(ingredient, this.getPotionStack(typeOut));
    }

    private void addRecipe(ItemStack ingredientStack, ItemStack stackOut) {
        this.addRecipe(this.getPotionStack(DendroPotionType.BIOCHAR), ingredientStack, stackOut);
    }

    private void addRecipe(ItemStack stackIn, ItemStack ingredientStack, ItemStack stackOut) {
        BrewingRecipeRegistry.addRecipe((ItemStack)stackIn, (ItemStack)ingredientStack, (ItemStack)stackOut);
    }

    private ItemStack getPotionStack(DendroPotionType type) {
        return new ItemStack((Item)this, 1, type.getIndex());
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        DendroPotionType potionType = this.getPotionType(stack);
        if (potionType == DendroPotionType.TRANSFORM) {
            Species species = this.getTargetSpecies(stack);
            if (species == null) {
                tooltip.add(this.getPotionType(stack).getLore());
            } else {
                tooltip.add(DendroPotion.getTranslationText("potion.transform.description", species.getLocalizedName()));
            }
        } else {
            tooltip.add(this.getPotionType(stack).getLore());
        }
    }

    public int getColor(ItemStack stack, int tint) {
        return tint == 0 ? this.getPotionType(stack).getColor() : -1;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return new ItemStack(Items.field_151069_bo);
    }

    private static String getTranslationText(String path, String ... args) {
        return new TextComponentTranslation(path, (Object[])args).func_150261_e();
    }

    public static enum DendroPotionType {
        BIOCHAR(0, true, "biochar", 2564892),
        DEPLETION(1, true, "depletion", 7781997),
        GIGAS(2, true, "gigas", 14913565),
        BURGEONING(3, true, "burgeoning", 11124414),
        FERTILITY(4, true, "fertility", 4903936),
        PERSISTANCE(5, true, "persistance", 3709695),
        TRANSFORM(6, true, "transform", 8370340);

        private final int index;
        private final boolean active;
        private final String name;
        private final int color;
        ItemPotion p;

        private DendroPotionType(int index, boolean active, String name, int color) {
            this.index = index;
            this.active = active;
            this.name = name;
            this.color = color;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean getActive() {
            return this.active;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public String getLore() {
            return DendroPotion.getTranslationText("potion." + this.name + ".description" + (this == DendroPotionType.TRANSFORM ? ".empty" : ""), new String[]{""});
        }
    }
}

