/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Staff
extends Item {
    public static final String HANDLE = "handle";
    public static final String COLOR = "color";
    public static final String READONLY = "readonly";
    public static final String TREE = "tree";
    public static final String CODE = "code";
    public static final String USES = "uses";
    public static final String MAXUSES = "maxuses";

    public Staff() {
        this("staff");
    }

    public Staff(String name) {
        this.setRegistryName(name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
        this.setHarvestLevel("axe", 3);
        this.func_77637_a(ModTabs.dynamicTreesTab);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() instanceof BlockBranch || state.func_177230_c() instanceof BlockTrunkShell) {
            return 64.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (state.func_177230_c() instanceof BlockBranch || state.func_177230_c() instanceof BlockTrunkShell) {
            if (this.decUses(stack)) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        ItemStack heldStack = player.func_184586_b(hand);
        IBlockState clickedBlockState = world.func_180495_p(pos);
        if (!this.isReadOnly(heldStack) && (species = TreeHelper.getBestGuessSpecies(world, pos)).isValid()) {
            EnumFacing playerFacing;
            Optional<JoCode> joCode;
            this.setSpecies(heldStack, species);
            if (!player.func_70093_af() && (joCode = TreeHelper.getJoCode(world, pos, playerFacing = player.func_174811_aO())).isPresent()) {
                String code = joCode.get().toString();
                this.setCode(heldStack, code);
                if (world.field_72995_K) {
                    GuiScreen.func_146275_d((String)code);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        species = this.getSpecies(heldStack);
        if (species.isValid() && species.isAcceptableSoil(world, pos, clickedBlockState)) {
            species.getJoCode(this.getCode(heldStack)).setCareful(true).generate(world, species, pos, world.func_180494_b(pos), player.func_174811_aO(), 8, SafeChunkBounds.ANY);
            if (!player.func_184812_l_()) {
                if (this.hasMaxUses(heldStack)) {
                    if (this.decUses(heldStack)) {
                        heldStack.func_190918_g(1);
                    }
                } else {
                    heldStack.func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.hasMaxUses(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return super.func_77626_a(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double damage = (double)this.getUses(stack) / (double)this.getMaxUses(stack);
        return 1.0 - damage;
    }

    public NBTTagCompound getNBT(ItemStack itemStack) {
        return itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
    }

    public boolean isReadOnly(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74767_n(READONLY);
    }

    public Staff setReadOnly(ItemStack itemStack, boolean readonly) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74757_a(READONLY, readonly);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Staff setSpecies(ItemStack itemStack, Species species) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a(TREE, species.toString());
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Staff setCode(ItemStack itemStack, String code) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a(CODE, code);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Species getSpecies(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b(TREE)) {
            return TreeRegistry.findSpecies(new ResourceLocation(nbt.func_74779_i(TREE)));
        }
        Species species = TreeRegistry.findSpeciesSloppy("oak");
        this.setSpecies(itemStack, species);
        return species;
    }

    public int getUses(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b(USES)) {
            return nbt.func_74762_e(USES);
        }
        int uses = this.getMaxUses(itemStack);
        this.setUses(itemStack, uses);
        return uses;
    }

    public void setUses(ItemStack itemStack, int value) {
        this.getNBT(itemStack).func_74768_a(USES, value);
    }

    public int getMaxUses(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b(MAXUSES)) {
            return nbt.func_74762_e(MAXUSES);
        }
        return 0;
    }

    public void setMaxUses(ItemStack itemStack, int value) {
        this.getNBT(itemStack).func_74768_a(MAXUSES, value);
    }

    public boolean hasMaxUses(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74764_b(MAXUSES);
    }

    public boolean decUses(ItemStack itemStack) {
        int uses = Math.max(0, this.getUses(itemStack) - 1);
        this.setUses(itemStack, uses);
        return uses <= 0;
    }

    public int getColor(ItemStack itemStack, int tint) {
        if (tint == 0) {
            NBTTagCompound nbt = this.getNBT(itemStack);
            int color = 5981999;
            if (nbt.func_74764_b(HANDLE)) {
                try {
                    color = Color.decode(nbt.func_74779_i(HANDLE)).getRGB();
                }
                catch (NumberFormatException e) {
                    nbt.func_82580_o(HANDLE);
                }
            } else {
                color = this.getSpecies(itemStack).getFamily().getWoodColor();
            }
            return color;
        }
        if (tint == 1) {
            NBTTagCompound nbt = this.getNBT(itemStack);
            int color = 65535;
            if (nbt.func_74764_b(COLOR)) {
                try {
                    color = Color.decode(nbt.func_74779_i(COLOR)).getRGB();
                }
                catch (NumberFormatException e) {
                    nbt.func_82580_o(COLOR);
                }
            }
            return color;
        }
        return -1;
    }

    public Staff setColor(ItemStack itemStack, String colStr) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a(COLOR, colStr);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public String getCode(ItemStack itemStack) {
        String code = "P";
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b(CODE)) {
            code = nbt.func_74779_i(CODE);
        } else {
            nbt.func_74778_a(CODE, code);
            itemStack.func_77982_d(nbt);
        }
        return code;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        Species species = this.getSpecies(stack);
        tooltip.add(Staff.getTranslationText("tooltip.woodland_staff.tree") + " " + (species != null ? "\u00c2\u00a7a" + species.getLocalizedName() : Staff.getTranslationText("tooltip.woodland_staff.tree_not_set")));
        tooltip.add("JoCode: \u00c2\u00a76" + this.getCode(stack));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, 0));
        }
        return multimap;
    }

    private static String getTranslationText(String path) {
        return new TextComponentTranslation(path, new Object[0]).func_150261_e();
    }
}

