/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelEntityFallingTree {
    protected final List<TreeQuadData> quads;
    protected final int entityId;

    public ModelEntityFallingTree(EntityFallingTree entity) {
        this.quads = this.generateTreeQuads(entity, entity.func_130014_f_());
        this.entityId = entity.func_145782_y();
    }

    public List<TreeQuadData> getQuadData() {
        return this.quads;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static int getBrightness(EntityFallingTree entity) {
        BranchDestructionData destructionData = entity.getDestroyData();
        World world = entity.func_130014_f_();
        return world.func_180495_p(destructionData.cutPos).func_185889_a((IBlockAccess)world, destructionData.cutPos);
    }

    public List<TreeQuadData> generateTreeQuads(EntityFallingTree entity, World world) {
        ArrayList<TreeQuadData> treeQuads;
        block8: {
            IExtendedBlockState exState;
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            BranchDestructionData destructionData = entity.getDestroyData();
            Species species = destructionData.species;
            BlockPos cutPos = destructionData.cutPos;
            EnumFacing cutDir = destructionData.cutDir;
            treeQuads = new ArrayList<TreeQuadData>();
            if (destructionData.getNumBranches() <= 0 || (exState = destructionData.getBranchBlockState(0)) == null) break block8;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                exState = exState.withProperty(BlockBranch.CONNECTIONS[face.func_176745_a()], (Object)(face == cutDir.func_176734_d() ? 8 : 0));
            }
            int radius = ((BlockBranch)exState.func_177230_c()).getRadius((IBlockState)exState);
            float offset = (float)(8 - Math.min(radius, 8)) / 16.0f;
            IBakedModel branchModel = dispatcher.func_184389_a(exState.getClean());
            treeQuads.addAll(ModelEntityFallingTree.toTreeQuadData(QuadManipulator.getQuads(branchModel, (IBlockState)exState, new Vec3d((Vec3i)BlockPos.field_177992_a.func_177972_a(cutDir)).func_186678_a((double)offset), new EnumFacing[]{cutDir}), -1, exState.getClean()));
            for (int index = 0; index < destructionData.getNumBranches(); ++index) {
                Block previousBranch = exState.func_177230_c();
                if (!previousBranch.equals((exState = destructionData.getBranchBlockState(index)).func_177230_c())) {
                    branchModel = dispatcher.func_184389_a(exState.getClean());
                }
                BlockPos blockPos = destructionData.getBranchRelPos(index);
                treeQuads.addAll(ModelEntityFallingTree.toTreeQuadData(QuadManipulator.getQuads(branchModel, (IBlockState)exState, new Vec3d((Vec3i)blockPos)), -1, exState.getClean()));
            }
            HashMap<BlockPos, IBlockState> leavesClusters = species.getFamily().getFellingLeavesClusters(destructionData);
            if (leavesClusters != null) {
                for (Map.Entry entry : leavesClusters.entrySet()) {
                    IBlockState leafState = (IBlockState)entry.getValue();
                    if (leafState instanceof IExtendedBlockState) {
                        leafState = ((IExtendedBlockState)leafState).getClean();
                    }
                    treeQuads.addAll(ModelEntityFallingTree.toTreeQuadData(QuadManipulator.getQuads(dispatcher.func_184389_a(leafState), (IBlockState)entry.getValue(), new Vec3d((Vec3i)entry.getKey())), species.getLeavesProperties().foliageColorMultiplier(leafState, (IBlockAccess)world, cutPos), leafState));
                }
            } else {
                for (int index = 0; index < destructionData.getNumLeaves(); ++index) {
                    BlockPos blockPos = destructionData.getLeavesRelPos(index);
                    IBlockState state = destructionData.getLeavesBlockState(index);
                    IBakedModel leavesModel = dispatcher.func_184389_a(state);
                    treeQuads.addAll(ModelEntityFallingTree.toTreeQuadData(QuadManipulator.getQuads(leavesModel, state, new Vec3d((Vec3i)blockPos)), destructionData.getLeavesProperties(index).foliageColorMultiplier(state, (IBlockAccess)world, cutPos.func_177971_a((Vec3i)blockPos)), state));
                }
            }
        }
        return treeQuads;
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, int color, IBlockState state) {
        return bakedQuads.stream().map(bakedQuad -> new TreeQuadData((BakedQuad)bakedQuad, color, state)).collect(Collectors.toList());
    }

    public static final class TreeQuadData {
        public final BakedQuad bakedQuad;
        public final IBlockState state;
        public final int color;

        public TreeQuadData(BakedQuad bakedQuad, int color, IBlockState state) {
            this.bakedQuad = bakedQuad;
            this.state = state;
            this.color = color;
        }
    }
}

