/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.blocks.SpeciesProperty;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedModelSapling
implements IBakedModel {
    private static IBakedModel[] modelMap;
    private static IBakedModel errorSaplingModel;
    private static TextureAtlasSprite particleTexture;

    public static IBakedModel getModelForSapling(Species species) {
        int modelId = species.saplingModelId;
        IBakedModel bakedModel = modelMap[modelId];
        return bakedModel != null ? bakedModel : errorSaplingModel;
    }

    public BakedModelSapling(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("dynamictrees", "block/saplings/error"));
            if (model != null) {
                errorSaplingModel = model.bake(state, format, bakedTextureGetter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        particleTexture = bakedTextureGetter.apply(new ResourceLocation("blocks/dirt"));
        modelMap = new IBakedModel[Species.REGISTRY.getEntries().size()];
        int modelId = 0;
        for (Map.Entry entry : Species.REGISTRY.getEntries()) {
            Species species = (Species)((Object)entry.getValue());
            ResourceLocation resLoc = species.getSaplingName();
            species.saplingModelId = modelId;
            if (species != Species.NULLSPECIES) {
                try {
                    IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(resLoc.func_110624_b(), "block/saplings/" + resLoc.func_110623_a()));
                    if (model != null) {
                        BakedModelSapling.modelMap[modelId] = model.bake(state, format, bakedTextureGetter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++modelId;
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        Species species;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(12);
        if (state != null && state.func_177230_c() instanceof BlockDynamicSapling && state instanceof IExtendedBlockState && (species = (Species)((Object)((IExtendedBlockState)state).getValue((IUnlistedProperty)SpeciesProperty.SPECIES))) != null) {
            quads.addAll(BakedModelSapling.getModelForSapling(species).func_188616_a(ModBlocks.blockDynamicSapling.func_176223_P(), side, rand));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return particleTexture;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }
}

