/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.seasons;

import com.ferreusveritas.dynamictrees.api.seasons.ISeasonManager;
import com.ferreusveritas.dynamictrees.seasons.SeasonManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SeasonHelper {
    public static final float SPRING = 0.0f;
    public static final float SUMMER = 1.0f;
    public static final float AUTUMN = 2.0f;
    public static final float WINTER = 3.0f;
    public static final float DRY = 1.0f;
    public static final float WET = 3.0f;
    private static ISeasonManager seasonManager = new SeasonManager();

    public static ISeasonManager getSeasonManager() {
        return seasonManager;
    }

    public static void setSeasonManager(ISeasonManager manager) {
        seasonManager = manager;
    }

    public static void updateTick(World world, long worldTicks) {
        seasonManager.updateTick(world, worldTicks);
    }

    public static float globalSeasonalGrowthFactor(World world, BlockPos rootPos) {
        return SeasonHelper.globalSeasonalGrowthFactor(world, rootPos, 0.0f);
    }

    public static float globalSeasonalGrowthFactor(World world, BlockPos rootPos, float offset) {
        return seasonManager.getGrowthFactor(world, rootPos, offset);
    }

    public static float globalSeasonalSeedDropFactor(World world, BlockPos pos) {
        return SeasonHelper.globalSeasonalSeedDropFactor(world, pos, 0.0f);
    }

    public static float globalSeasonalSeedDropFactor(World world, BlockPos pos, float offset) {
        return seasonManager.getSeedDropFactor(world, pos, offset);
    }

    public static float globalSeasonalFruitProductionFactor(World world, BlockPos pos) {
        return SeasonHelper.globalSeasonalFruitProductionFactor(world, pos, 0.0f);
    }

    public static float globalSeasonalFruitProductionFactor(World world, BlockPos pos, float offset) {
        return seasonManager.getFruitProductionFactor(world, pos, offset);
    }

    public static Float getSeasonValue(World world, BlockPos pos) {
        return seasonManager.getSeasonValue(world, pos);
    }

    public static boolean isTropical(World world, BlockPos pos) {
        return seasonManager.isTropical(world, pos);
    }

    public static boolean isSeasonBetween(float testValue, float SeasonA, float SeasonB) {
        testValue %= 4.0f;
        if ((SeasonA %= 4.0f) <= (SeasonB %= 4.0f)) {
            return testValue > SeasonA && testValue < SeasonB;
        }
        return testValue < SeasonB || testValue > SeasonA;
    }

    public static boolean shouldSnowMelt(World world, BlockPos pos) {
        return seasonManager.shouldSnowMelt(world, pos);
    }
}

