/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenRoots
implements IPostGrowFeature,
IPostGenFeature {
    private int levelLimit = 2;
    private final int minTrunkRadius;
    private BiFunction<Integer, Integer, Integer> scaler = (i, j) -> i;
    private SimpleVoxmap[] rootMaps;

    public FeatureGenRoots(int minTrunkRadius) {
        this.minTrunkRadius = minTrunkRadius;
        this.rootMaps = this.createRootMaps();
    }

    protected SimpleVoxmap[] createRootMaps() {
        byte[][] rootData = new byte[][]{{0, 3, 0, 0, 0, 0, 0, 0, 5, 6, 7, 0, 3, 2, 0, 0, 0, 8, 0, 5, 0, 0, 6, 8, 0, 8, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 4, 6, 4, 0, 0, 0, 2, 0, 0, 3, 2, 1}, {0, 3, 0, 0, 0, 0, 0, 0, 5, 6, 7, 0, 3, 2, 0, 0, 0, 8, 0, 5, 0, 0, 6, 8, 0, 8, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 4, 6, 4, 0, 0, 0, 2, 0, 0, 3, 2, 1}, {0, 0, 2, 0, 0, 0, 0, 3, 4, 6, 0, 0, 0, 0, 1, 0, 7, 8, 0, 0, 0, 0, 0, 0, 0, 7, 6, 0, 0, 0, 0, 8, 0, 5, 4, 0, 5, 6, 7, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0}, {0, 4, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 1, 0, 0, 0, 7, 0, 0, 3, 0, 0, 0, 8, 0, 8, 7, 0, 0, 0, 0, 8, 0, 5, 4, 0, 0, 6, 7, 3, 0, 2, 0, 4, 5, 0, 0, 0, 0}, {3, 4, 5, 0, 0, 0, 0, 2, 0, 6, 0, 0, 0, 0, 0, 0, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 7, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 2, 3, 5, 2, 0}, {0, 0, 4, 0, 0, 0, 0, 0, 0, 6, 7, 0, 2, 0, 0, 0, 0, 8, 0, 3, 0, 5, 7, 8, 0, 6, 5, 0, 3, 0, 0, 8, 0, 2, 1, 0, 3, 0, 7, 0, 0, 0, 0, 4, 5, 6, 0, 0, 0}};
        SimpleVoxmap[] maps = new SimpleVoxmap[rootData.length];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new SimpleVoxmap(7, 1, 7, rootData[i]).setCenter(new BlockPos(3, 0, 3));
        }
        return maps;
    }

    public FeatureGenRoots setLevelLimit(int limit) {
        this.levelLimit = limit;
        return this;
    }

    public FeatureGenRoots setScaler(BiFunction<Integer, Integer, Integer> scaler) {
        this.scaler = scaler;
        return this;
    }

    @Override
    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        BlockPos treePos = rootPos.func_177984_a();
        int trunkRadius = TreeHelper.getRadius((IBlockAccess)world, treePos);
        if (trunkRadius >= this.minTrunkRadius) {
            return this.startRoots(world, treePos, species, trunkRadius);
        }
        return false;
    }

    public boolean startRoots(World world, BlockPos treePos, Species species, int trunkRadius) {
        int hash = CoordUtils.coordHashCode(treePos, 2);
        SimpleVoxmap rootMap = this.rootMaps[hash % this.rootMaps.length];
        this.nextRoot(world, rootMap, treePos, species, trunkRadius, BlockPos.field_177992_a, 0, -1, null, 0);
        return true;
    }

    @Override
    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, Species species, int soilLife, boolean natural) {
        int trunkRadius = TreeHelper.getRadius((IBlockAccess)world, treePos);
        if (soilLife > 0 && trunkRadius >= this.minTrunkRadius) {
            CoordUtils.Surround surr = CoordUtils.Surround.values()[world.field_73012_v.nextInt(8)];
            BlockPos dPos = treePos.func_177971_a(surr.getOffset());
            if (world.func_180495_p(dPos).func_177230_c() instanceof BlockSurfaceRoot) {
                world.func_175656_a(dPos, ModBlocks.blockTrunkShell.func_176223_P().func_177226_a(BlockTrunkShell.COREDIR, (Comparable)((Object)surr.getOpposite())));
            }
            this.startRoots(world, treePos, species, trunkRadius);
        }
        return true;
    }

    protected void nextRoot(World world, SimpleVoxmap rootMap, BlockPos trunkPos, Species species, int trunkRadius, BlockPos pos, int height, int levelCount, EnumFacing fromDir, int radius) {
        for (int depth = 0; depth < 2; ++depth) {
            BlockPos currPos = trunkPos.func_177971_a((Vec3i)pos).func_177981_b(height - depth);
            IBlockState placeState = world.func_180495_p(currPos);
            IBlockState belowState = world.func_180495_p(currPos.func_177977_b());
            boolean onNormalCube = belowState.func_185915_l();
            if (pos != BlockPos.field_177992_a && (!this.isReplaceableWithRoots(world, placeState, currPos) || depth != 1 && !onNormalCube)) continue;
            if (radius > 0) {
                species.getFamily().getSurfaceRoots().setRadius(world, currPos, radius, fromDir, 3);
            }
            if (!onNormalCube) break;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                int thisLevelCount;
                if (dir == fromDir) continue;
                BlockPos dPos = pos.func_177972_a(dir);
                int nextRad = this.scaler.apply(Integer.valueOf(rootMap.getVoxel(dPos)), trunkRadius);
                if (pos != BlockPos.field_177992_a && nextRad >= radius) {
                    nextRad = radius - 1;
                }
                int n = thisLevelCount = depth == 1 ? 1 : levelCount + 1;
                if (nextRad <= 0 || thisLevelCount > this.levelLimit) continue;
                this.nextRoot(world, rootMap, trunkPos, species, trunkRadius, dPos, height - depth, thisLevelCount, dir.func_176734_d(), nextRad);
            }
            break;
        }
    }

    protected boolean isReplaceableWithRoots(World world, IBlockState placeState, BlockPos pos) {
        Block block = placeState.func_177230_c();
        if (block == Blocks.field_150350_a || block == ModBlocks.blockTrunkShell) {
            return true;
        }
        Material material = placeState.func_185904_a();
        return block.func_176200_f((IBlockAccess)world, pos) && material != Material.field_151586_h && material != Material.field_151587_i;
    }
}

