/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SubstanceFertilize
implements ISubstanceEffect {
    int amount = 1;
    boolean grow;

    @Override
    public boolean apply(World world, BlockPos rootPos) {
        BlockRooty dirt = TreeHelper.getRooty(world.func_180495_p(rootPos));
        if (dirt != null && dirt.fertilize(world, rootPos, this.amount) || this.grow) {
            if (world.field_72995_K) {
                TreeHelper.treeParticles(world, rootPos, EnumParticleTypes.VILLAGER_HAPPY, 8);
            } else if (this.grow) {
                TreeHelper.growPulse(world, rootPos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(World world, BlockPos rootPos, int deltaTicks) {
        return false;
    }

    @Override
    public String getName() {
        return "fertilize";
    }

    public SubstanceFertilize setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public SubstanceFertilize setGrow(boolean grow) {
        this.grow = grow;
        return this;
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

