/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenCocoa;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenUndergrowth;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.trees.TreeFamilyVanilla;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeJungle
extends TreeFamilyVanilla {
    Species megaSpecies;
    BlockSurfaceRoot surfaceRootBlock;

    public TreeJungle() {
        super(BlockPlanks.EnumType.JUNGLE);
        this.canSupportCocoa = true;
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockOldLeaf && state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.JUNGLE);
    }

    @Override
    public void createSpecies() {
        this.megaSpecies = new SpeciesMegaJungle((TreeFamily)this);
        this.setCommonSpecies(new SpeciesJungle((TreeFamily)this));
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.megaSpecies);
    }

    @Override
    public boolean isThick() {
        return true;
    }

    @Override
    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList = super.getRegisterableBlocks(blockList);
        blockList.add(this.surfaceRootBlock);
        return blockList;
    }

    @Override
    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    @Override
    public boolean onTreeActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockBranch branch;
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 3 && (branch = TreeHelper.getBranch(state)) != null && branch.getRadius(state) == 8) {
            if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                pos = pos.func_177972_a(side);
            }
            if (world.func_175623_d(pos)) {
                IBlockState cocoaState = ModBlocks.blockFruitCocoa.func_180642_a(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player);
                EnumFacing facing = (EnumFacing)cocoaState.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                world.func_180501_a(pos, ModBlocks.blockFruitCocoa.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 2);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                return true;
            }
        }
        return super.onTreeActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public class SpeciesMegaJungle
    extends Species {
        private static final String speciesName = "megajungle";

        SpeciesMegaJungle(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), speciesName), treeFamily);
            this.setRequiresTileEntity(true);
            this.setBasicGrowingParameters(0.32f, 32.0f, 7, 8, 0.9f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit("jungle"));
            this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.1f);
            this.setSoilLongevity(16);
            this.addGenFeature(new FeatureGenVine().setQuantity(16).setMaxLength(16));
            this.addGenFeature(new FeatureGenFlareBottom());
            this.addGenFeature(new FeatureGenClearVolume(8));
            this.addGenFeature(new FeatureGenMound(999));
            this.addGenFeature(new FeatureGenRoots(9).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 9 ? (float)trunkRadius.intValue() / 18.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return TreeJungle.this.getCommonSpecies().getSeedStack(qty);
        }

        @Override
        public Seed getSeed() {
            return TreeJungle.this.getCommonSpecies().getSeed();
        }

        @Override
        public int maxBranchRadius() {
            return 24;
        }

        @Override
        public boolean isThick() {
            return true;
        }

        @Override
        public boolean isMega() {
            return true;
        }
    }

    public class SpeciesJungle
    extends Species {
        SpeciesJungle(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.2f, 28.0f, 3, 2, 1.0f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit("jungle"));
            this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.1f);
            this.setupStandardSeedDropping();
            this.addGenFeature(new FeatureGenCocoa());
            this.addGenFeature(new FeatureGenVine().setQuantity(16).setMaxLength(16));
            this.addGenFeature(new FeatureGenUndergrowth());
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }

        @Override
        public Species getMegaSpecies() {
            return TreeJungle.this.megaSpecies;
        }
    }
}

