/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.util.JsonHelper;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeApplier;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeSelector;
import com.ferreusveritas.dynamictrees.worldgen.json.JsonBiomePropertyApplierChance;
import com.ferreusveritas.dynamictrees.worldgen.json.JsonBiomePropertyApplierDensity;
import com.ferreusveritas.dynamictrees.worldgen.json.JsonBiomePropertyApplierSpecies;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDataBasePopulatorJson
implements IBiomeDataBasePopulator {
    public static final String SPECIES = "species";
    public static final String DENSITY = "density";
    public static final String CHANCE = "chance";
    public static final String CANCELVANILLA = "cancelvanilla";
    public static final String MULTIPASS = "multipass";
    public static final String SUBTERRANEAN = "subterranean";
    public static final String FORESTNESS = "forestness";
    public static final String BLACKLIST = "blacklist";
    public static final String RESET = "reset";
    public static final String WHITE = "white";
    public static final String SELECT = "select";
    public static final String APPLY = "apply";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    private JsonElement jsonElement;
    private static Map<String, IJsonBiomeSelector> jsonBiomeSelectorMap = new HashMap<String, IJsonBiomeSelector>();
    private static Map<String, IJsonBiomeApplier> jsonBiomeApplierMap = new HashMap<String, IJsonBiomeApplier>();
    public static Set<Biome> blacklistedBiomes = new HashSet<Biome>();

    public static void addJsonBiomeSelector(String name, IJsonBiomeSelector selector) {
        jsonBiomeSelectorMap.put(name, selector);
    }

    public static void addJsonBiomeApplier(String name, IJsonBiomeApplier applier) {
        jsonBiomeApplierMap.put(name, applier);
    }

    public static void cleanup() {
        jsonBiomeApplierMap = new HashMap<String, IJsonBiomeApplier>();
        jsonBiomeSelectorMap = new HashMap<String, IJsonBiomeSelector>();
        blacklistedBiomes = new HashSet<Biome>();
    }

    public static void registerJsonCapabilities(WorldGenRegistry.BiomeDataBaseJsonCapabilityRegistryEvent event) {
        event.register(NAME, jsonElement -> {
            JsonPrimitive primitive;
            if (jsonElement != null && jsonElement.isJsonPrimitive() && (primitive = jsonElement.getAsJsonPrimitive()).isString()) {
                String biomeMatch = primitive.getAsString();
                return b -> b.getRegistryName().toString().matches(biomeMatch);
            }
            return b -> false;
        });
        event.register(TYPE, jsonElement -> {
            if (jsonElement != null) {
                ArrayList<BiomeDictionary.Type> typesWhiteList = new ArrayList<BiomeDictionary.Type>();
                ArrayList<BiomeDictionary.Type> typesBlackList = new ArrayList<BiomeDictionary.Type>();
                if (jsonElement.isJsonPrimitive()) {
                    String typeMatch = jsonElement.getAsString();
                    List matches = Arrays.stream(typeMatch.split(",")).collect(Collectors.toList());
                    for (String match : matches) {
                        if (match.toCharArray()[0] == '!') {
                            typesBlackList.add(BiomeDictionary.Type.getType((String)match.substring(1), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                            continue;
                        }
                        typesWhiteList.add(BiomeDictionary.Type.getType((String)match, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                    }
                } else if (jsonElement.isJsonArray()) {
                    for (JsonElement element : jsonElement.getAsJsonArray()) {
                        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) continue;
                        String stringElem = element.getAsString();
                        if (stringElem.toCharArray()[0] == '!') {
                            typesBlackList.add(BiomeDictionary.Type.getType((String)stringElem.substring(1), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                            continue;
                        }
                        typesWhiteList.add(BiomeDictionary.Type.getType((String)stringElem, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                    }
                }
                return b -> BiomeDataBasePopulatorJson.biomeHasTypes(b, typesWhiteList) && (typesBlackList.size() == 0 || !BiomeDataBasePopulatorJson.biomeHasTypes(b, typesBlackList));
            }
            return b -> false;
        });
        event.register(SPECIES, new JsonBiomePropertyApplierSpecies());
        event.register(DENSITY, new JsonBiomePropertyApplierDensity());
        event.register(CHANCE, new JsonBiomePropertyApplierChance());
        event.register(CANCELVANILLA, (dbase, element, biome) -> {
            if (element.isJsonPrimitive()) {
                boolean cancel = element.getAsBoolean();
                dbase.setCancelVanillaTreeGen(biome, cancel);
            }
        });
        event.register(MULTIPASS, (dbase, element, biome) -> {
            boolean multipass;
            if (element.isJsonPrimitive() && (multipass = element.getAsBoolean())) {
                dbase.setMultipass(biome, pass -> {
                    switch (pass) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return 5;
                        }
                        case 2: {
                            return 3;
                        }
                    }
                    return -1;
                });
            }
        });
        event.register(SUBTERRANEAN, (dbase, element, biome) -> {
            if (element.isJsonPrimitive()) {
                boolean subterranean = element.getAsBoolean();
                dbase.setIsSubterranean(biome, subterranean);
            }
        });
        event.register(FORESTNESS, (dbase, element, biome) -> {
            if (element.isJsonPrimitive()) {
                float forestness = element.getAsFloat();
                dbase.setForestness(biome, forestness);
            }
        });
        event.register(BLACKLIST, (dbase, element, biome) -> {
            if (element.isJsonPrimitive()) {
                boolean blacklist = element.getAsBoolean();
                if (blacklist) {
                    blacklistedBiomes.add(biome);
                } else {
                    blacklistedBiomes.remove(biome);
                }
            }
        });
        event.register(RESET, (dbase, element, biome) -> {
            dbase.setCancelVanillaTreeGen(biome, false);
            dbase.setSpeciesSelector(biome, (pos, dirt, rnd) -> new BiomePropertySelectors.SpeciesSelection(), BiomeDataBase.Operation.REPLACE);
            dbase.setDensitySelector(biome, (rnd, nd) -> -1.0, BiomeDataBase.Operation.REPLACE);
            dbase.setChanceSelector(biome, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.UNHANDLED, BiomeDataBase.Operation.REPLACE);
            dbase.setForestness(biome, 0.0f);
            dbase.setIsSubterranean(biome, false);
            dbase.setMultipass(biome, pass -> pass == 0 ? 0 : -1);
        });
    }

    public BiomeDataBasePopulatorJson(ResourceLocation jsonLocation) {
        this(JsonHelper.load(jsonLocation));
    }

    public BiomeDataBasePopulatorJson(JsonElement jsonElement) {
        this.jsonElement = jsonElement;
    }

    @Override
    public void populate(BiomeDataBase biomeDataBase) {
        if (this.jsonElement != null && this.jsonElement.isJsonArray()) {
            for (JsonElement sectionElement : this.jsonElement.getAsJsonArray()) {
                if (!sectionElement.isJsonObject()) continue;
                JsonObject section = sectionElement.getAsJsonObject();
                this.readSection(section, biomeDataBase);
            }
        }
    }

    public static boolean biomeHasTypes(Biome biome, List<BiomeDictionary.Type> types) {
        return types.stream().allMatch(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t));
    }

    public static boolean isComment(String s) {
        return s.startsWith("__");
    }

    private void readSection(JsonObject section, BiomeDataBase dbase) {
        LinkedList<JsonBiomeSelectorData> selectors = new LinkedList<JsonBiomeSelectorData>();
        LinkedList<JsonBiomeApplierData> appliers = new LinkedList<JsonBiomeApplierData>();
        for (Map.Entry entry : section.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (BiomeDataBasePopulatorJson.isComment(key)) continue;
            if (WHITE.equals(key)) {
                if (!element.isJsonPrimitive() || !"all".equals(element.getAsString())) continue;
                blacklistedBiomes.clear();
                continue;
            }
            if (SELECT.equals(key)) {
                if (!element.isJsonObject()) continue;
                for (Map.Entry selectElement : element.getAsJsonObject().entrySet()) {
                    String selectorName = (String)selectElement.getKey();
                    if (BiomeDataBasePopulatorJson.isComment(selectorName)) continue;
                    IJsonBiomeSelector selector = jsonBiomeSelectorMap.get(selectorName);
                    if (selector != null) {
                        selectors.add(new JsonBiomeSelectorData(selector, (JsonElement)selectElement.getValue()));
                        continue;
                    }
                    System.err.println("Json Error: Undefined selector property \"" + selectorName + "\"");
                }
                continue;
            }
            if (APPLY.equals(key)) {
                if (!element.isJsonObject()) continue;
                for (Map.Entry selectElement : element.getAsJsonObject().entrySet()) {
                    String applierName = (String)selectElement.getKey();
                    if (BiomeDataBasePopulatorJson.isComment(applierName)) continue;
                    IJsonBiomeApplier applier = jsonBiomeApplierMap.get(applierName);
                    if (applier != null) {
                        appliers.add(new JsonBiomeApplierData(applier, (JsonElement)selectElement.getValue()));
                        continue;
                    }
                    System.err.println("Json Error: Undefined applier property \"" + applierName + "\"");
                }
                continue;
            }
            System.err.println("Json Error: Undefined operation \"" + key + "\"");
        }
        Stream<Object> stream = Lists.newArrayList((Iterable)Biome.field_185377_q).stream();
        for (JsonBiomeSelectorData s : selectors) {
            stream = stream.filter(s.getFilter());
        }
        stream = stream.filter(b -> !blacklistedBiomes.contains(b));
        stream.forEach(biome -> appliers.forEach(a -> a.apply(dbase, (Biome)biome)));
    }

    private class JsonBiomeApplierData {
        IJsonBiomeApplier applier;
        JsonElement elementData;

        JsonBiomeApplierData(IJsonBiomeApplier applier, JsonElement elementData) {
            this.applier = applier;
            this.elementData = elementData;
        }

        void apply(BiomeDataBase dbase, Biome biome) {
            this.applier.apply(dbase, this.elementData, biome);
        }
    }

    private class JsonBiomeSelectorData {
        final IJsonBiomeSelector selector;
        final JsonElement elementData;

        JsonBiomeSelectorData(IJsonBiomeSelector selector, JsonElement elementData) {
            this.selector = selector;
            this.elementData = elementData;
        }

        Predicate<Biome> getFilter() {
            return this.selector.getFilter(this.elementData);
        }
    }
}

