/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IGroundFinder;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDiscProviderUniversal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.RandomXOR;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TreeGenerator {
    protected static TreeGenerator INSTANCE;
    protected final BiomeDataBase defaultBiomeDataBase;
    public static final BiomeDataBase DIMENSIONBLACKLISTED;
    protected final PoissonDiscProviderUniversal circleProvider;
    protected final RandomXOR random = new RandomXOR();
    protected final Map<Integer, BiomeDataBase> dimensionMap = new HashMap<Integer, BiomeDataBase>();

    public static void preInit() {
        if (WorldGenRegistry.isWorldGenEnabled()) {
            new TreeGenerator();
        }
    }

    public TreeGenerator() {
        INSTANCE = this;
        this.defaultBiomeDataBase = new BiomeDataBase();
        this.circleProvider = new PoissonDiscProviderUniversal();
    }

    public static TreeGenerator getTreeGenerator() {
        return INSTANCE;
    }

    public BiomeDataBase getBiomeDataBase(int dimensionId) {
        return this.dimensionMap.getOrDefault(dimensionId, this.getDefaultBiomeDataBase());
    }

    public BiomeDataBase getBiomeDataBase(World world) {
        return this.getBiomeDataBase(world.field_73011_w.getDimension());
    }

    public BiomeDataBase getDefaultBiomeDataBase() {
        return this.defaultBiomeDataBase;
    }

    public void linkDimensionToDataBase(int dimensionId, BiomeDataBase dBase) {
        this.dimensionMap.put(dimensionId, dBase);
    }

    public void BlackListDimension(int dimensionId) {
        this.dimensionMap.put(dimensionId, DIMENSIONBLACKLISTED);
    }

    public void clearAllBiomeDataBases() {
        this.dimensionMap.clear();
        this.defaultBiomeDataBase.clear();
    }

    public boolean validateBiomeDataBases() {
        return this.defaultBiomeDataBase.isValid() && this.dimensionMap.values().stream().allMatch(db -> db.isValid());
    }

    public PoissonDiscProviderUniversal getCircleProvider() {
        return this.circleProvider;
    }

    public void makeWoolCircle(World world, PoissonDisc circle, int h, EnumGeneratorResult resultType, SafeChunkBounds safeBounds) {
        this.makeWoolCircle(world, circle, h, resultType, safeBounds, 0);
    }

    public void makeWoolCircle(World world, PoissonDisc circle, int h, EnumGeneratorResult resultType, SafeChunkBounds safeBounds, int flags) {
        for (int ix = -circle.radius; ix <= circle.radius; ++ix) {
            for (int iz = -circle.radius; iz <= circle.radius; ++iz) {
                if (!circle.isEdge(circle.x + ix, circle.z + iz)) continue;
                safeBounds.setBlockState(world, new BlockPos(circle.x + ix, h, circle.z + iz), Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)((circle.x ^ circle.z) & 0xF))), flags, true);
            }
        }
        if (resultType != EnumGeneratorResult.GENERATED) {
            BlockPos pos = new BlockPos(circle.x, h, circle.z);
            EnumDyeColor color = resultType.getColor();
            safeBounds.setBlockState(world, pos, Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)color), true);
            safeBounds.setBlockState(world, pos.func_177984_a(), Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)color), true);
        }
    }

    public EnumGeneratorResult makeTree(World world, BiomeDataBase biomeDataBase, PoissonDisc circle, IGroundFinder groundFinder, SafeChunkBounds safeBounds) {
        Species species;
        circle.add(8, 8);
        BlockPos pos = new BlockPos(circle.x, 0, circle.z);
        Biome biome = world.func_180494_b(pos);
        BiomeDataBase.BiomeEntry biomeEntry = biomeDataBase.getEntry(biome);
        pos = groundFinder.findGround(biomeEntry, world, pos);
        if (pos == BlockPos.field_177992_a) {
            return EnumGeneratorResult.NOGROUND;
        }
        this.random.setXOR(pos);
        IBlockState dirtState = world.func_180495_p(pos);
        EnumGeneratorResult result = EnumGeneratorResult.GENERATED;
        BiomePropertySelectors.SpeciesSelection speciesSelection = biomeEntry.getSpeciesSelector().getSpecies(pos, dirtState, this.random);
        result = speciesSelection.isHandled() ? ((species = speciesSelection.getSpecies()).isValid() ? (species.isAcceptableSoilForWorldgen(world, pos, dirtState) ? (biomeEntry.getChanceSelector().getChance(this.random, species, circle.radius) == BiomePropertySelectors.EnumChance.OK ? (species.generate(world, pos, biome, this.random, circle.radius, safeBounds) ? EnumGeneratorResult.GENERATED : EnumGeneratorResult.FAILGENERATION) : EnumGeneratorResult.FAILCHANCE) : EnumGeneratorResult.FAILSOIL) : EnumGeneratorResult.NOTREE) : EnumGeneratorResult.UNHANDLEDBIOME;
        if (ModConfigs.worldGenDebug) {
            this.makeWoolCircle(world, circle, pos.func_177956_o(), result, safeBounds);
        }
        circle.add(-8, -8);
        return result;
    }

    static {
        DIMENSIONBLACKLISTED = new BiomeDataBase();
    }

    public static enum EnumGeneratorResult {
        GENERATED(EnumDyeColor.WHITE),
        NOTREE(EnumDyeColor.BLACK),
        UNHANDLEDBIOME(EnumDyeColor.YELLOW),
        FAILSOIL(EnumDyeColor.BROWN),
        FAILCHANCE(EnumDyeColor.BLUE),
        FAILGENERATION(EnumDyeColor.RED),
        NOGROUND(EnumDyeColor.PURPLE);

        private final EnumDyeColor color;

        private EnumGeneratorResult(EnumDyeColor color) {
            this.color = color;
        }

        public EnumDyeColor getColor() {
            return this.color;
        }
    }
}

