/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.inventory.MalisisTab;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.clientnotif.ClientNotification;
import net.malisis.doors.DoorState;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.iconprovider.CamoFenceGateIconProvider;
import net.malisis.doors.renderer.FenceGateRenderer;
import net.malisis.doors.tileentity.FenceGateTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(value=FenceGateRenderer.class)
public class FenceGate
extends BlockFenceGate
implements IComponentProvider,
IRegisterable<Block> {
    protected final List<IComponent> components = Lists.newArrayList();

    public FenceGate(Type type) {
        super(type.type);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setName(type.registry);
        this.func_149663_c(type.unlocalized);
        if (type == Type.CAMO) {
            this.setCreativeTab((CreativeTabs)MalisisDoors.tab);
        }
        if (MalisisCore.isClient()) {
            if (type == Type.CAMO) {
                this.addComponent((IComponent)CamoFenceGateIconProvider.get());
            } else {
                Icon icon = Icon.from((IBlockState)Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)type.type));
                this.addComponent((IComponent)((IIconProvider)() -> icon));
            }
        }
    }

    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    public List<IComponent> getComponents() {
        return this.components;
    }

    public FenceGate setCreativeTab(CreativeTabs tab) {
        super.func_149647_a(tab);
        if (tab instanceof MalisisTab) {
            ((MalisisTab)tab).addItem((Block)this);
        }
        return this;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return;
        }
        te.updateAll();
        te = te.getDoubleDoor();
        if (te != null) {
            te.updateAll();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return true;
        }
        boolean opened = te.isOpened();
        te.openOrCloseDoor();
        if (opened) {
            return true;
        }
        EnumFacing facing = EntityUtils.getEntityFacing((Entity)player);
        if (state.func_177229_b((IProperty)field_185512_D) != facing.func_176734_d()) {
            return true;
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)facing));
        te = te.getDoubleDoor();
        if (te != null) {
            world.func_175656_a(te.func_174877_v(), state.func_177226_a((IProperty)field_185512_D, (Comparable)facing));
        }
        return true;
    }

    @ClientNotification
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos from) {
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return;
        }
        if (!world.field_72995_K) {
            boolean powered = world.func_175640_z(pos);
            if (powered || neighborBlock.func_176223_P().func_185897_m()) {
                te.setPowered(powered);
            }
        } else {
            te.updateAll();
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null || te.isMoving() || te.isOpened()) {
            return null;
        }
        return super.func_180646_a(state, world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        FenceGateTileEntity te = new FenceGateTileEntity();
        if (te.isOpened(state)) {
            te.setState(DoorState.OPENED);
        }
        return te;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static enum Type {
        OAK("minecraft:fence_gate", "fenceGate", BlockPlanks.EnumType.OAK),
        ACACIA("minecraft:acacia_fence_gate", "acaciaFenceGate", BlockPlanks.EnumType.ACACIA),
        BIRCH("minecraft:birch_fence_gate", "birchFenceGate", BlockPlanks.EnumType.BIRCH),
        DARK_OAK("minecraft:dark_oak_fence_gate", "darkOakFenceGate", BlockPlanks.EnumType.DARK_OAK),
        JUNGLE("minecraft:jungle_fence_gate", "jungleFenceGate", BlockPlanks.EnumType.JUNGLE),
        SPRUCE("minecraft:spruce_fence_gate", "spruceFenceGate", BlockPlanks.EnumType.SPRUCE),
        CAMO("malisisdoors:camoFenceGate", "camoFenceGate", BlockPlanks.EnumType.OAK);

        private BlockPlanks.EnumType type;
        private String registry;
        private String unlocalized;

        private Type(String registry, String unlocalized, BlockPlanks.EnumType type) {
            this.registry = registry;
            this.unlocalized = unlocalized;
            this.type = type;
        }
    }
}

