/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.descriptor;

import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.TrapDoorDescriptor;
import net.malisis.doors.movement.TrapDoorMovement;
import net.malisis.doors.sound.IronTrapDoorSound;
import net.malisis.doors.sound.WoodenTrapDoorSound;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;

public class VanillaTrapDoor
extends TrapDoorDescriptor {
    public VanillaTrapDoor(Type type) {
        boolean iron = type == Type.IRON;
        String name = iron ? "iron_trapdoor" : "trapdoor";
        this.setOpeningTime(6);
        this.setMaterial(iron ? Material.field_151573_f : Material.field_151575_d);
        this.setHardness(iron ? 5.0f : 3.0f);
        this.setSoundType(iron ? SoundType.field_185852_e : SoundType.field_185848_a);
        this.setRegistryName("minecraft:" + name);
        this.setUnlocalizedName(name);
        this.setTextureName("minecraft", "blocks/" + name);
        this.setRedstoneBehavior(iron ? DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY : DoorDescriptor.RedstoneBehavior.STANDARD);
        this.setMovement(DoorRegistry.getMovement(TrapDoorMovement.class));
        this.setSound(DoorRegistry.getSound(iron ? IronTrapDoorSound.class : WoodenTrapDoorSound.class));
        this.setTab(CreativeTabs.field_78028_d);
    }

    public static enum Type {
        WOOD,
        IRON;

    }
}

