/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class RotateAroundMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        return AABBUtils.rotate((AxisAlignedBB)IDoorMovement.getFullBoundingBox(topBlock, type), (int)(tileEntity.isHingeLeft() ? -1 : 1));
    }

    private Rotation getTransformation(DoorTileEntity tileEntity) {
        float angle = tileEntity.isHingeLeft() ? -90.0f : 90.0f;
        Rotation transformation = new Rotation(angle).aroundAxis(0.0f, 1.0f, 0.0f);
        transformation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        return (Rotation)transformation.forTicks(tileEntity.getDescriptor().getOpeningTime());
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, (Transformation)this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

