/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite.renders;

import com.chocohead.gravisuite.items.ItemAdvancedElectricJetpack;
import com.chocohead.gravisuite.items.ItemGeneralLappack;
import com.chocohead.gravisuite.renders.PrettyUtil;
import ic2.api.item.ElectricItem;
import ic2.core.init.Localization;
import ic2.core.item.armor.jetpack.IJetpack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GravisuiteOverlay {
    public static boolean hudEnabled = true;
    public static byte hudPos = 1;

    public GravisuiteOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Minecraft mc = PrettyUtil.mc;
        if (hudEnabled && mc.field_71441_e != null && mc.field_71415_G && Minecraft.func_71382_s() && !mc.field_71474_y.field_74330_P) {
            float chargeLevel;
            Item item;
            ItemStack stack = mc.field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.CHEST.func_188454_b());
            if (stack == null || (item = stack.func_77973_b()) == null) {
                return;
            }
            FontRenderer fontRenderer = mc.field_71466_p;
            String energyLevel = "";
            int energyLevelWidth = 0;
            String status = "";
            int statusWidth = 0;
            if (item instanceof ItemGeneralLappack) {
                chargeLevel = (float)(ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack) * 100.0);
                energyLevel = Localization.translate((String)"gravisuite.message.energy", (Object[])new Object[]{GravisuiteOverlay.getEnergyStatus(chargeLevel)});
                energyLevelWidth = fontRenderer.func_78256_a(Localization.translate((String)"gravisuite.message.energy", (Object[])new Object[]{Integer.toString(Math.round(chargeLevel))}));
            } else if (item instanceof ItemAdvancedElectricJetpack) {
                chargeLevel = (float)((IJetpack)item).getChargeLevel(stack) * 100.0f;
                energyLevel = Localization.translate((String)"gravisuite.message.energy", (Object[])new Object[]{GravisuiteOverlay.getEnergyStatus(chargeLevel)});
                energyLevelWidth = fontRenderer.func_78256_a(Localization.translate((String)"gravisuite.message.energy", (Object[])new Object[]{Integer.toString(Math.round(chargeLevel))}));
                if (ItemAdvancedElectricJetpack.isJetpackOn(stack)) {
                    String hoverModeStatus = ItemAdvancedElectricJetpack.isHovering(stack) ? Localization.translate((String)"gravisuite.message.hover") : "";
                    status = TextFormatting.GREEN + Localization.translate((String)"gravisuite.message.jetpackEngine", (Object[])new Object[]{TextFormatting.YELLOW + hoverModeStatus});
                    statusWidth = fontRenderer.func_78256_a(Localization.translate((String)"gravisuite.message.jetpackEngine", (Object[])new Object[]{hoverModeStatus}));
                }
            }
            if (!energyLevel.isEmpty()) {
                int fontHeight = fontRenderer.field_78288_b;
                int yOffset = 3;
                int xPos = 0;
                int yPos = 0;
                int xPos2 = 0;
                int yPos2 = 0;
                switch (hudPos) {
                    case 1: {
                        xPos = 2;
                        xPos2 = 2;
                        yPos = 2;
                        yPos2 = 5 + fontHeight;
                        break;
                    }
                    case 2: {
                        int width = new ScaledResolution(mc).func_78326_a();
                        if (!status.isEmpty()) {
                            xPos = width - statusWidth - 2;
                        }
                        xPos2 = width - energyLevelWidth - 2;
                        yPos = 2;
                        yPos2 = 5 + fontHeight;
                        break;
                    }
                    case 3: {
                        xPos = 2;
                        xPos2 = 2;
                        yPos = new ScaledResolution(mc).func_78326_a() - 2 - fontHeight;
                        yPos2 = yPos - 3 - fontHeight;
                        break;
                    }
                    case 4: {
                        ScaledResolution size = new ScaledResolution(mc);
                        int width = size.func_78326_a();
                        if (!status.isEmpty()) {
                            xPos = width - statusWidth - 2;
                        }
                        xPos2 = width - energyLevelWidth - 2;
                        yPos = size.func_78328_b() - 2 - fontHeight;
                        yPos2 = yPos - 3 - fontHeight;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid value of HUD pos: expected 1-4, got " + hudPos + '!');
                    }
                }
                if (!status.isEmpty()) {
                    mc.field_71456_v.func_73731_b(fontRenderer, status, xPos, yPos, 0xFFFFFF);
                    mc.field_71456_v.func_73731_b(fontRenderer, energyLevel, xPos2, yPos2, 0xFFFFFF);
                } else {
                    mc.field_71456_v.func_73731_b(fontRenderer, energyLevel, xPos2, yPos, 0xFFFFFF);
                }
            }
        }
    }

    public static String getEnergyStatus(float energyStatus) {
        if (energyStatus <= 10.0f) {
            if (energyStatus <= 5.0f) {
                return TextFormatting.RED + Integer.toString(Math.round(energyStatus)) + '%';
            }
            return TextFormatting.GOLD + Integer.toString(Math.round(energyStatus)) + '%';
        }
        return Integer.toString(Math.round(energyStatus)) + '%';
    }
}

