/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.helper.CuriosHelper;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityHelper {
    public static final String NBT_PLAYER_PERSISTED = "PlayerPersisted";

    public static boolean autoEquip(ItemStack stack, PlayerEntity player) {
        if (stack.func_190926_b()) {
            return false;
        }
        ResourceLocation registryName = stack.func_77973_b().getRegistryName();
        if (registryName == null) {
            return false;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) > 0) {
            return false;
        }
        if (stack.func_77976_d() == 1) {
            if (ModList.get().isLoaded("curios") && CuriosHelper.autoEquip(stack, player)) {
                return true;
            }
            if (player.func_184592_cb().func_190926_b() && stack.func_77973_b().isShield(stack, (LivingEntity)player) && player.func_174820_d(99, stack.func_77946_l())) {
                return true;
            }
            EquipmentSlotType slot = stack.func_77973_b().getEquipmentSlot(stack);
            boolean isElytra = false;
            if (slot == null) {
                if (stack.func_77973_b() instanceof ArmorItem) {
                    slot = ((ArmorItem)stack.func_77973_b()).func_185083_B_();
                } else {
                    if (!(stack.func_77973_b() instanceof ElytraItem)) {
                        return false;
                    }
                    slot = EquipmentSlotType.CHEST;
                    isElytra = true;
                }
            } else if (slot == EquipmentSlotType.CHEST) {
                isElytra = stack.func_77973_b() instanceof ElytraItem;
            }
            int slotId = slot.func_188454_b();
            ItemStack stackInSlot = (ItemStack)player.field_71071_by.field_70460_b.get(slotId);
            if (stackInSlot.func_190926_b()) {
                player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
                return true;
            }
            if (slot != EquipmentSlotType.CHEST) {
                return false;
            }
            if (isElytra) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stackInSlot.func_77946_l());
                player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof PlayerEntity && !(entity instanceof FakePlayer);
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static CompoundNBT getPersistentTag(PlayerEntity player) {
        CompoundNBT persistentData = player.getPersistentData();
        if (persistentData.func_74764_b(NBT_PLAYER_PERSISTED)) {
            CompoundNBT persistentTag = (CompoundNBT)persistentData.func_74781_a(NBT_PLAYER_PERSISTED);
            return persistentTag;
        }
        CompoundNBT persistentTag = new CompoundNBT();
        persistentData.func_218657_a(NBT_PLAYER_PERSISTED, (INBT)persistentTag);
        return persistentTag;
    }
}

