/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.gui.screen.Screen;

public class CombinedMouseHandler
implements IMouseHandler {
    private final Int2ObjectMap<IMouseHandler> mousedDown = new Int2ObjectArrayMap();
    private final List<IMouseHandler> mouseHandlers;

    public CombinedMouseHandler(IMouseHandler ... mouseHandlers) {
        this.mouseHandlers = Arrays.asList(mouseHandlers);
    }

    public CombinedMouseHandler(List<IMouseHandler> mouseHandlers) {
        this.mouseHandlers = mouseHandlers;
    }

    @Override
    public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        switch (clickState) {
            case VANILLA: {
                return this.handleVanillaClick(screen, mouseX, mouseY, mouseButton);
            }
            case SIMULATE: {
                return this.handleSimulateClick(screen, mouseX, mouseY, mouseButton);
            }
            case EXECUTE: {
                return this.handleExecuteClick(screen, mouseX, mouseY, mouseButton);
            }
        }
        return null;
    }

    @Nullable
    private IMouseHandler handleVanillaClick(Screen screen, double mouseX, double mouseY, int mouseButton) {
        this.mousedDown.remove(mouseButton);
        IMouseHandler handled = this.handleClickInternal(screen, mouseX, mouseY, mouseButton, MouseClickState.VANILLA);
        if (handled == null) {
            return null;
        }
        return this;
    }

    @Nullable
    private IMouseHandler handleSimulateClick(Screen screen, double mouseX, double mouseY, int mouseButton) {
        this.mousedDown.remove(mouseButton);
        IMouseHandler clickHandled = this.handleClickInternal(screen, mouseX, mouseY, mouseButton, MouseClickState.SIMULATE);
        if (clickHandled == null) {
            return null;
        }
        this.mousedDown.put(mouseButton, (Object)clickHandled);
        return this;
    }

    @Nullable
    private IMouseHandler handleExecuteClick(Screen screen, double mouseX, double mouseY, int mouseButton) {
        IMouseHandler mouseHandler = (IMouseHandler)this.mousedDown.remove(mouseButton);
        if (mouseHandler == null) {
            return null;
        }
        IMouseHandler handled = mouseHandler.handleClick(screen, mouseX, mouseY, mouseButton, MouseClickState.EXECUTE);
        if (handled == null) {
            return null;
        }
        return this;
    }

    @Nullable
    private IMouseHandler handleClickInternal(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState mouseClickState) {
        IMouseHandler firstHandled = null;
        for (IMouseHandler mouseHandler : this.mouseHandlers) {
            if (firstHandled == null) {
                firstHandled = mouseHandler.handleClick(screen, mouseX, mouseY, mouseButton, mouseClickState);
                if (firstHandled != null) continue;
                mouseHandler.handleMouseClickedOut(mouseButton);
                continue;
            }
            mouseHandler.handleMouseClickedOut(mouseButton);
        }
        return firstHandled;
    }

    @Override
    public void handleMouseClickedOut(int mouseButton) {
        for (IMouseHandler mouseHandler : this.mouseHandlers) {
            mouseHandler.handleMouseClickedOut(mouseButton);
        }
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        for (IMouseHandler mouseHandler : this.mouseHandlers) {
            if (!mouseHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta)) continue;
            return true;
        }
        return false;
    }
}

