/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientRenderHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <V> List<ITextComponent> getIngredientTooltipSafe(V ingredient, IIngredientRenderer<V> ingredientRenderer, IIngredientHelper<V> ingredientHelper, IModIdHelper modIdHelper) {
        try {
            Minecraft minecraft = Minecraft.func_71410_x();
            ITooltipFlag.TooltipFlags tooltipFlag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List<ITextComponent> tooltip = ingredientRenderer.getTooltip(ingredient, (ITooltipFlag)tooltipFlag);
            tooltip = modIdHelper.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
            return tooltip;
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Tooltip crashed.", e);
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            TranslationTextComponent translated = new TranslationTextComponent("jei.tooltip.error.crash");
            tooltip.add((ITextComponent)translated.func_240699_a_(TextFormatting.RED));
            return tooltip;
        }
    }
}

