/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.util.IAFMath;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.MathHelper;

public class IceAndFireTabulaModelAnimator {
    protected TabulaModel baseModel;

    public IceAndFireTabulaModelAnimator(TabulaModel baseModel) {
        this.baseModel = baseModel;
    }

    public void setRotateAngle(AdvancedModelBox model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += limbSwingAmount * this.distance(model.field_78795_f, x);
        model.field_78796_g += limbSwingAmount * this.distance(model.field_78796_g, y);
        model.field_78808_h += limbSwingAmount * this.distance(model.field_78808_h, z);
    }

    public void addToRotateAngle(AdvancedModelBox model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationX, x);
        model.field_78796_g += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationY, y);
        model.field_78808_h += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationZ, z);
    }

    public boolean isRotationEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose != null && pose.field_78795_f == original.defaultRotationX && pose.field_78796_g == original.defaultRotationY && pose.field_78808_h == original.defaultRotationZ;
    }

    public boolean isPositionEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose.field_78800_c == original.defaultPositionX && pose.field_78797_d == original.defaultPositionY && pose.field_78798_e == original.defaultPositionZ;
    }

    public void transitionTo(AdvancedModelBox from, AdvancedModelBox to, float timer, float maxTime, boolean oldFashioned) {
        if (oldFashioned) {
            from.field_78795_f += (to.field_78795_f - from.field_78795_f) / maxTime * timer;
            from.field_78796_g += (to.field_78796_g - from.field_78796_g) / maxTime * timer;
            from.field_78808_h += (to.field_78808_h - from.field_78808_h) / maxTime * timer;
        } else {
            this.transitionAngles(from, to, timer, maxTime);
        }
        from.field_78800_c += (to.field_78800_c - from.field_78800_c) / maxTime * timer;
        from.field_78797_d += (to.field_78797_d - from.field_78797_d) / maxTime * timer;
        from.field_78798_e += (to.field_78798_e - from.field_78798_e) / maxTime * timer;
    }

    public void transitionAngles(AdvancedModelBox from, AdvancedModelBox to, float timer, float maxTime) {
        from.field_78795_f += this.distance(from.field_78795_f, to.field_78795_f) / maxTime * timer;
        from.field_78796_g += this.distance(from.field_78796_g, to.field_78796_g) / maxTime * timer;
        from.field_78808_h += this.distance(from.field_78808_h, to.field_78808_h) / maxTime * timer;
    }

    public float distance(float rotateAngleFrom, float rotateAngleTo) {
        return (float)IAFMath.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
    }

    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void moveToPoseSameModel(TabulaModel model, TabulaModel modelTo) {
        this.moveToPoseSameModel(model, modelTo, false);
    }

    public void moveToPoseSameModel(TabulaModel model, TabulaModel modelTo, boolean membraneFlag) {
        Map modelMap = model.getCubes();
        Map modelToMap = modelTo.getCubes();
        Map baseModelMap = this.baseModel.getCubes();
        if (modelMap.size() == modelToMap.size() && modelToMap.size() == baseModelMap.size()) {
            Iterator modelIter = modelMap.entrySet().iterator();
            Iterator modelToIter = modelToMap.entrySet().iterator();
            Iterator baseModelIter = baseModelMap.entrySet().iterator();
            while (modelIter.hasNext()) {
                float toZ;
                float toY;
                float toX;
                AdvancedModelBox cube = (AdvancedModelBox)modelIter.next().getValue();
                AdvancedModelBox modelToCube = (AdvancedModelBox)modelToIter.next().getValue();
                AdvancedModelBox baseCube = (AdvancedModelBox)baseModelIter.next().getValue();
                if (!this.isRotationEqual(baseCube, modelToCube)) {
                    toX = modelToCube.field_78795_f;
                    toY = modelToCube.field_78796_g;
                    toZ = modelToCube.field_78808_h;
                    if (!membraneFlag || cube.boxName == null || !cube.boxName.toLowerCase().contains("membrane")) {
                        model.llibAnimator.rotate(cube, this.distance(cube.field_78795_f, toX), this.distance(cube.field_78796_g, toY), this.distance(cube.field_78808_h, toZ));
                    }
                }
                if (this.isPositionEqual(baseCube, modelToCube)) continue;
                toX = modelToCube.field_78800_c;
                toY = modelToCube.field_78797_d;
                toZ = modelToCube.field_78798_e;
                model.llibAnimator.move(cube, this.distance(cube.field_78800_c, toX), this.distance(cube.field_78797_d, toY), this.distance(cube.field_78798_e, toZ));
            }
        } else {
            this.moveToPose(model, modelTo);
        }
    }

    public void moveToPose(TabulaModel model, TabulaModel modelTo) {
        for (AdvancedModelBox cube : model.getCubes().values()) {
            float toZ;
            float toY;
            float toX;
            AdvancedModelBox cubeTo = modelTo.getCube(cube.boxName);
            if (!this.isRotationEqual(this.baseModel.getCube(cube.boxName), cubeTo)) {
                toX = cubeTo.field_78795_f;
                toY = cubeTo.field_78796_g;
                toZ = cubeTo.field_78808_h;
                model.llibAnimator.rotate(cube, this.distance(cube.field_78795_f, toX), this.distance(cube.field_78796_g, toY), this.distance(cube.field_78808_h, toZ));
            }
            if (this.isPositionEqual(this.baseModel.getCube(cube.boxName), cubeTo)) continue;
            toX = cubeTo.field_78800_c;
            toY = cubeTo.field_78797_d;
            toZ = cubeTo.field_78798_e;
            model.llibAnimator.move(cube, this.distance(cube.field_78800_c, toX), this.distance(cube.field_78797_d, toY), this.distance(cube.field_78798_e, toZ));
        }
    }
}

