/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.item.IProtectAgainstDragonItem;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDragonsteelArmor
extends ArmorItem
implements IProtectAgainstDragonItem {
    private IArmorMaterial material;
    private Multimap<Attribute, AttributeModifier> attributeModifierMultimap;
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public ItemDragonsteelArmor(IArmorMaterial material, int renderIndex, EquipmentSlotType slot, String gameName, String name) {
        super(material, slot, new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS));
        this.material = material;
        this.setRegistryName("iceandfire", gameName);
        this.attributeModifierMultimap = this.createAttributeMap();
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[this.field_77881_a.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.material.func_200902_b(this.field_77881_a), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.material.func_200901_e(), AttributeModifier.Operation.ADDITION));
        if (this.field_234655_c_ > 0.0f) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.field_234655_c_, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    private Multimap<Attribute, AttributeModifier> getOrUpdateAttributeMap() {
        if (this.attributeModifierMultimap.containsKey((Object)Attributes.field_233826_i_) && !this.attributeModifierMultimap.get((Object)Attributes.field_233826_i_).isEmpty() && this.attributeModifierMultimap.get((Object)Attributes.field_233826_i_).toArray()[0] instanceof AttributeModifier && ((AttributeModifier)this.attributeModifierMultimap.get((Object)Attributes.field_233826_i_).toArray()[0]).func_111164_d() != (double)this.func_200881_e()) {
            this.attributeModifierMultimap = this.createAttributeMap();
        }
        return this.attributeModifierMultimap;
    }

    public int getMaxDamage(ItemStack stack) {
        if (this.field_77881_a != null) {
            return this.func_200880_d().func_200896_a(this.field_77881_a);
        }
        return super.getMaxDamage(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity LivingEntity2, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        int legs = 11;
        int armor = 10;
        if (this.material == IafItemRegistry.DRAGONSTEEL_ICE_ARMOR_MATERIAL) {
            legs = 13;
            armor = 12;
        }
        if (this.material == IafItemRegistry.DRAGONSTEEL_LIGHTNING_ARMOR_MATERIAL) {
            legs = 21;
            armor = 20;
        }
        return (A)((BipedModel)IceAndFire.PROXY.getArmorModel(this.field_77881_a == EquipmentSlotType.LEGS ? legs : armor));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.dragonscales_armor.desc").func_240699_a_(TextFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == this.field_77881_a ? this.getOrUpdateAttributeMap() : super.func_111205_h(equipmentSlot);
    }

    public int func_200881_e() {
        if (this.material != null) {
            return this.material.func_200902_b(this.func_185083_B_());
        }
        return super.func_200881_e();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this.material == IafItemRegistry.DRAGONSTEEL_FIRE_ARMOR_MATERIAL) {
            return "iceandfire:textures/models/armor/armor_dragonsteel_fire" + (slot == EquipmentSlotType.LEGS ? "_legs.png" : ".png");
        }
        if (this.material == IafItemRegistry.DRAGONSTEEL_ICE_ARMOR_MATERIAL) {
            return "iceandfire:textures/models/armor/armor_dragonsteel_ice" + (slot == EquipmentSlotType.LEGS ? "_legs.png" : ".png");
        }
        return "iceandfire:textures/models/armor/armor_dragonsteel_lightning" + (slot == EquipmentSlotType.LEGS ? "_legs.png" : ".png");
    }
}

