/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageDeathWormHitbox {
    public int deathWormId;
    public float scale;

    public MessageDeathWormHitbox(int deathWormId, float scale) {
        this.deathWormId = deathWormId;
        this.scale = scale;
    }

    public MessageDeathWormHitbox() {
    }

    public static MessageDeathWormHitbox read(PacketBuffer buf) {
        return new MessageDeathWormHitbox(buf.readInt(), buf.readFloat());
    }

    public static void write(MessageDeathWormHitbox message, PacketBuffer buf) {
        buf.writeInt(message.deathWormId);
        buf.writeFloat(message.scale);
    }

    public static class Handler {
        public static void handle(MessageDeathWormHitbox message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.deathWormId)) != null && entity instanceof EntityDeathWorm) {
                EntityDeathWorm worm = (EntityDeathWorm)entity;
                worm.initSegments(message.scale);
            }
        }
    }
}

