/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetworkManager;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;

public class WorldData
extends CacheLoader<Class, WorldData> {
    private static String DAYTIME = Constants.getString("jm.theme.labelsource.gametime.day");
    private static String SUNRISE = Constants.getString("jm.theme.labelsource.gametime.sunrise");
    private static String SUNSET = Constants.getString("jm.theme.labelsource.gametime.sunset");
    private static String NIGHT = Constants.getString("jm.theme.labelsource.gametime.night");
    String name;
    String dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;
    int browser_poll;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.INSTANCE.getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            Minecraft mc;
            String serverName;
            block9: {
                serverName = null;
                mc = Minecraft.func_71410_x();
                if (!mc.func_71356_B()) {
                    try {
                        RealmsScreen realmsScreen;
                        ClientPlayNetHandler netHandler = mc.func_147114_u();
                        Screen guiScreenServer = (Screen)ObfuscationReflectionHelper.getPrivateValue(ClientPlayNetHandler.class, (Object)netHandler, (String)"field_147307_j");
                        if (!(guiScreenServer instanceof RealmsScreen) || !((realmsScreen = (RealmsScreen)guiScreenServer) instanceof RealmsMainScreen)) break block9;
                        RealmsMainScreen mainScreen = (RealmsMainScreen)realmsScreen;
                        long selectedServerId = (Long)ObfuscationReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String)"field_224021_j");
                        List mcoServers = (List)ObfuscationReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String)"field_224028_q");
                        for (RealmsServer mcoServer : mcoServers) {
                            if (mcoServer.field_230582_a_ != selectedServerId) continue;
                            serverName = mcoServer.field_230584_c_;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                    }
                }
            }
            if (serverName != null) {
                return serverName;
            }
            mc = Minecraft.func_71410_x();
            ServerData serverData = mc.func_147104_D();
            if (serverData != null && (serverName = serverData.field_78847_a) != null) {
                if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                    serverName = serverData.field_78845_b;
                }
                return serverName;
            }
            return null;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName();
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            NetworkManager netManager = Minecraft.func_71410_x().func_147114_u().func_147298_b();
            if (netManager != null && (socketAddress = netManager.func_74430_c()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static String getWorldName(Minecraft mc) {
        String serverName = null;
        if (mc.func_71356_B()) {
            return mc.func_71401_C().field_71310_m.func_237282_a_();
        }
        serverName = WorldData.getServerName();
        if (serverName == null) {
            return "offline";
        }
        if (Strings.isNullOrEmpty((String)serverName.trim())) {
            serverName = "unnamed";
        }
        return serverName.trim();
    }

    public static List<DimensionProvider> getDimensionProviders() {
        return WorldData.getDimensionProviders(Lists.newArrayList());
    }

    public static List<DimensionProvider> getDimensionProviders(List<String> requiredDimensionList) {
        try {
            HashSet<String> requiredDims = new HashSet<String>(requiredDimensionList);
            HashMap<String, DimensionProvider> dimProviders = new HashMap<String, DimensionProvider>();
            Level logLevel = Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            Minecraft mc = Minecraft.func_71410_x();
            RegistryKey<World> dimension = DimensionHelper.getDimension((Entity)mc.field_71439_g);
            String dimId = DimensionHelper.getDimKeyName(dimension);
            WrappedProvider playerDimProvider = new WrappedProvider(dimension);
            dimProviders.put(dimId, playerDimProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerDimProvider)));
            for (RegistryKey<World> registryKey : DimensionHelper.getClientDimList()) {
                try {
                    WrappedProvider dimProvider = new WrappedProvider(registryKey);
                    dimProviders.put(DimensionHelper.getDimKeyName(registryKey), dimProvider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", registryKey, WorldData.getSafeDimensionName(dimProvider)));
                }
                catch (Throwable t) {
                    JMLogger.logOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", registryKey, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (String string : requiredDims) {
                if (dimProviders.containsKey(string)) continue;
                dimProviders.put(string, new DummyProvider(DimensionHelper.getWorldKeyForName(string)));
                Journeymap.getLogger().warn(String.format("Used DummyProvider for required dim: %s", string));
            }
            ArrayList<DimensionProvider> providerList = new ArrayList<DimensionProvider>(dimProviders.values());
            Collections.sort(providerList, new Comparator<DimensionProvider>(){

                @Override
                public int compare(DimensionProvider o1, DimensionProvider o2) {
                    return String.valueOf(o1.getDimensionId()).compareTo(o2.getDimensionId());
                }
            });
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(DimensionProvider dimensionProvider) {
        if (dimensionProvider == null || dimensionProvider.getDimensionId() == null) {
            return null;
        }
        try {
            return dimensionProvider.getDimensionId();
        }
        catch (Exception e) {
            Minecraft mc = Minecraft.func_71410_x();
            return Constants.getString("jm.common.dimension", DimensionHelper.getDimName((World)mc.field_71441_e));
        }
    }

    public static String getDimension() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        String dim = DimensionHelper.getDimName((Entity)player);
        String dimName = WorldData.getSafeDimensionName(new WrappedProvider((RegistryKey<World>)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_()));
        return dimName + " (" + dim + ")";
    }

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld.ClientWorldInfo worldInfo = mc.field_71441_e.func_72912_H();
        IntegratedServer server = mc.func_71401_C();
        boolean multiplayer = server == null || server.func_71344_c();
        this.name = WorldData.getWorldName(mc);
        this.dimension = DimensionHelper.getDimKeyName((World)mc.field_71441_e);
        this.hardcore = worldInfo.func_76093_s();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_71441_e.func_72820_D() % 24000L;
        this.features = FeatureManager.getInstance().getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = (String)DownloadingPackFinder.func_195742_b().get("X-Minecraft-Version");
        this.browser_poll = Math.max(1000, JourneymapClient.getInstance().getCoreProperties().browserPoll.get());
        return this;
    }

    public static String getLightLevel() {
        BlockPos blockpos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Chunk chunk = world.func_175726_f(blockpos);
        int light = chunk.func_217307_e().func_227470_b_(blockpos, 0);
        int lightSky = world.func_226658_a_(LightType.SKY, blockpos);
        int lightBlock = world.func_226658_a_(LightType.BLOCK, blockpos);
        return String.format("Light: %s (%s sky, %s block)", light, lightSky, lightBlock);
    }

    public static String getRegion() {
        BlockPos blockpos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_175726_f(blockpos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        return "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
    }

    public static String getRealGameTime() {
        String format = JourneymapClient.getInstance().getActiveMiniMapProperties().gameTimeRealFormat.get();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        Minecraft minecraft = Minecraft.func_71410_x();
        long time = minecraft.field_71441_e.func_72820_D();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        double ticks = (double)time - Math.floor((double)time / 16.666666666666668) * 16.666666666666668;
        long seconds = (long)Math.floor(ticks / 0.2777777777777778);
        try {
            String timeString = String.format(Locale.ENGLISH, "%02d:%02d:%02d", Math.max(0L, hour), Math.max(0L, minute), Math.max(0L, seconds));
            String formattedTime = LocalTime.parse(timeString).format(dtf);
            return formattedTime + " " + WorldData.getContextTime(time % 24000L);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Unable to calculate time for GameTimeReal time:{}, hour:{}, minute:{}, seconds:{}, ticks:{}", (Object)time, (Object)hour, (Object)minute, (Object)ticks, (Object)seconds, (Object)e);
            return "00e:00e:00e";
        }
    }

    public static String getMoonPhase() {
        int phase = Minecraft.func_71410_x().field_71441_e.func_242414_af();
        long worldTime = Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L;
        if (WorldData.isDay(worldTime)) {
            phase = 10;
        }
        return MoonPhase.fromPhase(phase);
    }

    public static String getSystemTime() {
        SimpleDateFormat timeFormat = new SimpleDateFormat(JourneymapClient.getInstance().getActiveMiniMapProperties().systemTimeRealFormat.get());
        return timeFormat.format(new Date());
    }

    public static String getGameTime() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            long worldTime = Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L;
            long allSecs = worldTime / 20L;
            return String.format("%02d:%02d %s", (long)Math.floor(allSecs / 60L), (long)Math.ceil(allSecs % 60L), WorldData.getContextTime(worldTime));
        }
        return "";
    }

    private static String getContextTime(long worldTime) {
        if (worldTime < 12000L) {
            return DAYTIME;
        }
        if (worldTime < 13800L) {
            return SUNSET;
        }
        if (worldTime < 22200L) {
            return NIGHT;
        }
        return SUNRISE;
    }

    public static boolean isDay(long worldTime) {
        return worldTime % 24000L < 13800L;
    }

    public static boolean isNight(long worldTime) {
        return worldTime % 24000L >= 13800L;
    }

    public long getTTL() {
        return 1000L;
    }

    static enum MoonPhase {
        DAY_TIME(10, "jm.theme.labelsource.moonphase.day"),
        FULL_MOON(0, "jm.theme.labelsource.moonphase.full_moon"),
        WANING_GIBBOUS(1, "jm.theme.labelsource.moonphase.waning_gibbous"),
        THIRD_QUARTER(2, "jm.theme.labelsource.moonphase.third_quarter"),
        WANING_CRESCENT(3, "jm.theme.labelsource.moonphase.waning_crescent"),
        NEW_MOON(4, "jm.theme.labelsource.moonphase.new_moon"),
        WAXING_CRESCENT(5, "jm.theme.labelsource.moonphase.waxing_crescent"),
        FIRST_QUARTER(6, "jm.theme.labelsource.moonphase.first_quarter"),
        WAXING_GIBBOUS(7, "jm.theme.labelsource.moonphase.waxing_gibbous");

        final int phase;
        final String key;
        static final Map<Integer, String> PHASE_MAP;

        private MoonPhase(int phase, String key) {
            this.phase = phase;
            this.key = key;
        }

        public static String fromPhase(int phase) {
            String phaseName = Constants.getString(PHASE_MAP.get(phase));
            String moonPhase = Constants.getString("jm.theme.labelsource.moonphase.pre");
            return moonPhase + phaseName;
        }

        static {
            PHASE_MAP = Stream.of(MoonPhase.values()).collect(Collectors.toMap(e -> e.phase, e -> e.key));
        }
    }

    static class DummyProvider
    implements DimensionProvider {
        final RegistryKey<World> dim;

        DummyProvider(RegistryKey<World> dim) {
            this.dim = dim;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dim);
        }

        @Override
        public RegistryKey<World> getDimension() {
            return null;
        }

        @Override
        public String getName() {
            return "Dimension " + DimensionHelper.getDimName(this.dim);
        }
    }

    public static class WrappedProvider
    implements DimensionProvider {
        RegistryKey<World> dimension;

        public WrappedProvider(RegistryKey<World> dimension) {
            this.dimension = dimension;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dimension);
        }

        @Override
        public RegistryKey<World> getDimension() {
            return this.dimension;
        }

        @Override
        public String getName() {
            String dim = DimensionHelper.getDimName(this.dimension).replace("_", " ");
            return WordUtils.capitalize((String)dim);
        }
    }

    public static interface DimensionProvider {
        public String getDimensionId();

        public RegistryKey<World> getDimension();

        public String getName();
    }
}

