/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties;

import com.google.common.collect.Lists;
import java.util.List;
import journeymap.common.properties.catagory.Category;

public class ClientCategory {
    private static int order = 1;
    public static final List<Category> values = Lists.newArrayList((Object[])new Category[]{Category.Inherit, Category.Hidden});
    public static final Category MiniMap1 = ClientCategory.create("MiniMap1", "jm.config.category.minimap");
    public static final Category MiniMap2 = ClientCategory.create("MiniMap2", "jm.config.category.minimap2");
    public static final Category FullMap = ClientCategory.create("FullMap", "jm.config.category.fullmap");
    public static final Category WebMap = ClientCategory.create("WebMap", "jm.config.category.webmap");
    public static final Category Waypoint = ClientCategory.create("Waypoint", "jm.config.category.waypoint");
    public static final Category WaypointBeacon = ClientCategory.create("WaypointBeacon", "jm.config.category.waypoint_beacons");
    public static final Category Cartography = ClientCategory.create("Cartography", "jm.config.category.cartography");
    public static final Category Advanced = ClientCategory.create("Advanced", "jm.config.category.advanced");
    public static final Category MinimapPosition = ClientCategory.create("Position", "jm.config.category.minimap_position", true);

    public static Category create(String name, String key) {
        return ClientCategory.create(name, key, false);
    }

    public static Category create(String name, String key, boolean unique) {
        Category cat = new Category(name, order++, key, unique);
        values.add(cat);
        return cat;
    }

    public static Category create(String name, String key, String tooltip) {
        Category cat = new Category(name, order++, key, tooltip);
        values.add(cat);
        return cat;
    }

    public static Category valueOf(String name) {
        for (Category category : values) {
            if (!category.getName().equalsIgnoreCase(name)) continue;
            return category;
        }
        return null;
    }
}

