/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.mojang.blaze3d.matrix.MatrixStack;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.ClientCategory;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;

public class AutoMapConfirmation
extends JmUI {
    Button buttonOptions;
    Button buttonAll;
    Button buttonMissing;
    Button buttonClose;

    public AutoMapConfirmation() {
        this((JmUI)null);
    }

    public AutoMapConfirmation(JmUI returnDisplay) {
        super(Constants.getString("jm.common.automap_dialog"), returnDisplay);
    }

    @Override
    public void func_231160_c_() {
        this.field_230710_m_.clear();
        super.setRenderBottomBar(true);
        this.buttonOptions = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Cartography)));
        this.buttonAll = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.common.automap_dialog_all"), button -> this.initAutoMapping(true, Boolean.TRUE)));
        this.buttonMissing = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.common.automap_dialog_missing"), button -> this.initAutoMapping(true, Boolean.FALSE)));
        this.buttonClose = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonOptions.setDefaultStyle(false);
        this.buttonAll.setDefaultStyle(false);
        this.buttonMissing.setDefaultStyle(false);
        this.buttonClose.setDefaultStyle(false);
        this.field_230710_m_.add(this.buttonOptions);
        this.field_230710_m_.add(this.buttonAll);
        this.field_230710_m_.add(this.buttonMissing);
        this.field_230710_m_.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons(MatrixStack mStack) {
        if (this.field_230710_m_.isEmpty()) {
            this.func_231160_c_();
        }
        int x = this.field_230708_k_ / 2;
        this.field_230712_o_.getClass();
        int lineHeight = 9 + 3;
        int y = 35 + lineHeight * 2;
        AutoMapConfirmation.func_238471_a_((MatrixStack)mStack, (FontRenderer)this.getFontRenderer(), (String)Constants.getString("jm.common.automap_dialog_summary_1"), (int)x, (int)y, (int)0xFFFFFF);
        AutoMapConfirmation.func_238471_a_((MatrixStack)mStack, (FontRenderer)this.getFontRenderer(), (String)Constants.getString("jm.common.automap_dialog_summary_2"), (int)x, (int)(y += lineHeight), (int)0xFFFFFF);
        this.buttonOptions.centerHorizontalOn(x).centerVerticalOn(y += lineHeight * 2);
        AutoMapConfirmation.func_238471_a_((MatrixStack)mStack, (FontRenderer)this.getFontRenderer(), (String)Constants.getString("jm.common.automap_dialog_text"), (int)x, (int)(y += lineHeight * 3), (int)0xFFFF00);
        ButtonList buttons = new ButtonList(this.buttonAll, this.buttonMissing);
        buttons.equalizeWidths(this.field_230712_o_, 4, 200);
        buttons.layoutCenteredHorizontal(x, y += lineHeight * 2, true, 4);
        this.buttonClose.centerHorizontalOn(x).below(this.buttonMissing, lineHeight);
    }

    protected void initAutoMapping(final boolean enable, final Object arg) {
        MapRegionTask.MAP_TYPE = Fullscreen.state().getMapType();
        JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

            @Override
            public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, enable, arg);
                return null;
            }

            @Override
            public String getName() {
                return "Automap";
            }
        });
        this.closeAndReturn();
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }
}

