/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.menu;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.event.forge.PopupMenuEvent;
import journeymap.client.api.impl.ModPopupMenuImpl;
import journeymap.client.api.model.IFullscreen;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPaneScreen;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.Waypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PopupMenu
extends ScrollPaneScreen
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    private int mouseX;
    private int mouseY;
    private final Screen parent;
    private DropDownItem selected;
    private boolean pass = false;
    private boolean isSub = false;
    private boolean mouseOver = false;

    public PopupMenu(Fullscreen parent) {
        this((Screen)parent);
    }

    public PopupMenu(PopupMenu parent) {
        this((Screen)parent);
        this.isSub = true;
    }

    private PopupMenu(Screen parent) {
        super(null, null, 0, 0, 0, 0);
        this.parent = parent;
        this.setParent(this);
    }

    public void displayBasicOptions(BlockPos blockPos) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        PopupMenuEvent.FullscreenPopupMenuEvent event = new PopupMenuEvent.FullscreenPopupMenuEvent(menu, (IFullscreen)this.parent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        this.displayOptions(blockPos, menu);
    }

    public void displayWaypointOptions(BlockPos blockPos, Waypoint wp) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        PopupMenuEvent.WaypointPopupMenuEvent event = new PopupMenuEvent.WaypointPopupMenuEvent((ModPopupMenu)menu, (IFullscreen)this.parent, wp.modWaypoint());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        this.displayOptions(blockPos, menu);
    }

    public void displayOptions(BlockPos blockPos, ModPopupMenu popupMenu) {
        ModPopupMenuImpl menu = (ModPopupMenuImpl)popupMenu;
        if (menu.getMenuItemList() != null && !menu.getMenuItemList().isEmpty()) {
            ArrayList<DropDownItem> items = new ArrayList<DropDownItem>();
            menu.getMenuItemList().forEach(menuItem -> items.add(this.dropDownItemBuilder((ModPopupMenuImpl.MenuItem)menuItem, menu, blockPos)));
            this.display(items);
        }
    }

    private DropDownItem dropDownItemBuilder(ModPopupMenuImpl.MenuItem menuItem, ModPopupMenuImpl menu, BlockPos blockPos) {
        DropDownItem dropDownItem;
        if (menuItem.isAutoCloseable()) {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> {
                if (menu.isSub()) {
                    this.closeStack();
                }
                menuItem.getAction().doAction(blockPos);
            });
        } else {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> menuItem.getSubMenuAction().doAction(blockPos, (Button)b));
            dropDownItem.setOnHover((button, isHovered) -> menuItem.getSubMenuAction().onHoverState(blockPos, button, isHovered));
        }
        return dropDownItem;
    }

    private void display(List<DropDownItem> items) {
        if (!this.pass) {
            for (DropDownItem item : items) {
                item.setHorizontalAlignment(DrawUtil.HAlign.Right);
            }
            this.pass = true;
            this.setRenderDecorations(false);
            this.setRenderSolidBackground(true);
            this.setItems(items);
            this.setPaneWidth(this.getPaneWidth(items));
            this.setPaneHeight(this.getPaneHeight(items));
            this.setPointsInScreenBounds();
            super.display();
        }
    }

    private void setPointsInScreenBounds() {
        int x;
        boolean inBoundsY;
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        boolean inBoundsX = this.mouseX + this.getPaneWidth() < screenWidth;
        boolean bl = inBoundsY = this.mouseY + this.getPaneHeight() < screenHeight;
        if (this.parent instanceof PopupMenu) {
            int width = this.scrollPane != null ? this.getPaneWidth() : this.getPaneWidth() - 6;
            x = inBoundsX ? this.mouseX : ((PopupMenu)this.parent).getPaneX() - width;
        } else {
            x = inBoundsX ? this.mouseX : screenWidth - this.getPaneWidth() - 4;
        }
        int y = inBoundsY ? this.mouseY : screenHeight - this.getPaneHeight() - 2;
        this.mouseX = x;
        this.mouseY = y;
        this.setPaneX(x);
        this.setPaneY(y);
    }

    public void resetPass() {
        this.pass = false;
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.mouseOver = this.mouseOverPane(mouseX, mouseY);
        int x = (int)(Minecraft.func_71410_x().field_71417_B.func_198024_e() * (double)Minecraft.func_71410_x().func_228018_at_().func_198107_o() / (double)Minecraft.func_71410_x().func_228018_at_().func_198105_m());
        int y = (int)(Minecraft.func_71410_x().field_71417_B.func_198026_f() * (double)Minecraft.func_71410_x().func_228018_at_().func_198087_p() / (double)Minecraft.func_71410_x().func_228018_at_().func_198083_n());
        super.func_230430_a_(mStack, x, y, partialTicks);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean clicked = super.func_231044_a_(mouseX, mouseY, button);
        if (!clicked && !this.mouseOverPane(mouseX, mouseY)) {
            this.resetPass();
            return this.parent.func_231044_a_(mouseX, mouseY, button);
        }
        return clicked;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void func_212927_b(double mouseX, double mouseY) {
        if (!this.mouseOverPane(mouseX, mouseY)) {
            this.parent.func_212927_b(mouseX, mouseY);
        }
        super.func_212927_b(mouseX, mouseY);
    }

    private int getPaneHeight(List<DropDownItem> items) {
        int size = Math.min(items.size(), 6);
        return size * (items.get(0).func_238483_d_() + (size == 1 ? 7 : 5));
    }

    private int getPaneWidth(List<DropDownItem> items) {
        int width = 0;
        if (items != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (DropDownItem item : items) {
                width = Math.max(width, fontRenderer.func_78256_a(item.getLabel()));
            }
            this.field_230708_k_ = width + 40;
        }
        return this.field_230708_k_;
    }

    public void setClickLoc(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.selected = button;
    }

    public void closeStack() {
        if (this.isSub) {
            ((PopupMenu)this.parent).closeStack();
            this.func_231175_as__();
        }
    }

    @Override
    public void onClick(DropDownItem pressed) {
        if (pressed.isAutoClose()) {
            this.func_231175_as__();
        }
        ((ScrollPaneScreen)this).parent.onRemove();
    }

    @Override
    public void func_231175_as__() {
        this.visible = false;
        ForgeHooksClient.popGuiLayer((Minecraft)Minecraft.func_71410_x());
    }

    @Override
    public void onRemove() {
        if (this.selected != null) {
            this.selected.press();
            this.selected = null;
        }
    }
}

