/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerData
extends WorldSavedData {
    private static final String DAT_FILE = "JMPlayerSettings";
    private CompoundNBT data = new CompoundNBT();
    Map<String, Player> playerMap = new HashMap<String, Player>();

    public PlayerData() {
        super(DAT_FILE);
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_218657_a(DAT_FILE, (INBT)PlayerData.get().data);
        return compound;
    }

    private static PlayerData get() {
        ServerWorld level = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
        return (PlayerData)level.func_217481_x().func_215752_a(PlayerData::new, DAT_FILE);
    }

    public void func_76184_a(CompoundNBT compound) {
        this.data = compound.func_74775_l(DAT_FILE);
    }

    public Player getPlayer(ServerPlayerEntity serverPlayer) {
        String uuid = serverPlayer.func_189512_bd();
        Player player = this.playerMap.get(uuid);
        if (player == null) {
            CompoundNBT playerTag;
            if (this.data.func_74764_b(uuid)) {
                playerTag = this.data.func_74775_l(uuid);
            } else {
                playerTag = new CompoundNBT();
                this.data.func_218657_a(uuid, (INBT)playerTag);
            }
            player = new Player(this, uuid, playerTag);
            this.playerMap.put(uuid, player);
        }
        return player;
    }

    public static class Player {
        static final String HIDDEN_UNDERGROUND = "hidden_underground";
        static final String VISIBLE = "radar_visible";
        final String uuid;
        boolean hiddenUnderground;
        boolean visible;
        CompoundNBT playerNbt;
        final PlayerData playerData;

        public Player(PlayerData playerData, String uuid, CompoundNBT playerNbt) {
            this.playerData = playerData;
            this.uuid = uuid;
            this.playerNbt = playerNbt;
            this.readPlayerNbt();
        }

        public boolean isHiddenUnderground() {
            return this.hiddenUnderground;
        }

        public void setHiddenUnderground(boolean hiddenUnderground) {
            this.playerNbt.func_74757_a(HIDDEN_UNDERGROUND, hiddenUnderground);
            this.hiddenUnderground = hiddenUnderground;
            this.playerData.func_76185_a();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.playerNbt.func_74757_a(VISIBLE, visible);
            this.visible = visible;
            this.playerData.func_76185_a();
        }

        private void readPlayerNbt() {
            if (this.playerNbt.func_74764_b(HIDDEN_UNDERGROUND)) {
                this.hiddenUnderground = this.playerNbt.func_74767_n(HIDDEN_UNDERGROUND);
            } else {
                this.setHiddenUnderground(false);
            }
            if (this.playerNbt.func_74764_b(VISIBLE)) {
                this.visible = this.playerNbt.func_74767_n(VISIBLE);
            } else {
                this.setVisible(true);
            }
        }
    }
}

