/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.client.ClientEventHandler;
import com.bobmowzie.mowziesmobs.client.MMModels;
import com.bobmowzie.mowziesmobs.client.model.armor.BarakoaMaskModel;
import com.bobmowzie.mowziesmobs.client.model.armor.SolVisageModel;
import com.bobmowzie.mowziesmobs.client.model.armor.WroughtHelmModel;
import com.bobmowzie.mowziesmobs.client.render.entity.FrozenRenderHandler;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.SunblockLayer;
import com.bobmowzie.mowziesmobs.client.sound.BlackPinkSound;
import com.bobmowzie.mowziesmobs.client.sound.IceBreathSound;
import com.bobmowzie.mowziesmobs.client.sound.NagaSwoopSound;
import com.bobmowzie.mowziesmobs.client.sound.SpawnBoulderChargeSound;
import com.bobmowzie.mowziesmobs.client.sound.SunblockSound;
import com.bobmowzie.mowziesmobs.client.sound.SunstrikeSound;
import com.bobmowzie.mowziesmobs.server.ServerProxy;
import com.bobmowzie.mowziesmobs.server.ability.AbilityClientEventHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends ServerProxy {
    private static final WroughtHelmModel<LivingEntity> WROUGHT_HELM_MODEL = new WroughtHelmModel();
    private static final BarakoaMaskModel<LivingEntity> BARAKOA_MASK_MODEL = new BarakoaMaskModel();
    private static final SolVisageModel<LivingEntity> SOL_VISAGE_MODEL = new SolVisageModel();
    private static final List<SunblockSound> sunblockSounds = new ArrayList<SunblockSound>();
    private Entity referencedMob = null;

    @Override
    public void init(IEventBus modbus) {
        super.init(modbus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT_CONFIG);
        modbus.register(MMModels.class);
        MinecraftForge.EVENT_BUS.register((Object)ClientEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)FrozenRenderHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)AbilityClientEventHandler.INSTANCE);
    }

    @Override
    public void onLateInit(IEventBus modbus) {
        for (EntityRenderer entityRenderer : Minecraft.func_71410_x().func_175598_ae().field_78729_o.values()) {
            if (!(entityRenderer instanceof LivingRenderer)) continue;
            LivingRenderer livingRenderer = (LivingRenderer)entityRenderer;
            livingRenderer.func_177094_a(new FrozenRenderHandler.LayerFrozen(livingRenderer));
            livingRenderer.func_177094_a(new SunblockLayer(livingRenderer));
        }
        for (PlayerRenderer playerRenderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            playerRenderer.func_177094_a(new FrozenRenderHandler.LayerFrozen(playerRenderer));
            playerRenderer.func_177094_a(new SunblockLayer(playerRenderer));
        }
        IItemPropertyGetter pulling = ItemModelsProperties.func_239417_a_((Item)Items.field_151031_f, (ResourceLocation)new ResourceLocation("pulling"));
        ItemModelsProperties.func_239418_a_((Item)ItemHandler.BLOWGUN.func_199767_j(), (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
    }

    @Override
    public void playSunstrikeSound(EntitySunstrike strike) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SunstrikeSound(strike));
    }

    @Override
    public void playIceBreathSound(Entity entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new IceBreathSound(entity));
    }

    @Override
    public void playBoulderChargeSound(LivingEntity player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SpawnBoulderChargeSound(player));
    }

    @Override
    public void playNagaSwoopSound(EntityNaga naga) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new NagaSwoopSound((Entity)naga));
    }

    @Override
    public void playBlackPinkSound(AbstractMinecartEntity entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new BlackPinkSound(entity));
    }

    @Override
    public void playSunblockSound(LivingEntity entity) {
        sunblockSounds.removeIf(TickableSound::func_147667_k);
        if (sunblockSounds.size() < 10) {
            SunblockSound sunblockSound = new SunblockSound(entity);
            sunblockSounds.add(sunblockSound);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sunblockSound);
        }
    }

    @Override
    public void minecartParticles(ClientWorld world, AbstractMinecartEntity minecart, float scale, double x, double y, double z, BlockState state, BlockPos pos) {
        int size = 3;
        float offset = -0.5f * scale;
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    double dx = (double)ix / 3.0 * (double)scale;
                    double dy = (double)iy / 3.0 * (double)scale;
                    double dz = (double)iz / 3.0 * (double)scale;
                    Vector3d minecartMotion = minecart.func_213322_ci();
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle(world, x + dx + (double)offset, y + dy + (double)offset, z + dz + (double)offset, dx + minecartMotion.func_82615_a(), dy + minecartMotion.func_82617_b(), dz + minecartMotion.func_82616_c(), state){}.func_174846_a(pos));
                }
            }
        }
    }

    @Override
    public void setTPS(float tickRate) {
    }

    @Override
    public Entity getReferencedMob() {
        return this.referencedMob;
    }

    @Override
    public void setReferencedMob(Entity referencedMob) {
        this.referencedMob = referencedMob;
    }

    @Override
    public WroughtHelmModel<LivingEntity> getWroughtHelmModel() {
        return WROUGHT_HELM_MODEL;
    }

    @Override
    public BarakoaMaskModel<LivingEntity> getBarakoaMaskModel() {
        return BARAKOA_MASK_MODEL;
    }

    @Override
    public SolVisageModel<LivingEntity> getSolVisageModel() {
        return SOL_VISAGE_MODEL;
    }
}

