/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.tools;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.processor.IBone;

public class RigUtils {
    public static Vector3d lerp(Vector3d v, Vector3d u, float alpha) {
        return new Vector3d((double)MathHelper.func_219799_g((float)alpha, (float)((float)v.func_82615_a()), (float)((float)u.func_82615_a())), (double)MathHelper.func_219799_g((float)alpha, (float)((float)v.func_82617_b()), (float)((float)u.func_82617_b())), (double)MathHelper.func_219799_g((float)alpha, (float)((float)v.func_82616_c()), (float)((float)u.func_82616_c())));
    }

    public static Vector3d lerpAngles(Vector3d v, Vector3d u, float alpha) {
        return new Vector3d(Math.toRadians(MathHelper.func_219805_h((float)alpha, (float)((float)Math.toDegrees(v.func_82615_a())), (float)((float)Math.toDegrees(u.func_82615_a())))), Math.toRadians(MathHelper.func_219805_h((float)alpha, (float)((float)Math.toDegrees(v.func_82617_b())), (float)((float)Math.toDegrees(u.func_82617_b())))), Math.toRadians(MathHelper.func_219805_h((float)alpha, (float)((float)Math.toDegrees(v.func_82616_c())), (float)((float)Math.toDegrees(u.func_82616_c())))));
    }

    public static Vector3d blendAngles(Vector3d v, Vector3d u, float alpha) {
        return new Vector3d(Math.toRadians(MathHelper.func_76138_g((double)(Math.toDegrees(v.func_82615_a()) * (double)alpha + Math.toDegrees(u.func_82615_a())))), Math.toRadians(MathHelper.func_76138_g((double)(Math.toDegrees(v.func_82617_b()) * (double)alpha + Math.toDegrees(u.func_82617_b())))), Math.toRadians(MathHelper.func_76138_g((double)(Math.toDegrees(v.func_82616_c()) * (double)alpha + Math.toDegrees(u.func_82616_c())))));
    }

    public static Quaternion matrixToQuaternion(Matrix3f matrix) {
        double tr = matrix.field_226097_a_ + matrix.field_226101_e_ + matrix.field_226105_i_;
        double qw = 0.0;
        double qx = 0.0;
        double qy = 0.0;
        double qz = 0.0;
        if (tr > 0.0) {
            double S = Math.sqrt(tr + 1.0) * 2.0;
            qw = 0.25 * S;
            qx = (double)(matrix.field_226104_h_ - matrix.field_226102_f_) / S;
            qy = (double)(matrix.field_226099_c_ - matrix.field_226103_g_) / S;
            qz = (double)(matrix.field_226100_d_ - matrix.field_226098_b_) / S;
        } else if (matrix.field_226097_a_ > matrix.field_226101_e_ & matrix.field_226097_a_ > matrix.field_226105_i_) {
            double S = Math.sqrt(1.0 + (double)matrix.field_226097_a_ - (double)matrix.field_226101_e_ - (double)matrix.field_226105_i_) * 2.0;
            qw = (double)(matrix.field_226104_h_ - matrix.field_226102_f_) / S;
            qx = 0.25 * S;
            qy = (double)(matrix.field_226098_b_ + matrix.field_226100_d_) / S;
            qz = (double)(matrix.field_226099_c_ + matrix.field_226103_g_) / S;
        } else if (matrix.field_226101_e_ > matrix.field_226105_i_) {
            double S = Math.sqrt(1.0 + (double)matrix.field_226101_e_ - (double)matrix.field_226097_a_ - (double)matrix.field_226105_i_) * 2.0;
            qw = (double)(matrix.field_226099_c_ - matrix.field_226103_g_) / S;
            qx = (double)(matrix.field_226098_b_ + matrix.field_226100_d_) / S;
            qy = 0.25 * S;
            qz = (double)(matrix.field_226102_f_ + matrix.field_226104_h_) / S;
        } else {
            double S = Math.sqrt(1.0 + (double)matrix.field_226105_i_ - (double)matrix.field_226097_a_ - (double)matrix.field_226101_e_) * 2.0;
            qw = (double)(matrix.field_226100_d_ - matrix.field_226098_b_) / S;
            qx = (double)(matrix.field_226099_c_ + matrix.field_226103_g_) / S;
            qy = (double)(matrix.field_226102_f_ + matrix.field_226104_h_) / S;
            qz = 0.25 * S;
        }
        return new Quaternion((float)qw, (float)qx, (float)qy, (float)qz);
    }

    public static void removeMatrixRotation(Matrix4f matrix) {
        matrix.field_226575_a_ = 1.0f;
        matrix.field_226580_f_ = 1.0f;
        matrix.field_226585_k_ = 1.0f;
        matrix.field_226576_b_ = 0.0f;
        matrix.field_226577_c_ = 0.0f;
        matrix.field_226579_e_ = 0.0f;
        matrix.field_226581_g_ = 0.0f;
        matrix.field_226583_i_ = 0.0f;
        matrix.field_226584_j_ = 0.0f;
    }

    public static void removeMatrixTranslation(Matrix4f matrix) {
        matrix.field_226578_d_ = 0.0f;
        matrix.field_226582_h_ = 0.0f;
        matrix.field_226586_l_ = 0.0f;
    }

    public static Quaternion betweenVectors(Vector3d u, Vector3d v) {
        Vector3d a = u.func_72431_c(v);
        float w = (float)(Math.sqrt(u.func_189985_c() * v.func_189985_c()) + u.func_72430_b(v));
        Quaternion q = new Quaternion((float)a.func_82615_a(), -((float)a.func_82617_b()), -((float)a.func_82616_c()), w);
        q.func_227067_f_();
        return q;
    }

    public static Vector3f translationFromMatrix(Matrix4f matrix4f) {
        return new Vector3f(matrix4f.field_226578_d_, matrix4f.field_226582_h_, matrix4f.field_226586_l_);
    }

    public static Vector3f eulerAnglesZYXFromMatrix(Matrix4f matrix4f) {
        float thetaX;
        float thetaZ;
        float thetaY;
        if (matrix4f.field_226583_i_ < 1.0f) {
            if (matrix4f.field_226583_i_ > -1.0f) {
                thetaY = (float)Math.asin(-matrix4f.field_226583_i_);
                thetaZ = (float)Math.atan2(matrix4f.field_226579_e_, matrix4f.field_226575_a_);
                thetaX = (float)Math.atan2(matrix4f.field_226584_j_, matrix4f.field_226585_k_);
            } else {
                thetaY = 1.5707964f;
                thetaZ = -((float)Math.atan2(-matrix4f.field_226581_g_, matrix4f.field_226580_f_));
                thetaX = 0.0f;
            }
        } else {
            thetaY = -1.5707964f;
            thetaZ = (float)Math.atan2(-matrix4f.field_226581_g_, matrix4f.field_226580_f_);
            thetaX = 0.0f;
        }
        return new Vector3f(thetaX, thetaY, thetaZ);
    }

    public static Vector3f eulerAnglesXYZFromMatrix(Matrix4f matrix4f) {
        float thetaZ;
        float thetaX;
        float thetaY;
        if (matrix4f.field_226583_i_ < 1.0f) {
            if (matrix4f.field_226583_i_ > -1.0f) {
                thetaY = (float)Math.asin(matrix4f.field_226577_c_);
                thetaX = (float)Math.atan2(-matrix4f.field_226581_g_, matrix4f.field_226585_k_);
                thetaZ = (float)Math.atan2(-matrix4f.field_226576_b_, matrix4f.field_226575_a_);
            } else {
                thetaY = -1.5707964f;
                thetaX = -((float)Math.atan2(matrix4f.field_226579_e_, matrix4f.field_226580_f_));
                thetaZ = 0.0f;
            }
        } else {
            thetaY = 1.5707964f;
            thetaX = (float)Math.atan2(matrix4f.field_226579_e_, matrix4f.field_226580_f_);
            thetaZ = 0.0f;
        }
        return new Vector3f(thetaX, thetaY, thetaZ);
    }

    public static class BlendShape3D {
        private final BlendShape3DEntry[] entries;

        public BlendShape3D(BlendShape3DEntry[] entries) {
            this.entries = entries;
        }

        public void evaluate(IBone bone, Vector3d dir) {
            this.evaluate(bone, dir, false);
        }

        private double[] getWeights(Vector3d dir) {
            int i;
            double[] weights = new double[this.entries.length];
            double[] dotProducts = new double[this.entries.length];
            double totalDotProduct = 0.0;
            for (i = 0; i < this.entries.length; ++i) {
                BlendShape3DEntry entry = this.entries[i];
                double dot = 1.0 - entry.getWeight(dir);
                if (dot > 0.0) {
                    totalDotProduct += 1.0 / dot;
                } else {
                    weights[i] = 1.0;
                    return weights;
                }
                dotProducts[i] = dot;
            }
            for (i = 0; i < this.entries.length; ++i) {
                double dot_prod = totalDotProduct * dotProducts[i];
                weights[i] = dot_prod > 0.0 ? 1.0 / dot_prod : 0.0;
            }
            return weights;
        }

        private double[] getWeightsGradientBand(Vector3d dir) {
            int i;
            double[] weights = new double[this.entries.length];
            double[] sqrdDistances = new double[this.entries.length];
            double[] angularDistances = new double[this.entries.length];
            double totalSqrdDistance = 0.0;
            double totalAngularDistance = 0.0;
            for (i = 0; i < this.entries.length; ++i) {
                double angularDistance;
                BlendShape3DEntry entry = this.entries[i];
                double sqrdDistance = dir.func_178788_d(entry.direction).func_72430_b(dir.func_178788_d(entry.direction));
                if (sqrdDistance > 0.0) {
                    angularDistance = -(MathHelper.func_151237_a((double)dir.func_72430_b(entry.direction), (double)-1.0, (double)1.0) - 1.0) * 0.5;
                    totalSqrdDistance += 1.0 / sqrdDistance;
                    if (angularDistance > 0.0) {
                        totalAngularDistance += 1.0 / angularDistance;
                    }
                } else {
                    weights[i] = 1.0;
                    return weights;
                }
                sqrdDistances[i] = sqrdDistance;
                angularDistances[i] = angularDistance;
            }
            for (i = 0; i < this.entries.length; ++i) {
                double sqrdDistance = totalSqrdDistance * sqrdDistances[i];
                double angularDistance = totalAngularDistance * angularDistances[i];
                weights[i] = sqrdDistance > 0.0 && angularDistance > 0.0 ? 1.0 / sqrdDistance * 0.5 + 1.0 / angularDistance * 0.5 : (sqrdDistance > 0.0 ? 1.0 / sqrdDistance * 0.5 + 0.5 : 0.0);
            }
            return weights;
        }

        public void evaluate(IBone bone, Vector3d d, boolean mirrorX) {
            Vector3d dir = mirrorX ? d.func_216372_d(-1.0, 1.0, 1.0) : d;
            dir = dir.func_72432_b();
            double[] weights = this.getWeights(dir);
            BoneTransform transform = new BoneTransform(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            for (int i = 0; i < this.entries.length; ++i) {
                BlendShape3DEntry entry = this.entries[i];
                transform = entry.blend(transform, (float)MathHelper.func_151237_a((double)weights[i], (double)0.0, (double)1.0));
            }
            transform.apply(bone, mirrorX);
        }
    }

    public static class BlendShape3DEntry {
        private BoneTransform transform;
        private Vector3d direction;
        private float power;

        public BlendShape3DEntry(BoneTransform transform, Vector3d direction, float power) {
            this.transform = transform;
            this.direction = direction.func_72432_b();
            this.power = power;
        }

        public double getWeight(Vector3d dir) {
            double dot = dir.func_72432_b().func_72430_b(this.direction.func_72432_b());
            dot = Math.max(dot, 0.0);
            dot = Math.pow(dot, 0.01 * (double)this.power);
            return dot;
        }

        public BoneTransform blend(BoneTransform other, float alpha) {
            return this.transform.blend(other, alpha);
        }
    }

    public static class BoneTransform {
        private final Vector3d translation;
        private final Vector3d rotation;
        private final Vector3d scale;

        public BoneTransform(double tx, double ty, double tz, double rx, double ry, double rz, double sx, double sy, double sz) {
            this.translation = new Vector3d(tx, ty, tz);
            this.rotation = new Vector3d(rx, ry, rz);
            this.scale = new Vector3d(sx, sy, sz);
        }

        public BoneTransform(Vector3d t, Vector3d r, Vector3d s) {
            this.translation = t;
            this.rotation = r;
            this.scale = s;
        }

        public BoneTransform blend(BoneTransform other, float alpha) {
            return new BoneTransform(this.translation.func_186678_a((double)alpha).func_178787_e(other.translation), RigUtils.blendAngles(this.rotation, other.rotation, alpha), this.scale.func_186678_a((double)alpha).func_178787_e(other.scale));
        }

        public void apply(IBone bone) {
            this.apply(bone, false);
        }

        public void apply(IBone bone, boolean mirrorX) {
            float mirror = mirrorX ? -1.0f : 1.0f;
            bone.setPositionX(bone.getPositionX() + mirror * (float)this.translation.func_82615_a());
            bone.setPositionY(bone.getPositionY() + (float)this.translation.func_82617_b());
            bone.setPositionZ(bone.getPositionZ() + (float)this.translation.func_82616_c());
            bone.setRotationX(bone.getRotationX() + (float)this.rotation.func_82615_a());
            bone.setRotationY(bone.getRotationY() + mirror * (float)this.rotation.func_82617_b());
            bone.setRotationZ(bone.getRotationZ() + mirror * (float)this.rotation.func_82616_c());
            bone.setScaleX(bone.getScaleX() * (float)this.scale.func_82615_a());
            bone.setScaleY(bone.getScaleY() * (float)this.scale.func_82617_b());
            bone.setScaleZ(bone.getScaleZ() * (float)this.scale.func_82616_c());
        }
    }
}

