/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render;

import com.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;

public class MowzieRenderUtils {
    public static void matrixStackFromModel(MatrixStack matrixStack, AdvancedModelRenderer modelRenderer) {
        AdvancedModelRenderer parent = modelRenderer.getParent();
        if (parent != null) {
            MowzieRenderUtils.matrixStackFromModel(matrixStack, parent);
        }
        modelRenderer.func_228307_a_(matrixStack);
    }

    public static Vector3d getWorldPosFromModel(Entity entity, float entityYaw, AdvancedModelRenderer modelRenderer) {
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        matrixStack.func_227863_a_(new Quaternion(0.0f, -entityYaw + 180.0f, 0.0f, true));
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -1.5, 0.0);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, modelRenderer);
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(matrix4f);
        return new Vector3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
    }

    public static void translateRotateGeckolib(GeoBone bone, MatrixStack matrixStackIn) {
        matrixStackIn.func_227861_a_((double)(bone.rotationPointX / 16.0f), (double)(bone.rotationPointY / 16.0f), (double)(bone.rotationPointZ / 16.0f));
        if (bone.getRotationZ() != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(bone.getRotationZ()));
        }
        if (bone.getRotationY() != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(bone.getRotationY()));
        }
        if (bone.getRotationX() != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(bone.getRotationX()));
        }
        matrixStackIn.func_227862_a_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void matrixStackFromModel(MatrixStack matrixStack, GeoBone geoBone) {
        GeoBone parent = geoBone.parent;
        if (parent != null) {
            MowzieRenderUtils.matrixStackFromModel(matrixStack, parent);
        }
        MowzieRenderUtils.translateRotateGeckolib(geoBone, matrixStack);
    }

    public static Vector3d getWorldPosFromModel(Entity entity, float entityYaw, GeoBone geoBone) {
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        matrixStack.func_227863_a_(new Quaternion(0.0f, -entityYaw + 180.0f, 0.0f, true));
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -1.5, 0.0);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, geoBone);
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(matrix4f);
        return new Vector3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
    }

    public static void moveToPivotMirror(GeoCube cube, MatrixStack stack) {
        Vector3f pivot = cube.pivot;
        stack.func_227861_a_((double)(-pivot.func_195899_a() / 16.0f), (double)(pivot.func_195900_b() / 16.0f), (double)(pivot.func_195902_c() / 16.0f));
    }

    public static void moveBackFromPivotMirror(GeoCube cube, MatrixStack stack) {
        Vector3f pivot = cube.pivot;
        stack.func_227861_a_((double)(pivot.func_195899_a() / 16.0f), (double)(-pivot.func_195900_b() / 16.0f), (double)(-pivot.func_195902_c() / 16.0f));
    }

    public static void moveToPivotMirror(GeoBone bone, MatrixStack stack) {
        stack.func_227861_a_((double)(-bone.rotationPointX / 16.0f), (double)(bone.rotationPointY / 16.0f), (double)(bone.rotationPointZ / 16.0f));
    }

    public static void moveBackFromPivotMirror(GeoBone bone, MatrixStack stack) {
        stack.func_227861_a_((double)(bone.rotationPointX / 16.0f), (double)(-bone.rotationPointY / 16.0f), (double)(-bone.rotationPointZ / 16.0f));
    }

    public static void translateMirror(GeoBone bone, MatrixStack stack) {
        stack.func_227861_a_((double)(bone.getPositionX() / 16.0f), (double)(bone.getPositionY() / 16.0f), (double)(bone.getPositionZ() / 16.0f));
    }

    public static void rotateMirror(GeoBone bone, MatrixStack stack) {
        if (bone.getRotationZ() != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(-bone.getRotationZ()));
        }
        if (bone.getRotationY() != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-bone.getRotationY()));
        }
        if (bone.getRotationX() != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(bone.getRotationX()));
        }
    }

    public static void rotateMirror(GeoCube bone, MatrixStack stack) {
        Vector3f rotation = bone.rotation;
        stack.func_227863_a_(new Quaternion(0.0f, 0.0f, -rotation.func_195902_c(), false));
        stack.func_227863_a_(new Quaternion(0.0f, -rotation.func_195900_b(), 0.0f, false));
        stack.func_227863_a_(new Quaternion(rotation.func_195899_a(), 0.0f, 0.0f, false));
    }
}

