/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class SunstrikeAbility
extends Ability {
    private static final double REACH = 15.0;
    private static final int SUNSTRIKE_RECOVERY = 20;
    protected BlockRayTraceResult rayTrace;

    public SunstrikeAbility(AbilityType<SunstrikeAbility> abilityType, LivingEntity user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 20)});
    }

    private static BlockRayTraceResult rayTrace(LivingEntity entity, double reach) {
        Vector3d pos = entity.func_174824_e(0.0f);
        Vector3d segment = entity.func_70040_Z();
        segment = pos.func_72441_c(segment.field_72450_a * reach, segment.field_72448_b * reach, segment.field_72449_c * reach);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(pos, segment, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
    }

    @Override
    public boolean tryAbility() {
        super.tryAbility();
        LivingEntity user = this.getUser();
        BlockRayTraceResult raytrace = SunstrikeAbility.rayTrace(user, 15.0);
        if (raytrace.func_216346_c() == RayTraceResult.Type.BLOCK && raytrace.func_216354_b() == Direction.UP) {
            this.rayTrace = raytrace;
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        super.start();
        LivingEntity user = this.getUser();
        if (!user.field_70170_p.func_201670_d()) {
            BlockPos hit = this.rayTrace.func_216350_a();
            EntitySunstrike sunstrike = new EntitySunstrike((EntityType<? extends EntitySunstrike>)((EntityType)EntityHandler.SUNSTRIKE.get()), user.field_70170_p, user, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p());
            sunstrike.onSummon();
            user.field_70170_p.func_217376_c((Entity)sunstrike);
        }
        this.playAnimation("sunstrike", false);
    }

    @Override
    public boolean canUse() {
        if (this.getUser() instanceof PlayerEntity && !((PlayerEntity)this.getUser()).field_71071_by.func_70448_g().func_190926_b()) {
            return false;
        }
        return this.getUser().func_70644_a((Effect)EffectHandler.SUNS_BLESSING) && super.canUse();
    }

    @Override
    public boolean preventsBlockBreakingBuilding() {
        return false;
    }

    @Override
    public boolean preventsAttacking() {
        return false;
    }

    @Override
    public boolean preventsInteracting() {
        return false;
    }
}

