/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.capability;

import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleSnowFlake;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class FrozenCapability {
    public static int MAX_FREEZE_DECAY_DELAY = 10;

    public static class FrozenProvider
    implements ICapabilitySerializable<INBT> {
        @CapabilityInject(value=IFrozenCapability.class)
        public static final Capability<IFrozenCapability> FROZEN_CAPABILITY = null;
        private final LazyOptional<IFrozenCapability> instance = LazyOptional.of(() -> FROZEN_CAPABILITY.getDefaultInstance());

        public INBT serializeNBT() {
            return FROZEN_CAPABILITY.getStorage().writeNBT(FROZEN_CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")), null);
        }

        public void deserializeNBT(INBT nbt) {
            FROZEN_CAPABILITY.getStorage().readNBT(FROZEN_CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")), null, nbt);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == FROZEN_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }
    }

    public static class FrozenStorage
    implements Capability.IStorage<IFrozenCapability> {
        public INBT writeNBT(Capability<IFrozenCapability> capability, IFrozenCapability instance, Direction side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IFrozenCapability> capability, IFrozenCapability instance, Direction side, INBT nbt) {
            instance.readNBT(nbt);
        }
    }

    public static class FrozenCapabilityImp
    implements IFrozenCapability {
        public boolean frozen;
        public float freezeProgress = 0.0f;
        public float frozenYaw;
        public float frozenPitch;
        public float frozenYawHead;
        public float frozenRenderYawOffset;
        public float frozenSwingProgress;
        public float frozenLimbSwingAmount;
        public boolean prevHasAI = true;
        public UUID prevAttackTarget;
        public int freezeDecayDelay;
        public boolean prevFrozen = false;
        public EntityFrozenController frozenController;

        @Override
        public boolean getFrozen() {
            return this.frozen;
        }

        @Override
        public float getFreezeProgress() {
            return this.freezeProgress;
        }

        @Override
        public void setFreezeProgress(float freezeProgress) {
            this.freezeProgress = freezeProgress;
        }

        @Override
        public float getFrozenYaw() {
            return this.frozenYaw;
        }

        @Override
        public void setFrozenYaw(float frozenYaw) {
            this.frozenYaw = frozenYaw;
        }

        @Override
        public float getFrozenPitch() {
            return this.frozenPitch;
        }

        @Override
        public void setFrozenPitch(float frozenPitch) {
            this.frozenPitch = frozenPitch;
        }

        @Override
        public float getFrozenYawHead() {
            return this.frozenYawHead;
        }

        @Override
        public void setFrozenYawHead(float frozenYawHead) {
            this.frozenYawHead = frozenYawHead;
        }

        @Override
        public float getFrozenRenderYawOffset() {
            return this.frozenRenderYawOffset;
        }

        @Override
        public void setFrozenRenderYawOffset(float frozenRenderYawOffset) {
            this.frozenRenderYawOffset = frozenRenderYawOffset;
        }

        @Override
        public float getFrozenSwingProgress() {
            return this.frozenSwingProgress;
        }

        @Override
        public void setFrozenSwingProgress(float frozenSwingProgress) {
            this.frozenSwingProgress = frozenSwingProgress;
        }

        @Override
        public float getFrozenLimbSwingAmount() {
            return this.frozenLimbSwingAmount;
        }

        @Override
        public void setFrozenLimbSwingAmount(float frozenLimbSwingAmount) {
            this.frozenLimbSwingAmount = frozenLimbSwingAmount;
        }

        @Override
        public boolean prevHasAI() {
            return this.prevHasAI;
        }

        @Override
        public void setPrevHasAI(boolean prevHasAI) {
            this.prevHasAI = prevHasAI;
        }

        @Override
        public int getFreezeDecayDelay() {
            return this.freezeDecayDelay;
        }

        @Override
        public void setFreezeDecayDelay(int freezeDecayDelay) {
            this.freezeDecayDelay = freezeDecayDelay;
        }

        @Override
        public boolean getPrevFrozen() {
            return this.prevFrozen;
        }

        @Override
        public void setPrevFrozen(boolean prevFrozen) {
            this.prevFrozen = prevFrozen;
        }

        @Override
        public UUID getPreAttackTarget() {
            return this.prevAttackTarget;
        }

        @Override
        public void setPreAttackTarget(UUID livingEntity) {
            this.prevAttackTarget = livingEntity;
        }

        @Override
        public EntityFrozenController getFrozenController() {
            return this.frozenController;
        }

        @Override
        public void setFrozenController(EntityFrozenController frozenController) {
            this.frozenController = frozenController;
        }

        @Override
        public void addFreezeProgress(LivingEntity entity, float amount) {
            if (!entity.field_70170_p.field_72995_K && !entity.func_70644_a((Effect)EffectHandler.FROZEN)) {
                this.freezeProgress += amount;
                this.freezeDecayDelay = MAX_FREEZE_DECAY_DELAY;
            }
        }

        @Override
        public void onFreeze(LivingEntity entity) {
            if (entity != null) {
                this.frozen = true;
                this.frozenController = new EntityFrozenController((EntityType<? extends EntityFrozenController>)((EntityType)EntityHandler.FROZEN_CONTROLLER.get()), entity.field_70170_p);
                this.frozenController.func_70080_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                entity.field_70170_p.func_217376_c((Entity)this.frozenController);
                this.frozenController.func_181013_g(entity.field_70761_aq);
                this.frozenYaw = entity.field_70177_z;
                this.frozenPitch = entity.field_70125_A;
                this.frozenYawHead = entity.field_70759_as;
                this.frozenLimbSwingAmount = 0.0f;
                this.frozenRenderYawOffset = entity.field_70761_aq;
                this.frozenSwingProgress = entity.field_70733_aJ;
                entity.func_184205_a((Entity)this.frozenController, true);
                entity.func_184602_cy();
                if (entity instanceof MobEntity) {
                    MobEntity mobEntity = (MobEntity)entity;
                    if (mobEntity.func_70638_az() != null) {
                        this.setPreAttackTarget(mobEntity.func_70638_az().func_110124_au());
                    }
                    this.prevHasAI = !((MobEntity)entity).func_175446_cd();
                    mobEntity.func_94061_f(true);
                }
                if (entity.field_70170_p.field_72995_K) {
                    int particleCount = (int)(10.0f + 1.0f * entity.func_213302_cg() * entity.func_213311_cf() * entity.func_213311_cf());
                    for (int i = 0; i < particleCount; ++i) {
                        double snowX = entity.func_226277_ct_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                        double snowZ = entity.func_226281_cx_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                        double snowY = entity.func_226278_cu_() + (double)(entity.func_213302_cg() * entity.func_70681_au().nextFloat());
                        Vector3d motion = new Vector3d(snowX - entity.func_226277_ct_(), snowY - (entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f)), snowZ - entity.func_226281_cx_()).func_72432_b();
                        entity.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), snowX, snowY, snowZ, 0.1 * motion.field_72450_a, 0.1 * motion.field_72448_b, 0.1 * motion.field_72449_c);
                    }
                }
                entity.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_FROZEN_CRASH.get(), 1.0f, 1.0f);
            }
        }

        @Override
        public void onUnfreeze(LivingEntity entity) {
            if (entity != null) {
                this.freezeProgress = 0.0f;
                if (this.frozen) {
                    entity.func_184596_c((Effect)EffectHandler.FROZEN);
                    this.frozen = false;
                    if (this.frozenController != null) {
                        Vector3d oldPosition = entity.func_213303_ch();
                        entity.func_184210_p();
                        entity.func_70634_a(oldPosition.func_82615_a(), oldPosition.func_82617_b(), oldPosition.func_82616_c());
                        this.frozenController.func_70106_y();
                    }
                    entity.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_FROZEN_CRASH.get(), 1.0f, 0.5f);
                    if (entity.field_70170_p.field_72995_K) {
                        int particleCount = (int)(10.0f + 1.0f * entity.func_213302_cg() * entity.func_213311_cf() * entity.func_213311_cf());
                        for (int i = 0; i < particleCount; ++i) {
                            double particleX = entity.func_226277_ct_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                            double particleZ = entity.func_226281_cx_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                            double particleY = entity.func_226278_cu_() + (double)(entity.func_213302_cg() * entity.func_70681_au().nextFloat()) + (double)0.3f;
                            entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150432_aD.func_176223_P()), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                        }
                    }
                    if (entity instanceof MobEntity) {
                        PlayerEntity target;
                        if (((MobEntity)entity).func_175446_cd() && this.prevHasAI) {
                            ((MobEntity)entity).func_94061_f(false);
                        }
                        if (this.getPreAttackTarget() != null && (target = entity.field_70170_p.func_217371_b(this.getPreAttackTarget())) != null) {
                            ((MobEntity)entity).func_70624_b((LivingEntity)target);
                        }
                    }
                }
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            Entity riding;
            if (this.getFreezeProgress() >= 1.0f && !entity.func_70644_a((Effect)EffectHandler.FROZEN)) {
                entity.func_195064_c(new EffectInstance((Effect)EffectHandler.FROZEN, 50, 0, false, false));
                this.freezeProgress = 1.0f;
            } else if (this.freezeProgress > 0.0f) {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 9, MathHelper.func_76141_d((float)(this.freezeProgress * 5.0f + 1.0f)), false, false));
            }
            if (this.frozenController == null && (riding = entity.func_184187_bx()) instanceof EntityFrozenController) {
                this.frozenController = (EntityFrozenController)riding;
            }
            if (this.frozen) {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 50, false, false));
                entity.func_226284_e_(false);
                if (entity.field_70170_p.field_72995_K && entity.field_70173_aa % 2 == 0) {
                    double cloudX = entity.func_226277_ct_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                    double cloudZ = entity.func_226281_cx_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                    double cloudY = entity.func_226278_cu_() + (double)(entity.func_213302_cg() * entity.func_70681_au().nextFloat());
                    entity.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.75f, 0.75f, 1.0f, 15.0f, 25, ParticleCloud.EnumCloudBehavior.CONSTANT, 1.0f), cloudX, cloudY, cloudZ, 0.0, (double)-0.01f, 0.0);
                    double snowX = entity.func_226277_ct_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                    double snowZ = entity.func_226281_cx_() + (double)(entity.func_213311_cf() * entity.func_70681_au().nextFloat()) - (double)(entity.func_213311_cf() / 2.0f);
                    double snowY = entity.func_226278_cu_() + (double)(entity.func_213302_cg() * entity.func_70681_au().nextFloat());
                    entity.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), snowX, snowY, snowZ, 0.0, -0.01, 0.0);
                }
            } else if (!entity.field_70170_p.field_72995_K && this.getPrevFrozen()) {
                this.onUnfreeze(entity);
            }
            if (this.freezeDecayDelay <= 0) {
                this.freezeProgress = (float)((double)this.freezeProgress - 0.1);
                if (this.freezeProgress < 0.0f) {
                    this.freezeProgress = 0.0f;
                }
            } else {
                --this.freezeDecayDelay;
            }
            this.prevFrozen = entity.func_70644_a((Effect)EffectHandler.FROZEN);
        }

        @Override
        public INBT writeNBT() {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74776_a("freezeProgress", this.getFreezeProgress());
            compound.func_74768_a("freezeDecayDelay", this.getFreezeDecayDelay());
            compound.func_74776_a("frozenLimbSwingAmount", this.getFrozenLimbSwingAmount());
            compound.func_74776_a("frozenRenderYawOffset", this.getFrozenRenderYawOffset());
            compound.func_74776_a("frozenSwingProgress", this.getFrozenSwingProgress());
            compound.func_74776_a("frozenPitch", this.getFrozenPitch());
            compound.func_74776_a("frozenYaw", this.getFrozenYaw());
            compound.func_74776_a("frozenYawHead", this.getFrozenYawHead());
            compound.func_74757_a("prevHasAI", this.prevHasAI());
            if (this.getPreAttackTarget() != null) {
                compound.func_186854_a("prevAttackTarget", this.getPreAttackTarget());
            }
            compound.func_74757_a("frozen", this.frozen);
            compound.func_74757_a("prevFrozen", this.prevFrozen);
            return compound;
        }

        @Override
        public void readNBT(INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            this.setFreezeProgress(compound.func_74760_g("freezeProgress"));
            this.setFreezeDecayDelay(compound.func_74762_e("freezeDecayDelay"));
            this.setFrozenLimbSwingAmount(compound.func_74760_g("frozenLimbSwingAmount"));
            this.setFrozenRenderYawOffset(compound.func_74760_g("frozenRenderYawOffset"));
            this.setFrozenSwingProgress(compound.func_74760_g("frozenSwingProgress"));
            this.setFrozenPitch(compound.func_74760_g("frozenPitch"));
            this.setFrozenYaw(compound.func_74760_g("frozenYaw"));
            this.setFrozenYawHead(compound.func_74760_g("frozenYawHead"));
            this.setPrevHasAI(compound.func_74767_n("prevHasAI"));
            try {
                this.setPreAttackTarget(compound.func_186857_a("prevAttackTarget"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.frozen = compound.func_74767_n("frozen");
            this.prevFrozen = compound.func_74767_n("prevFrozen");
        }
    }

    public static interface IFrozenCapability {
        public boolean getFrozen();

        public float getFreezeProgress();

        public void setFreezeProgress(float var1);

        public float getFrozenYaw();

        public void setFrozenYaw(float var1);

        public float getFrozenPitch();

        public void setFrozenPitch(float var1);

        public float getFrozenYawHead();

        public void setFrozenYawHead(float var1);

        public float getFrozenRenderYawOffset();

        public void setFrozenRenderYawOffset(float var1);

        public float getFrozenSwingProgress();

        public void setFrozenSwingProgress(float var1);

        public float getFrozenLimbSwingAmount();

        public void setFrozenLimbSwingAmount(float var1);

        public boolean prevHasAI();

        public void setPrevHasAI(boolean var1);

        public int getFreezeDecayDelay();

        public void setFreezeDecayDelay(int var1);

        public boolean getPrevFrozen();

        public void setPrevFrozen(boolean var1);

        public UUID getPreAttackTarget();

        public void setPreAttackTarget(UUID var1);

        public EntityFrozenController getFrozenController();

        public void setFrozenController(EntityFrozenController var1);

        public void addFreezeProgress(LivingEntity var1, float var2);

        public void onFreeze(LivingEntity var1);

        public void onUnfreeze(LivingEntity var1);

        public void tick(LivingEntity var1);

        public INBT writeNBT();

        public void readNBT(INBT var1);
    }
}

