/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="mowziesmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigHandler {
    private static final String LANG_PREFIX = "config.mowziesmobs.";
    public static final Common COMMON;
    public static final Client CLIENT;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    private static final Predicate<Object> STRING_PREDICATE;
    private static final Predicate<Object> ITEM_NAME_PREDICATE;

    private ConfigHandler() {
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        STRING_PREDICATE = s -> s instanceof String;
        ITEM_NAME_PREDICATE = STRING_PREDICATE.and(s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation((String)s)));
        COMMON = new Common(COMMON_BUILDER);
        CLIENT = new Client(CLIENT_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }

    public static class Common {
        public final General GENERAL;
        public final ToolsAndAbilities TOOLS_AND_ABILITIES;
        public final Mobs MOBS;

        private Common(ForgeConfigSpec.Builder builder) {
            this.GENERAL = new General(builder);
            this.TOOLS_AND_ABILITIES = new ToolsAndAbilities(builder);
            this.MOBS = new Mobs(builder);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue glowEffect;
        public final ForgeConfigSpec.BooleanValue oldBarakoaTextures;
        public final ForgeConfigSpec.BooleanValue doCameraShakes;
        public final ForgeConfigSpec.BooleanValue playBossMusic;
        public final ForgeConfigSpec.BooleanValue customPlayerAnims;

        private Client(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.glowEffect = builder.comment("Toggles the lantern glow effect, which may look bad with certain shaders.").translation("config.mowziesmobs.glow_effect").define("glow_effect", true);
            this.oldBarakoaTextures = builder.comment("Use the old Barakoa textures instead of the current ones.").translation("config.mowziesmobs.old_barakoa_textures").define("old_barakoa_textures", false);
            this.doCameraShakes = builder.comment("Enable camera shaking during certain mob attacks and abilities.").translation("config.mowziesmobs.do_camera_shake").define("do_camera_shake", true);
            this.playBossMusic = builder.comment("Play boss battle themes during boss encounters.").translation("config.mowziesmobs.play_boss_music").define("play_boss_music", true);
            this.customPlayerAnims = builder.comment("Use custom player animations.").translation("config.mowziesmobs.custom_player_anims").define("custom_player_anims", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> freeze_blacklist;

        private General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.freeze_blacklist = builder.comment("Add a mob's full name here to prevent it from being frozen or taking damage from ice magic.").translation("config.mowziesmobs.freeze_blacklist").defineList("freeze_blacklist", Arrays.asList("mowziesmobs:frostmaw", "minecraft:enderdragon", "minecraft:blaze", "minecraft:magma_cube", "minecraft:stray", "minecraft:polar_bear", "minecraft:snow_golem"), STRING_PREDICATE);
            builder.pop();
        }
    }

    public static class ToolsAndAbilities {
        public final ForgeConfigSpec.DoubleValue geomancyAttackMultiplier;
        public final SunsBlessing SUNS_BLESSING;
        public final WroughtHelm WROUGHT_HELM;
        public final AxeOfAThousandMetals AXE_OF_A_THOUSAND_METALS;
        public final SolVisage SOL_VISAGE;
        public final IceCrystal ICE_CRYSTAL;
        public final BarakoaMask BARAKOA_MASK;
        public final BarakoaSpear BARAKOA_SPEAR;
        public final NagaFangDagger NAGA_FANG_DAGGER;
        public final Blowgun BLOW_GUN;
        public final EarthboreGauntlet EARTHBORE_GAUNTLET;

        ToolsAndAbilities(ForgeConfigSpec.Builder builder) {
            builder.push("tools_and_abilities");
            this.geomancyAttackMultiplier = builder.translation("config.mowziesmobs.geomancy_attack_multiplier").defineInRange("geomancy_attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.SUNS_BLESSING = new SunsBlessing(builder);
            this.WROUGHT_HELM = new WroughtHelm(builder);
            this.AXE_OF_A_THOUSAND_METALS = new AxeOfAThousandMetals(builder);
            this.SOL_VISAGE = new SolVisage(builder);
            this.ICE_CRYSTAL = new IceCrystal(builder);
            this.BARAKOA_MASK = new BarakoaMask(builder);
            this.BARAKOA_SPEAR = new BarakoaSpear(builder);
            this.NAGA_FANG_DAGGER = new NagaFangDagger(builder);
            this.BLOW_GUN = new Blowgun(builder);
            this.EARTHBORE_GAUNTLET = new EarthboreGauntlet(builder);
            builder.pop();
        }
    }

    public static class Mobs {
        public final Frostmaw FROSTMAW;
        public final Barako BARAKO;
        public final FerrousWroughtnaut FERROUS_WROUGHTNAUT;
        public final Grottol GROTTOL;
        public final Lantern LANTERN;
        public final Barakoa BARAKOA;
        public final Naga NAGA;
        public final Foliaath FOLIAATH;

        Mobs(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            this.FROSTMAW = new Frostmaw(builder);
            this.BARAKO = new Barako(builder);
            this.FERROUS_WROUGHTNAUT = new FerrousWroughtnaut(builder);
            this.GROTTOL = new Grottol(builder);
            this.LANTERN = new Lantern(builder);
            this.BARAKOA = new Barakoa(builder);
            this.NAGA = new Naga(builder);
            this.FOLIAATH = new Foliaath(builder);
            builder.pop();
        }
    }

    public static class SunsBlessing {
        public final ForgeConfigSpec.DoubleValue sunsBlessingAttackMultiplier;
        public final ForgeConfigSpec.IntValue effectDuration;
        public final ForgeConfigSpec.IntValue solarBeamCost;

        SunsBlessing(ForgeConfigSpec.Builder builder) {
            builder.push("suns_blessing");
            this.effectDuration = builder.comment("Duration in minutes of the Sun's Blessing effect.").translation("config.mowziesmobs.suns_blessing_duration").defineInRange("suns_blessing_duration", 60, 0, Integer.MAX_VALUE);
            this.sunsBlessingAttackMultiplier = builder.translation("config.mowziesmobs.suns_blessing_attack_multiplier").defineInRange("suns_blessing_attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.solarBeamCost = builder.comment("Cost in minutes of using the solar beam ability.").translation("config.mowziesmobs.solar_beam_cost").defineInRange("solar_beam_cost", 5, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Blowgun {
        public final ForgeConfigSpec.DoubleValue attackDamage;
        public final ForgeConfigSpec.IntValue poisonDuration;

        Blowgun(ForgeConfigSpec.Builder builder) {
            builder.push("blowgun");
            this.poisonDuration = builder.comment("Duration in ticks of the poison effect (20 ticks = 1 second).").translation("config.mowziesmobs.poison_duration").defineInRange("poison_duration", 40, 0, Integer.MAX_VALUE);
            this.attackDamage = builder.comment("Multiply all damage done with the blowgun/darts by this amount.").translation("config.mowziesmobs.attack_damage").defineInRange("attack_damage", 1.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class NagaFangDagger {
        public final ToolConfig toolConfig;
        public final ForgeConfigSpec.IntValue poisonDuration;
        public final ForgeConfigSpec.DoubleValue backstabDamageMultiplier;

        NagaFangDagger(ForgeConfigSpec.Builder builder) {
            builder.push("naga_fang_dagger");
            this.toolConfig = new ToolConfig(builder, 3.0f, 2.0f);
            this.poisonDuration = builder.comment("Duration in ticks of the poison effect (20 ticks = 1 second).").translation("config.mowziesmobs.poison_duration").defineInRange("poison_duration", 40, 0, Integer.MAX_VALUE);
            this.backstabDamageMultiplier = builder.comment("Damage multiplier when attacking from behind").translation("config.mowziesmobs.backstab_damage_mult").defineInRange("backstab_damage_mult", 2.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class BarakoaSpear {
        public final ToolConfig toolConfig;

        BarakoaSpear(ForgeConfigSpec.Builder builder) {
            builder.push("barakoa_spear");
            this.toolConfig = new ToolConfig(builder, 5.0f, 1.6f);
            builder.pop();
        }
    }

    public static class EarthboreGauntlet {
        public final ForgeConfigSpec.DoubleValue attackMultiplier;
        public final ForgeConfigSpec.BooleanValue breakable;
        public final ForgeConfigSpec.IntValue durability;
        public final ToolConfig toolConfig;

        EarthboreGauntlet(ForgeConfigSpec.Builder builder) {
            builder.push("earthbore_gauntlet");
            this.attackMultiplier = builder.comment("Multiply all damage done with the Earthbore Gauntlet by this amount.").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.breakable = builder.comment(new String[]{"Set to true for the Earthbore Gauntlet to have limited durability.", "Prevents regeneration in inventory."}).translation("config.mowziesmobs.breakable").define("breakable", false);
            this.durability = builder.comment("Earthbore Gauntlet durability").translation("config.mowziesmobs.durability").defineInRange("durability", 400, 1, Integer.MAX_VALUE);
            this.toolConfig = new ToolConfig(builder, 6.0f, 1.2f);
            builder.pop();
        }
    }

    public static class IceCrystal {
        public final ForgeConfigSpec.DoubleValue attackMultiplier;
        public final ForgeConfigSpec.BooleanValue breakable;
        public final ForgeConfigSpec.IntValue durability;

        IceCrystal(ForgeConfigSpec.Builder builder) {
            builder.push("ice_crystal");
            this.attackMultiplier = builder.comment("Multiply all damage done with the ice crystal by this amount.").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.breakable = builder.comment(new String[]{"Set to true for the ice crystal to have limited durability.", "Prevents regeneration in inventory."}).translation("config.mowziesmobs.breakable").define("breakable", false);
            this.durability = builder.comment("Ice crystal durability").translation("config.mowziesmobs.durability").defineInRange("durability", 600, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class BarakoaMask {
        public final ArmorConfig armorConfig;

        BarakoaMask(ForgeConfigSpec.Builder builder) {
            builder.push("barakoa_mask");
            this.armorConfig = new ArmorConfig(builder, ArmorMaterial.LEATHER.func_200902_b(EquipmentSlotType.HEAD), ArmorMaterial.LEATHER.func_200901_e());
            builder.pop();
        }
    }

    public static class SolVisage {
        public final ArmorConfig armorConfig;
        public final ForgeConfigSpec.BooleanValue breakable;

        SolVisage(ForgeConfigSpec.Builder builder) {
            builder.push("sol_visage");
            this.armorConfig = new ArmorConfig(builder, ArmorMaterial.GOLD.func_200902_b(EquipmentSlotType.HEAD), ArmorMaterial.GOLD.func_200901_e());
            this.breakable = builder.comment("Set to true for the Sol Visage to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class AxeOfAThousandMetals {
        public final ToolConfig toolConfig;
        public final ForgeConfigSpec.BooleanValue breakable;

        AxeOfAThousandMetals(ForgeConfigSpec.Builder builder) {
            builder.push("axe_of_a_thousand_metals");
            this.toolConfig = new ToolConfig(builder, 9.0f, 0.9f);
            this.breakable = builder.comment("Set to true for the Axe of a Thousand Metals to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class WroughtHelm {
        public final ArmorConfig armorConfig;
        public final ForgeConfigSpec.BooleanValue breakable;

        WroughtHelm(ForgeConfigSpec.Builder builder) {
            builder.push("wrought_helm");
            this.armorConfig = new ArmorConfig(builder, ArmorMaterial.IRON.func_200902_b(EquipmentSlotType.HEAD), ArmorMaterial.IRON.func_200901_e());
            this.breakable = builder.comment("Set to true for the Wrought Helm to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class Frostmaw {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ForgeConfigSpec.BooleanValue stealableIceCrystal;
        public final ForgeConfigSpec.BooleanValue hasBossBar;
        public final ForgeConfigSpec.BooleanValue healsOutOfBattle;

        Frostmaw(ForgeConfigSpec.Builder builder) {
            builder.push("frostmaw");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Arrays.asList("SNOWY,!OCEAN,!RIVER,!BEACH,!FOREST"), new ArrayList(), new ArrayList()), 50.0f, 100.0f, Arrays.asList("minecraft:village", "minecraft:pillager_outpost"));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Frostmaw's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable frostmaws healing while asleep").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.stealableIceCrystal = builder.comment("Allow players to steal frostmaws' ice crystals (only using specific means!)").translation("config.mowziesmobs.stealable_ice_crystal").define("stealable_ice_crystal", true);
            builder.pop();
        }
    }

    public static class Barako {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ForgeConfigSpec.BooleanValue hasBossBar;
        public final ForgeConfigSpec.BooleanValue healsOutOfBattle;
        public final ForgeConfigSpec.ConfigValue<? extends String> whichItem;
        public final ForgeConfigSpec.IntValue howMany;

        Barako(ForgeConfigSpec.Builder builder) {
            builder.push("barako");
            builder.comment("Generation controls for Barakoa villages");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Arrays.asList("SAVANNA"), new ArrayList(), new ArrayList()), 50.0f, 100.0f, Arrays.asList("minecraft:village", "minecraft:pillager_outpost"));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Barako's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable Barako healing while not in combat").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.whichItem = builder.comment("Which item Barako desires in exchange for the Sun's Blessing").translation("config.mowziesmobs.trade_which_item").define("trade_which_item", (Object)"minecraft:gold_block", ITEM_NAME_PREDICATE);
            this.howMany = builder.comment("How many of the item Barako desires in exchange for the Sun's Blessing").translation("config.mowziesmobs.trade_how_many").defineInRange("trade_how_many", 7, 0, 64);
            builder.pop();
        }
    }

    public static class FerrousWroughtnaut {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ForgeConfigSpec.BooleanValue hasBossBar;
        public final ForgeConfigSpec.BooleanValue healsOutOfBattle;

        FerrousWroughtnaut(ForgeConfigSpec.Builder builder) {
            builder.push("ferrous_wroughtnaut");
            this.generationConfig = new GenerationConfig(builder, 15, 5, new BiomeConfig(builder, Arrays.asList("!OCEAN"), new ArrayList(), new ArrayList()), 30.0f, 55.0f, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Ferrous Wroughtnaut's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable Ferrous Wroughtnaut healing while not active").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            builder.pop();
        }
    }

    public static class Grottol {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Grottol(ForgeConfigSpec.Builder builder) {
            builder.push("grottol");
            this.spawnConfig = new SpawnConfig(builder, 2, 1, 1, 1.0, new BiomeConfig(builder, Collections.singletonList("!MUSHROOM"), new ArrayList(), new ArrayList()), Collections.emptyList(), Collections.singletonList("minecraft:base_stone_overworld"), 25, -1, true, false, true, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Lantern {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Lantern(ForgeConfigSpec.Builder builder) {
            builder.push("lantern");
            this.spawnConfig = new SpawnConfig(builder, 5, 2, 4, 1.0, new BiomeConfig(builder, Collections.singletonList("FOREST,MAGICAL,!SNOWY"), Arrays.asList("minecraft:dark_forest", "minecraft:dark_forest_hills"), new ArrayList()), Collections.emptyList(), Arrays.asList("minecraft:valid_spawn", "minecraft:leaves", "minecraft:logs"), -1, 60, true, false, false, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Naga {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Naga(ForgeConfigSpec.Builder builder) {
            builder.push("naga");
            this.spawnConfig = new SpawnConfig(builder, 15, 2, 4, 1.0, new BiomeConfig(builder, Arrays.asList("BEACH,MOUNTAIN", "BEACH,HILLS"), Collections.singletonList("minecraft:stone_shore"), new ArrayList()), Collections.emptyList(), Collections.emptyList(), -1, 70, false, true, false, Arrays.asList("minecraft:village", "minecraft:pillager_outpost"));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Barakoa {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Barakoa(ForgeConfigSpec.Builder builder) {
            builder.push("barakoa");
            builder.comment(new String[]{"Controls spawning for Barakoana hunting groups", "Group size controls how many elites spawn, not followers", "See Barako config for village controls"});
            this.spawnConfig = new SpawnConfig(builder, 5, 1, 1, 1.0, new BiomeConfig(builder, Collections.singletonList("SAVANNA"), new ArrayList(), new ArrayList()), Collections.emptyList(), Arrays.asList("minecraft:valid_spawn", "minecraft:sand"), -1, 60, false, false, false, Arrays.asList("minecraft:village", "minecraft:pillager_outpost", "mowziesmobs:barakoa_village"));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Foliaath {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Foliaath(ForgeConfigSpec.Builder builder) {
            builder.push("foliaath");
            this.spawnConfig = new SpawnConfig(builder, 70, 1, 4, 1.0, new BiomeConfig(builder, Collections.singletonList("JUNGLE"), new ArrayList(), new ArrayList()), Collections.emptyList(), Arrays.asList("minecraft:valid_spawn", "minecraft:leaves", "minecraft:logs"), -1, 60, false, false, false, Arrays.asList("minecraft:village", "minecraft:pillager_outpost"));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class ArmorConfig {
        public final ForgeConfigSpec.IntValue damageReduction;
        public final ForgeConfigSpec.DoubleValue toughness;

        ArmorConfig(ForgeConfigSpec.Builder builder, int damageReduction, float toughness) {
            builder.push("armor_config");
            this.damageReduction = builder.comment("See official Minecraft Wiki for an explanation of how armor damage reduction works.").translation("config.mowziesmobs.damage_reduction").defineInRange("damage_reduction", damageReduction, 0, Integer.MAX_VALUE);
            this.toughness = builder.comment("See official Minecraft Wiki for an explanation of how armor toughness works.").translation("config.mowziesmobs.toughness").defineInRange("toughness", (double)toughness, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class ToolConfig {
        public final ForgeConfigSpec.DoubleValue attackDamage;
        public final ForgeConfigSpec.DoubleValue attackSpeed;

        ToolConfig(ForgeConfigSpec.Builder builder, float attackDamage, float attackSpeed) {
            builder.push("tool_config");
            this.attackDamage = builder.comment("Tool attack damage").translation("config.mowziesmobs.attack_damage").defineInRange("attack_damage", (double)attackDamage, 0.0, Double.MAX_VALUE);
            this.attackSpeed = builder.comment("Tool attack speed").translation("config.mowziesmobs.attack_speed").defineInRange("attack_speed", (double)attackSpeed, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class CombatConfig {
        public final ForgeConfigSpec.DoubleValue healthMultiplier;
        public final ForgeConfigSpec.DoubleValue attackMultiplier;

        CombatConfig(ForgeConfigSpec.Builder builder, float healthMultiplier, float attackMultiplier) {
            builder.push("combat_config");
            this.healthMultiplier = builder.comment("Scale mob health by this value").translation("config.mowziesmobs.health_multiplier").defineInRange("health_multiplier", (double)healthMultiplier, 0.0, Double.MAX_VALUE);
            this.attackMultiplier = builder.comment("Scale mob attack damage by this value").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", (double)attackMultiplier, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class GenerationConfig {
        public final ForgeConfigSpec.IntValue generationDistance;
        public final ForgeConfigSpec.IntValue generationSeparation;
        public final BiomeConfig biomeConfig;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
        public final ForgeConfigSpec.DoubleValue heightMin;
        public final ForgeConfigSpec.DoubleValue heightMax;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> avoidStructures;

        GenerationConfig(ForgeConfigSpec.Builder builder, int generationDistance, int generationSeparation, BiomeConfig biomeConfig, float heightMin, float heightMax, List<String> avoidStructures) {
            builder.comment("Controls for spawning structure/mob with world generation");
            builder.push("generation_config");
            this.generationDistance = builder.comment(new String[]{"Smaller number causes more generation, -1 to disable generation", "Maximum number of chunks between placements of this mob/structure"}).translation("config.mowziesmobs.generation_distance").defineInRange("generation_distance", generationDistance, -1, Integer.MAX_VALUE);
            this.generationSeparation = builder.comment(new String[]{"Smaller number causes more generation, -1 to disable generation", "Minimum number of chunks between placements of this mob/structure"}).translation("config.mowziesmobs.generation_separation").defineInRange("generation_separation", generationSeparation, -1, Integer.MAX_VALUE);
            this.biomeConfig = biomeConfig;
            this.dimensions = builder.comment("Names of dimensions this mob/structure can generate in").translation("config.mowziesmobs.dimensions").defineList("dimensions", Collections.singletonList("minecraft:overworld"), STRING_PREDICATE);
            this.heightMax = builder.comment("Maximum height for generation placement. -1 to ignore").translation("config.mowziesmobs.height_max").defineInRange("height_max", (double)heightMax, -1.0, 256.0);
            this.heightMin = builder.comment("Minimum height for generation placement. -1 to ignore").translation("config.mowziesmobs.height_min").defineInRange("height_min", (double)heightMin, -1.0, 256.0);
            this.avoidStructures = builder.comment("Names of structures this mob/structure will avoid when generating").translation("config.mowziesmobs.avoid_structures").defineList("avoid_structures", avoidStructures, STRING_PREDICATE);
            builder.pop();
        }
    }

    public static class SpawnConfig {
        public final ForgeConfigSpec.IntValue spawnRate;
        public final ForgeConfigSpec.IntValue minGroupSize;
        public final ForgeConfigSpec.IntValue maxGroupSize;
        public final ForgeConfigSpec.DoubleValue extraRarity;
        public final BiomeConfig biomeConfig;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
        public final ForgeConfigSpec.IntValue heightMin;
        public final ForgeConfigSpec.IntValue heightMax;
        public final ForgeConfigSpec.BooleanValue needsDarkness;
        public final ForgeConfigSpec.BooleanValue needsSeeSky;
        public final ForgeConfigSpec.BooleanValue needsCantSeeSky;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedBlockTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> avoidStructures;

        SpawnConfig(ForgeConfigSpec.Builder builder, int spawnRate, int minGroupSize, int maxGroupSize, double extraRarity, BiomeConfig biomeConfig, List<? extends String> allowedBlocks, List<? extends String> allowedBlockTags, int heightMax, int heightMin, boolean needsDarkness, boolean needsSeeSky, boolean needsCantSeeSky, List<String> avoidStructures) {
            builder.comment("Controls for vanilla-style mob spawning");
            builder.push("spawn_config");
            this.spawnRate = builder.comment("Smaller number causes less spawning, 0 to disable spawning").translation("config.mowziesmobs.spawn_rate").defineInRange("spawn_rate", spawnRate, 0, Integer.MAX_VALUE);
            this.minGroupSize = builder.comment("Minimum number of mobs that appear in a spawn group").translation("config.mowziesmobs.min_group_size").defineInRange("min_group_size", minGroupSize, 1, Integer.MAX_VALUE);
            this.maxGroupSize = builder.comment("Maximum number of mobs that appear in a spawn group").translation("config.mowziesmobs.max_group_size").defineInRange("max_group_size", maxGroupSize, 1, Integer.MAX_VALUE);
            this.extraRarity = builder.comment("Probability of a spawn attempt succeeding. 1 for normal spawning, 0 will prevent spawning. Used to make mobs extra rare.").translation("config.mowziesmobs.extra_rarity").defineInRange("extra_rarity", extraRarity, 0.0, 1.0);
            this.biomeConfig = biomeConfig;
            this.dimensions = builder.comment("Names of dimensions this mob can spawn in").translation("config.mowziesmobs.dimensions").defineList("dimensions", Collections.singletonList("minecraft:overworld"), STRING_PREDICATE);
            this.allowedBlocks = builder.comment("Names of blocks this mob is allowed to spawn on. Leave blank to ignore block names.").translation("config.mowziesmobs.allowed_blocks").defineList("allowed_blocks", allowedBlocks, STRING_PREDICATE);
            this.allowedBlockTags = builder.comment("Tags of blocks this mob is allowed to spawn on. Leave blank to ignore block tags.").translation("config.mowziesmobs.allowed_block_tags").defineList("allowed_block_tags", allowedBlockTags, STRING_PREDICATE);
            this.heightMax = builder.comment("Maximum height for this spawn. -1 to ignore.").translation("config.mowziesmobs.height_max").defineInRange("height_max", heightMax, -1, 256);
            this.heightMin = builder.comment("Minimum height for this spawn. -1 to ignore.").translation("config.mowziesmobs.height_min").defineInRange("height_min", heightMin, -1, 256);
            this.needsDarkness = builder.comment("Set to true to only allow this mob to spawn in the dark, like zombies and skeletons.").translation("config.mowziesmobs.needs_darkness").define("needs_darkness", needsDarkness);
            this.needsSeeSky = builder.comment("Set to true to only spawn mob if it can see the sky.").translation("config.mowziesmobs.min_group_size").define("needs_see_sky", needsSeeSky);
            this.needsCantSeeSky = builder.comment("Set to true to only spawn mob if it can't see the sky.").translation("config.mowziesmobs.min_group_size").define("needs_cant_see_sky", needsCantSeeSky);
            this.avoidStructures = builder.comment("Names of structures this mob will avoid spawning near.").translation("config.mowziesmobs.avoid_structures").defineList("avoid_structures", avoidStructures, STRING_PREDICATE);
            builder.pop();
        }
    }

    public static class BiomeConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeTypes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeBlacklist;

        BiomeConfig(ForgeConfigSpec.Builder builder, List<? extends String> biomeTypes, List<? extends String> biomeWhitelist, List<? extends String> biomeBlacklist) {
            builder.push("biome_config");
            this.biomeTypes = builder.comment(new String[]{"Each entry is a combination of allowed biome types.", "Separate types with commas to require biomes to have all types in an entry", "Put a '!' before a biome type to mean NOT that type", "A blank entry means all biomes. No entries means no biomes.", "For example, 'FOREST,MAGICAL,!SNOWY' would mean all biomes that are magical forests but not snowy", "'!MOUNTAIN' would mean all non-mountain biomes"}).translation("config.mowziesmobs.biome_type").defineList("biome_type", biomeTypes, STRING_PREDICATE);
            this.biomeWhitelist = builder.comment("Allow spawns in these biomes regardless of the biome type settings").translation("config.mowziesmobs.biome_whitelist").defineList("biome_whitelist", biomeWhitelist, STRING_PREDICATE);
            this.biomeBlacklist = builder.comment("Prevent spawns in these biomes regardless of the biome type settings").translation("config.mowziesmobs.biome_blacklist").defineList("biome_blacklist", biomeBlacklist, STRING_PREDICATE);
            builder.pop();
        }
    }
}

