/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.util.math.MathHelper;

public class SmartBodyHelper
extends BodyController {
    private static final float MAX_ROTATE = 75.0f;
    private static final int HISTORY_SIZE = 10;
    private final MobEntity entity;
    private int rotateTime;
    private float targetYawHead;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];

    public SmartBodyHelper(MobEntity entity) {
        super(entity);
        this.entity = entity;
    }

    public void func_75664_a() {
        double dz;
        for (int i = this.histPosX.length - 1; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.func_226277_ct_();
        this.histPosZ[0] = this.entity.func_226281_cx_();
        double dx = this.delta(this.histPosX);
        double distSq = dx * dx + (dz = this.delta(this.histPosZ)) * dz;
        if (distSq > 2.5E-7) {
            double moveAngle = (float)MathHelper.func_181159_b((double)dz, (double)dx) * 57.295776f - 90.0f;
            this.entity.field_70761_aq = (float)((double)this.entity.field_70761_aq + MathHelper.func_76138_g((double)(moveAngle - (double)this.entity.field_70761_aq)) * (double)0.6f);
            this.targetYawHead = this.entity.field_70759_as;
            this.rotateTime = 0;
        } else if (this.entity.func_184188_bt().isEmpty() || !(this.entity.func_184188_bt().get(0) instanceof MobEntity)) {
            float limit = 75.0f;
            if (Math.abs(this.entity.field_70759_as - this.targetYawHead) > 15.0f) {
                this.rotateTime = 0;
                this.targetYawHead = this.entity.field_70759_as;
            } else {
                ++this.rotateTime;
                int speed = 10;
                if (this.rotateTime > 10) {
                    limit = Math.max(1.0f - (float)(this.rotateTime - 10) / 10.0f, 0.0f) * 75.0f;
                }
            }
            this.entity.field_70761_aq = SmartBodyHelper.approach(this.entity.field_70759_as, this.entity.field_70761_aq, limit);
        }
    }

    private double delta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double mean = 0.0;
        for (int i = 0; i < 5; ++i) {
            mean += arr[i + start];
        }
        return mean / (double)arr.length;
    }

    public static float approach(float target, float current, float limit) {
        float delta = MathHelper.func_76142_g((float)(current - target));
        if (delta < -limit) {
            delta = -limit;
        } else if (delta >= limit) {
            delta = limit;
        }
        return target + delta * 0.55f;
    }
}

