/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAxeAttack
extends EntityMagicEffect {
    private static final DataParameter<Boolean> VERTICAL = EntityDataManager.func_187226_a(EntityAxeAttack.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> AXE_STACK = EntityDataManager.func_187226_a(EntityAxeAttack.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static int SWING_DURATION_HOR = 24;
    public static int SWING_DURATION_VER = 30;
    private float quakeAngle = 0.0f;
    private AxisAlignedBB quakeBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public EntityAxeAttack(EntityType<? extends EntityAxeAttack> type, World world) {
        super(type, world);
    }

    public EntityAxeAttack(EntityType<? extends EntityAxeAttack> type, World world, LivingEntity caster, boolean vertical) {
        this(type, world);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
        this.setVertical(vertical);
        this.setAxeStack(caster.func_184614_ca());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(VERTICAL, (Object)false);
        this.func_184212_Q().func_187214_a(AXE_STACK, (Object)ItemHandler.WROUGHT_AXE.func_190903_i());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.caster != null) {
            if (!this.caster.func_70089_S()) {
                this.func_70106_y();
            }
            this.func_70080_a(this.caster.func_226277_ct_(), this.caster.func_226278_cu_() + (double)this.caster.func_70047_e(), this.caster.func_226281_cx_(), this.caster.field_70177_z, this.caster.field_70125_A);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 7) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 0.7f, 1.1f);
        }
        if (!this.field_70170_p.field_72995_K && this.caster != null) {
            if (!this.getVertical() && this.field_70173_aa == SWING_DURATION_HOR / 2 - 1) {
                this.dealDamage(7.0f * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f, 4.0f, 160.0f, 1.2f);
            } else if (this.getVertical() && this.field_70173_aa == SWING_DURATION_VER / 2 - 1) {
                this.dealDamage(((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue(), 4.5f, 40.0f, 0.8f);
                this.quakeAngle = this.field_70177_z;
                this.quakeBB = this.func_174813_aQ().func_72317_d(0.0, (double)(-this.caster.func_70047_e()), 0.0);
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_LAND.get(), 0.3f, 0.5f);
                this.func_184185_a(SoundEvents.field_187539_bB, 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.1f);
            } else if (this.getVertical() && this.field_70173_aa == SWING_DURATION_VER / 2 + 1) {
                EntityCameraShake.cameraShake(this.field_70170_p, this.func_213303_ch(), 10.0f, 0.05f, 0, 10);
            }
        }
        if (this.getVertical() && this.caster != null && this.field_70173_aa >= SWING_DURATION_VER / 2) {
            int maxDistance = 16;
            double perpFacing = (double)this.quakeAngle * (Math.PI / 180);
            double facingAngle = perpFacing + 1.5707963267948966;
            int hitY = MathHelper.func_76128_c((double)(this.quakeBB.field_72338_b - 0.5));
            int distance = this.field_70173_aa - 15;
            double spread = 1.099557410031076;
            int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
            double minY = this.quakeBB.field_72338_b;
            double maxY = this.quakeBB.field_72337_e;
            for (int i = 0; i < arcLen; ++i) {
                double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                double vx = Math.cos(theta);
                double vz = Math.sin(theta);
                double px = this.func_226277_ct_() + vx * (double)distance;
                double pz = this.func_226281_cx_() + vz * (double)distance;
                float factor = 1.0f - (float)distance / (float)maxDistance;
                AxisAlignedBB selection = new AxisAlignedBB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                List hit = this.field_70170_p.func_217357_a(Entity.class, selection);
                for (Entity entity : hit) {
                    if (!entity.func_233570_aj_() || entity == this || entity instanceof FallingBlockEntity || entity == this.caster) continue;
                    float applyKnockbackResistance = 0.0f;
                    boolean hitEntity = false;
                    if (entity instanceof LivingEntity) {
                        if (!this.raytraceCheckEntity(entity)) continue;
                        hitEntity = this.caster instanceof PlayerEntity ? entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.caster)), (factor * 5.0f + 1.0f) * (((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f)) : entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.caster), (factor * 5.0f + 1.0f) * (((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f));
                        applyKnockbackResistance = (float)((LivingEntity)entity).func_110148_a(Attributes.field_233820_c_).func_111126_e();
                    }
                    if (!hitEntity) continue;
                    double magnitude = -4.0;
                    double x = vx * (double)(1.0f - factor) * magnitude * (double)(1.0f - applyKnockbackResistance);
                    double y = 0.0;
                    if (entity.func_233570_aj_()) {
                        y += 0.15 * (double)(1.0f - applyKnockbackResistance);
                    }
                    double z = vz * (double)(1.0f - factor) * magnitude * (double)(1.0f - applyKnockbackResistance);
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c(x, y, z));
                    if (!(entity instanceof ServerPlayerEntity)) continue;
                    ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                }
                if (!this.field_70170_p.field_73012_v.nextBoolean()) continue;
                int hitX = MathHelper.func_76128_c((double)px);
                int hitZ = MathHelper.func_76128_c((double)pz);
                BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                BlockPos abovePos = new BlockPos((Vector3i)pos).func_177984_a();
                BlockState block = this.field_70170_p.func_180495_p(pos);
                BlockState blockAbove = this.field_70170_p.func_180495_p(abovePos);
                if (block.func_185904_a() == Material.field_151579_a || !block.func_215686_e((IBlockReader)this.field_70170_p, pos) || block.func_177230_c().hasTileEntity(block) || blockAbove.func_185904_a().func_76230_c()) continue;
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.field_70170_p, block, 0.3f);
                fallingBlock.func_70107_b((double)hitX + 0.5, hitY + 1, (double)hitZ + 0.5);
                this.field_70170_p.func_217376_c((Entity)fallingBlock);
            }
        }
        if (this.field_70173_aa > SWING_DURATION_HOR) {
            this.func_70106_y();
        }
    }

    private void dealDamage(float damage, float range, float arc, float applyKnockback) {
        boolean hit = false;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, 2.0, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70177_z % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_())) - entityHit.func_213311_cf() / 2.0f;
            if (!(entityHit != this.caster && (!(entityHit instanceof ParrotEntity) || entityHit.func_184187_bx() != this.caster) && entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || !this.raytraceCheckEntity((Entity)entityHit)) continue;
            PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)this.caster, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
            if (playerCapability != null) {
                playerCapability.setAxeCanAttack(true);
                if (this.caster instanceof PlayerEntity) {
                    this.attackTargetEntityWithCurrentItem((Entity)entityHit, (PlayerEntity)this.caster, damage / ItemHandler.WROUGHT_AXE.func_234675_d_(), applyKnockback);
                }
                playerCapability.setAxeCanAttack(false);
            } else {
                entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.caster), damage);
                entityHit.func_213293_j(entityHit.func_213322_ci().field_72450_a * (double)applyKnockback, entityHit.func_213322_ci().field_72448_b, entityHit.func_213322_ci().field_72449_c * (double)applyKnockback);
            }
            hit = true;
        }
        if (hit) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_HIT.get(), 0.3f, 0.5f);
        }
    }

    public void setVertical(boolean vertical) {
        this.func_184212_Q().func_187227_b(VERTICAL, (Object)vertical);
    }

    public boolean getVertical() {
        return (Boolean)this.func_184212_Q().func_187225_a(VERTICAL);
    }

    private List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && (double)this.func_70032_d((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.func_213311_cf() / 2.0f)).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public LivingEntity getCaster() {
        return this.caster;
    }

    public void setAxeStack(ItemStack axeStack) {
        this.func_184212_Q().func_187227_b(AXE_STACK, (Object)axeStack);
    }

    public ItemStack getAxeStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(AXE_STACK);
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity, PlayerEntity player, float damageMult, float knockbackMult) {
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)player, (Entity)targetEntity)) {
            return;
        }
        ItemStack oldStack = player.func_184614_ca();
        ItemStack newStack = this.getAxeStack();
        player.func_184611_a(Hand.MAIN_HAND, newStack);
        player.func_233645_dx_().func_233793_b_(newStack.func_111283_C(EquipmentSlotType.MAINHAND));
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float f = (float)player.func_233637_b_(Attributes.field_233823_f_) * damageMult;
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float f2 = 1.0f;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((LivingEntity)player);
                if (player.func_70051_ag() && flag) {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                f += f1;
                boolean flag3 = false;
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((LivingEntity)player);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d vector3d = targetEntity.func_213322_ci();
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).func_233627_a_((float)i * 0.5f * knockbackMult, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f * knockbackMult), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f * knockbackMult));
                        }
                        player.func_213317_d(player.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        player.func_70031_b(false);
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(vector3d);
                    }
                    if (flag) {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                    } else {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof PartEntity) {
                        entity = ((PartEntity)targetEntity).getParent();
                    }
                    if (!player.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((LivingEntity)entity, player);
                        if (itemstack1.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).func_110143_aJ();
                        player.func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (player.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.func_71020_j(0.1f);
                } else {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
        player.func_184611_a(Hand.MAIN_HAND, oldStack);
        player.func_233645_dx_().func_233793_b_(oldStack.func_111283_C(EquipmentSlotType.MAINHAND));
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAxeStack(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("axe_stack")));
        this.setVertical(compound.func_74767_n("vertical"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("axe_stack", (INBT)this.getAxeStack().func_77955_b(new CompoundNBT()));
        compound.func_74757_a("vertical", this.getVertical());
    }
}

