/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.MowzieToolItem;
import com.google.common.collect.Sets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ItemEarthboreGauntlet
extends MowzieToolItem
implements IAnimatable,
ISyncable {
    public static final int ANIM_REST = 0;
    public static final int ANIM_OPEN = 1;
    public static final int ANIM_FIST = 2;
    public String controllerName = "controller";
    public String controllerIdleName = "controller_idle";
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ItemEarthboreGauntlet(Item.Properties properties) {
        super(-2.0f + ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.toolConfig.attackDamage.get()).floatValue(), -4.0f + ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.toolConfig.attackSpeed.get()).floatValue(), (IItemTier)ItemTier.STONE, Sets.newHashSet(), properties);
        GeckoLibNetwork.registerSyncable((ForgeRegistryEntry)this);
    }

    public boolean func_77645_m() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)playerIn);
        if (abilityCapability != null) {
            playerIn.func_184598_c(handIn);
            if (stack.func_77952_i() + 5 < stack.func_77958_k() || ((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.breakable.get()).booleanValue()) {
                if (!worldIn.func_201670_d()) {
                    AbilityHandler.INSTANCE.sendAbilityMessage(playerIn, AbilityHandler.TUNNELING_ABILITY);
                }
                this.showDurabilityBar(playerIn.func_184586_b(handIn));
                playerIn.func_184598_c(handIn);
                return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
            }
            abilityCapability.getAbilityMap().get(AbilityHandler.TUNNELING_ABILITY).end();
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.durability.get();
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.0").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.1").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.2").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.3").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
        if (!((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.breakable.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".text.4").func_230530_a_(ItemHandler.TOOLTIP_STYLE));
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, this.controllerIdleName, 3.0f, this::predicateIdle));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, this.controllerName, 3.0f, this::predicate));
    }

    public <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public <P extends Item> PlayState predicateIdle(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability(entity);
        if (abilityCapability != null && abilityCapability.getActiveAbility() == null && entity.func_184607_cu() != stack) {
            this.playAnimation(entity, stack, 2);
        }
        return super.onEntitySwing(stack, entity);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void onAnimationSync(int id, int state) {
        AnimationController controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)this.controllerName);
        controller.markNeedsReload();
        if (state == 0) {
            controller.clearAnimationCache();
            controller.setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        } else if (state == 1) {
            controller.clearAnimationCache();
            controller.setAnimation(new AnimationBuilder().addAnimation("open", Boolean.valueOf(true)));
        } else if (state == 2) {
            controller.clearAnimationCache();
            controller.setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(false)));
        }
    }

    public void playAnimation(LivingEntity entity, Hand hand, int state) {
        ItemStack stack = entity.func_184586_b(hand);
        this.playAnimation(entity, stack, state);
    }

    public void playAnimation(LivingEntity entity, ItemStack stack, int state) {
        if (!entity.field_70170_p.field_72995_K) {
            int id = GeckoLibUtil.guaranteeIDForStack((ItemStack)stack, (ServerWorld)((ServerWorld)entity.field_70170_p));
            PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity);
            GeckoLibNetwork.syncAnimation((PacketDistributor.PacketTarget)target, (ISyncable)this, (int)id, (int)state);
        }
    }

    @Override
    public ConfigHandler.ToolConfig getConfig() {
        return ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.toolConfig;
    }
}

