/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeChecker {
    public static boolean isBiomeInConfig(ConfigHandler.BiomeConfig biomeConfig, ResourceLocation biomeName) {
        if (((List)biomeConfig.biomeWhitelist.get()).contains(biomeName.toString())) {
            return true;
        }
        if (((List)biomeConfig.biomeBlacklist.get()).contains(biomeName.toString())) {
            return false;
        }
        HashSet<BiomeCombo> biomeCombos = new HashSet<BiomeCombo>();
        for (String biomeComboString : (List)biomeConfig.biomeTypes.get()) {
            BiomeCombo biomeCombo = new BiomeCombo(biomeComboString);
            biomeCombos.add(biomeCombo);
        }
        RegistryKey biomeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biomeName);
        for (BiomeCombo biomeCombo : biomeCombos) {
            if (!biomeCombo.acceptsBiome((RegistryKey<Biome>)biomeRegistryKey)) continue;
            return true;
        }
        return false;
    }

    private static class BiomeCombo {
        BiomeDictionary.Type[] neededTypes;
        boolean[] inverted;

        private BiomeCombo(String biomeComboString) {
            String[] typeStrings = biomeComboString.toUpperCase().replace(" ", "").split(",");
            this.neededTypes = new BiomeDictionary.Type[typeStrings.length];
            this.inverted = new boolean[typeStrings.length];
            for (int i = 0; i < typeStrings.length; ++i) {
                BiomeDictionary.Type neededType;
                if (typeStrings[i].length() == 0) continue;
                this.inverted[i] = typeStrings[i].charAt(0) == '!';
                String name = typeStrings[i].replace("!", "");
                Collection allTypes = BiomeDictionary.Type.getAll();
                if (!allTypes.contains(neededType = BiomeDictionary.Type.getType((String)name, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]))) {
                    System.out.println("Mowzie's Mobs config warning: No biome dictionary type with name '" + name + "'. Unable to check for type.");
                }
                this.neededTypes[i] = neededType;
            }
        }

        private boolean acceptsBiome(RegistryKey<Biome> biome) {
            Set thisTypes = BiomeDictionary.getTypes(biome);
            for (int i = 0; i < this.neededTypes.length; ++i) {
                if (this.neededTypes[i] == null || !(!this.inverted[i] ? !thisTypes.contains(this.neededTypes[i]) : thisTypes.contains(this.neededTypes[i]))) continue;
                return false;
            }
            return true;
        }
    }
}

