/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.server.network;

import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimationMessage {
    private int entityID;
    private int index;

    public AnimationMessage() {
    }

    public AnimationMessage(int entityID, int index) {
        this.entityID = entityID;
        this.index = index;
    }

    public static void serialize(AnimationMessage message, PacketBuffer buf) {
        buf.func_150787_b(message.entityID);
        buf.func_150787_b(message.index);
    }

    public static AnimationMessage deserialize(PacketBuffer buf) {
        AnimationMessage message = new AnimationMessage();
        message.entityID = buf.func_150792_a();
        message.index = buf.func_150792_a();
        return message;
    }

    public static class Handler
    implements BiConsumer<AnimationMessage, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(AnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                IAnimatedEntity entity = (IAnimatedEntity)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
                if (entity != null) {
                    if (message.index == -1) {
                        entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
                    } else {
                        entity.setAnimation(entity.getAnimations()[message.index]);
                    }
                    entity.setAnimationTick(0);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

