/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.gui.ScreenImageButton;
import com.tiviacz.travelersbackpack.client.gui.TankScreen;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackBaseContainer;
import com.tiviacz.travelersbackpack.network.CycleToolPacket;
import com.tiviacz.travelersbackpack.network.EquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.SleepingBagPacket;
import com.tiviacz.travelersbackpack.network.UnequipBackpackPacket;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends ContainerScreen<TravelersBackpackBaseContainer> {
    public static final ResourceLocation SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack.png");
    private static final ScreenImageButton bedButton = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton equipButton = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton unequipButton = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton emptyTankButtonLeft = new ScreenImageButton(14, 86, 9, 9);
    private static final ScreenImageButton emptyTankButtonRight = new ScreenImageButton(225, 86, 9, 9);
    private static final ScreenImageButton disabledCraftingButton = new ScreenImageButton(225, 96, 18, 18);
    private final ITravelersBackpackInventory inv;
    private final byte screenID;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;

    public TravelersBackpackScreen(TravelersBackpackBaseContainer screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
        this.inv = screenContainer.inventory;
        this.screenID = screenContainer.inventory.getScreenID();
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 207;
        this.tankLeft = new TankScreen(this.inv.getLeftTank(), 25, 7, 100, 16);
        this.tankRight = new TankScreen(this.inv.getRightTank(), 207, 7, 100, 16);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.inv.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(matrixStack);
        }
        if (!this.inv.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(matrixStack);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            this.func_243308_b(matrixStack, this.tankLeft.getTankTooltip(), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            this.func_243308_b(matrixStack, this.tankRight.getTankTooltip(), mouseX, mouseY);
        }
        if (this.screenID == 2 && ((Boolean)TravelersBackpackConfig.COMMON.enableEmptyTankButton.get()).booleanValue() && (emptyTankButtonLeft.inButton(this, mouseX, mouseY) || emptyTankButtonRight.inButton(this, mouseX, mouseY))) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.empty_tank"), mouseX, mouseY);
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.disableCrafting.get()).booleanValue() && disabledCraftingButton.inButton(this, mouseX, mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.disabled_crafting"), mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(SCREEN_TRAVELERS_BACKPACK);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((Boolean)TravelersBackpackConfig.SERVER.disableCrafting.get()).booleanValue()) {
            disabledCraftingButton.draw(matrixStack, this, 77, 208);
        }
        if (this.inv.hasTileEntity()) {
            if (bedButton.inButton(this, mouseX, mouseY)) {
                bedButton.draw(matrixStack, this, 20, 227);
            } else {
                bedButton.draw(matrixStack, this, 1, 227);
            }
        } else {
            if (!CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1 && !TravelersBackpack.enableCurios()) {
                if (equipButton.inButton(this, mouseX, mouseY)) {
                    equipButton.draw(matrixStack, this, 58, 208);
                } else {
                    equipButton.draw(matrixStack, this, 39, 208);
                }
            }
            if (CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2) {
                if (!TravelersBackpack.enableCurios()) {
                    if (unequipButton.inButton(this, mouseX, mouseY)) {
                        unequipButton.draw(matrixStack, this, 58, 227);
                    } else {
                        unequipButton.draw(matrixStack, this, 39, 227);
                    }
                }
                if (((Boolean)TravelersBackpackConfig.COMMON.enableEmptyTankButton.get()).booleanValue()) {
                    if (emptyTankButtonLeft.inButton(this, mouseX, mouseY)) {
                        emptyTankButtonLeft.draw(matrixStack, this, 29, 217);
                    } else {
                        emptyTankButtonLeft.draw(matrixStack, this, 10, 217);
                    }
                    if (emptyTankButtonRight.inButton(this, mouseX, mouseY)) {
                        emptyTankButtonRight.draw(matrixStack, this, 29, 217);
                    } else {
                        emptyTankButtonRight.draw(matrixStack, this, 10, 217);
                    }
                }
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.inv.hasTileEntity() && bedButton.inButton(this, (int)mouseX, (int)mouseY)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SleepingBagPacket(this.inv.getPosition()));
            return true;
        }
        if (!this.inv.hasTileEntity() && !CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1 && equipButton.inButton(this, (int)mouseX, (int)mouseY)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new EquipBackpackPacket(true));
            return true;
        }
        if (!this.inv.hasTileEntity() && CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2) {
            if (unequipButton.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new UnequipBackpackPacket(true));
                return true;
            }
            if (((Boolean)TravelersBackpackConfig.COMMON.enableEmptyTankButton.get()).booleanValue()) {
                if (!this.inv.getLeftTank().isEmpty() && emptyTankButtonLeft.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new CycleToolPacket(1.0, 3));
                }
                if (!this.inv.getRightTank().isEmpty() && emptyTankButtonRight.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new CycleToolPacket(2.0, 3));
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }
}

