/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.common.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public TravelersBackpackWearableModel model;

    public TravelersBackpackLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        TravelersBackpackInventory inv;
        if (CapabilityUtils.isWearingBackpack((PlayerEntity)entitylivingbaseIn) && (inv = CapabilityUtils.getBackpackInv((PlayerEntity)entitylivingbaseIn)) != null && entitylivingbaseIn.func_184833_s() && !entitylivingbaseIn.func_82150_aj()) {
            if (TravelersBackpackConfig.curiosIntegration && TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)entitylivingbaseIn).isPresent()) {
                ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entitylivingbaseIn).resolve().get();
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)curios.getStacksHandler("back").get()).getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (!(stackHandler.getStackInSlot(i).func_77973_b() instanceof TravelersBackpackItem)) continue;
                    if (((Boolean)((ICurioStacksHandler)curios.getCurios().get("back")).getRenders().get(i)).booleanValue()) {
                        this.renderLayer(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, inv);
                        continue;
                    }
                    return;
                }
            }
            ItemStack stack = entitylivingbaseIn.func_184582_a(EquipmentSlotType.CHEST);
            if (!((Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get()).booleanValue()) {
                if (stack.func_77973_b() instanceof ElytraItem) {
                    return;
                }
                this.renderLayer(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, inv);
            } else {
                this.renderLayer(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, inv);
            }
        }
    }

    private void renderLayer(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity entitylivingbaseIn, ITravelersBackpackInventory inv) {
        this.model = new TravelersBackpackWearableModel((PlayerEntity)entitylivingbaseIn, bufferIn);
        boolean flag = inv.getItemStack().func_77973_b() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get();
        ResourceLocation loc = ResourceUtils.getBackpackTexture(inv.getItemStack().func_77973_b());
        boolean isColorable = false;
        if (inv.getItemStack().func_77978_p() != null && BackpackDyeRecipe.hasColor(inv.getItemStack())) {
            isColorable = true;
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
        }
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(flag ? RenderType.func_228642_d_((ResourceLocation)loc) : RenderType.func_228634_a_((ResourceLocation)loc));
        matrixStackIn.func_227860_a_();
        if (entitylivingbaseIn.func_213453_ef()) {
            matrixStackIn.func_227861_a_(0.0, -0.155, 0.025);
        }
        ((PlayerModel)this.func_215332_c()).func_217148_a((BipedModel)this.model);
        this.model.setupAngles((BipedModel)this.func_215332_c());
        matrixStackIn.func_227861_a_(0.0, 0.175, 0.325);
        matrixStackIn.func_227862_a_(0.85f, 0.85f, 0.85f);
        if (isColorable) {
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(BackpackDyeRecipe.getColor(inv.getItemStack()));
            this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            ivertexbuilder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)loc));
        }
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

