/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class ServerActions {
    public static void cycleTool(PlayerEntity player, double scrollDelta) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            TravelersBackpackInventory inventory = CapabilityUtils.getBackpackInv(player);
            ItemStackHandler inv = inventory.getInventory();
            ItemStack heldItem = player.func_184614_ca();
            if (!inv.getStackInSlot(39).func_190926_b() && inv.getStackInSlot(40).func_190926_b() || !inv.getStackInSlot(40).func_190926_b() && inv.getStackInSlot(39).func_190926_b()) {
                boolean isUpperEmpty = inv.getStackInSlot(39).func_190926_b();
                player.func_184611_a(Hand.MAIN_HAND, isUpperEmpty ? inv.getStackInSlot(40) : inv.getStackInSlot(39));
                inv.setStackInSlot(isUpperEmpty ? 40 : 39, heldItem);
            }
            if (!inv.getStackInSlot(39).func_190926_b() && !inv.getStackInSlot(40).func_190926_b()) {
                if (scrollDelta < 0.0) {
                    player.func_184611_a(Hand.MAIN_HAND, inv.getStackInSlot(39));
                    inv.setStackInSlot(39, inv.getStackInSlot(40));
                    inv.setStackInSlot(40, heldItem);
                } else if (scrollDelta > 0.0) {
                    player.func_184611_a(Hand.MAIN_HAND, inv.getStackInSlot(40));
                    inv.setStackInSlot(40, inv.getStackInSlot(39));
                    inv.setStackInSlot(39, heldItem);
                }
            }
            inventory.setChanged();
        }
    }

    public static void equipBackpack(PlayerEntity player) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            if (!cap.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
                if (player.field_71070_bA instanceof TravelersBackpackItemContainer) {
                    player.field_71070_bA.func_75134_a(player);
                }
                ItemStack stack = player.func_184614_ca().func_77946_l();
                cap.ifPresent(inv -> inv.setWearable(stack));
                player.func_184614_ca().func_190918_g(1);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            }
            player.func_71053_j();
        }
    }

    public static void unequipBackpack(PlayerEntity player) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            ItemStack wearable;
            if (player.field_71070_bA instanceof TravelersBackpackItemContainer) {
                player.field_71070_bA.func_75134_a(player);
            }
            if (!player.field_71071_by.func_70441_a(wearable = cap.map(ITravelersBackpack::getWearable).orElse(ItemStack.field_190927_a).func_77946_l())) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("action.travelersbackpack.unequip_nospace"), player.func_110124_au());
                player.func_71053_j();
                return;
            }
            if (cap.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
                cap.ifPresent(ITravelersBackpack::removeWearable);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.05f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            }
            player.func_71053_j();
        }
    }

    public static void toggleSleepingBag(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        if (world.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity te = (TravelersBackpackTileEntity)world.func_175625_s(pos);
            if (!te.isSleepingBagDeployed()) {
                if (te.deploySleepingBag(world, pos)) {
                    player.func_71053_j();
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("action.travelersbackpack.deploy_sleeping_bag"), player.func_110124_au());
                }
            } else {
                te.removeSleepingBag(world);
            }
            player.func_71053_j();
        }
    }

    public static void emptyTank(double tankType, PlayerEntity player, World world) {
        TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
        FluidTank tank = tankType == 1.0 ? inv.getLeftTank() : inv.getRightTank();
        world.func_184133_a(null, player.func_233580_cy_(), FluidUtils.getFluidEmptySound(tank.getFluid().getFluid()), SoundCategory.BLOCKS, 1.0f, 1.0f);
        tank.drain(((Integer)TravelersBackpackConfig.SERVER.tanksCapacity.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
        player.func_71053_j();
        CapabilityUtils.synchronise(player);
        CapabilityUtils.synchroniseToOthers(player);
        inv.markTankDirty();
    }

    public static boolean setFluidEffect(World world, PlayerEntity player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasFluidEffectAndCanExecute(fluidStack, world, (Entity)player)) {
            done = EffectFluidRegistry.executeFluidEffectsForFluid(fluidStack, (Entity)player, world);
        }
        return done;
    }

    public static void switchHoseMode(PlayerEntity player, double scrollDelta) {
        ItemStack hose = player.func_184614_ca();
        if (hose.func_77973_b() instanceof HoseItem && hose.func_77978_p() != null) {
            int mode = HoseItem.getHoseMode(hose);
            if (scrollDelta > 0.0) {
                if (++mode == 4) {
                    mode = 1;
                }
            } else if (scrollDelta < 0.0 && --mode == 0) {
                mode = 3;
            }
            hose.func_77978_p().func_74768_a("Mode", mode);
        }
    }

    public static void toggleHoseTank(PlayerEntity player) {
        ItemStack hose = player.func_184614_ca();
        if (hose.func_77973_b() instanceof HoseItem && hose.func_77978_p() != null) {
            int tank = HoseItem.getHoseTank(hose);
            tank = tank == 1 ? 2 : 1;
            hose.func_77978_p().func_74768_a("Tank", tank);
        }
    }
}

