/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RecipeUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedBackpackRecipe
extends ShapedRecipe {
    public ShapedBackpackRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack output = super.func_77572_b(inv);
        if (!output.func_190926_b()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack ingredient = inv.func_70301_a(i);
                if (ingredient.func_190926_b() || !(ingredient.func_77973_b() instanceof TravelersBackpackItem)) continue;
                CompoundNBT compound = ingredient.func_77978_p();
                output.func_77982_d(compound);
                break;
            }
        }
        return output;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModCrafting.BACKPACK_SHAPED;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedBackpackRecipe> {
        public ShapedBackpackRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            RecipeUtils.ShapedPrimer primer = RecipeUtils.parseShaped(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new ShapedBackpackRecipe(recipeID, group, primer.getRecipeWidth(), primer.getRecipeHeight(), primer.getIngredients(), result);
        }

        public ShapedBackpackRecipe fromNetwork(ResourceLocation recipeID, PacketBuffer buffer) {
            int width = buffer.func_150792_a();
            int height = buffer.func_150792_a();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            return new ShapedBackpackRecipe(recipeID, group, width, height, (NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(PacketBuffer buffer, ShapedBackpackRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

