/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TravelersBackpackInventory
implements ITravelersBackpackInventory,
INamedContainerProvider {
    private final ItemStackHandler inventory = this.createHandler(45);
    private final ItemStackHandler craftingInventory = this.createHandler(9);
    private final FluidTank leftTank;
    private final FluidTank rightTank;
    private final PlayerEntity player;
    private final ItemStack stack;
    private int lastTime;
    private final byte screenID;
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String LAST_TIME = "LastTime";
    private final String COLOR = "Color";

    public TravelersBackpackInventory(ItemStack stack, PlayerEntity player, byte screenID) {
        this.leftTank = this.createFluidHandler((Integer)TravelersBackpackConfig.SERVER.tanksCapacity.get());
        this.rightTank = this.createFluidHandler((Integer)TravelersBackpackConfig.SERVER.tanksCapacity.get());
        this.INVENTORY = "Inventory";
        this.CRAFTING_INVENTORY = "CraftingInventory";
        this.LEFT_TANK = "LeftTank";
        this.RIGHT_TANK = "RightTank";
        this.LAST_TIME = "LastTime";
        this.COLOR = "Color";
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        this.loadAllData(this.getTagCompound(stack));
    }

    @Override
    public ItemStackHandler getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void setChanged() {
        this.saveAllData(this.getTagCompound(this.stack));
    }

    @Override
    public void markTankDirty() {
        this.saveTanks(this.getTagCompound(this.stack));
        this.sendPackets();
    }

    @Override
    public void saveAllData(CompoundNBT compound) {
        this.markTankDirty();
        this.saveItems(compound);
        this.saveTime(compound);
    }

    @Override
    public void loadAllData(CompoundNBT compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadTime(compound);
    }

    @Override
    public void saveTanks(CompoundNBT compound) {
        compound.func_218657_a("LeftTank", (INBT)this.leftTank.writeToNBT(new CompoundNBT()));
        compound.func_218657_a("RightTank", (INBT)this.rightTank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public void loadTanks(CompoundNBT compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    @Override
    public void saveItems(CompoundNBT compound) {
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("CraftingInventory", (INBT)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.craftingInventory.deserializeNBT(compound.func_74775_l("CraftingInventory"));
    }

    @Override
    public void saveTime(CompoundNBT compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundNBT compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    @Override
    public void saveColor(CompoundNBT compound) {
    }

    @Override
    public void loadColor(CompoundNBT compound) {
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 41, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 43, this.player);
    }

    private void sendPackets() {
        if (this.screenID == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }

    @Override
    public CompoundNBT getTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            CompoundNBT tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        return stack.func_77978_p();
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        ItemStack itemstack = ItemStackUtils.getAndSplit((IItemHandler)this.inventory, index, count);
        if (!itemstack.func_190926_b()) {
            this.setChanged();
        }
        return itemstack;
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.getTagCompound(this.stack).func_74762_e("Color");
        }
        return 0;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public World getLevel() {
        return this.player.field_70170_p;
    }

    @Override
    public boolean hasColor() {
        return this.getTagCompound(this.stack).func_74764_b("Color");
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("screen.travelersbackpack.item");
    }

    @Override
    public BlockPos getPosition() {
        return this.player.func_233580_cy_();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    public static void openGUI(ServerPlayerEntity serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)new TravelersBackpackInventory(stack, (PlayerEntity)serverPlayerEntity, screenID), packetBuffer -> packetBuffer.writeByte((int)screenID));
        }
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TravelersBackpackItemContainer(windowID, playerInventory, this);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackInventory.this.saveItems(TravelersBackpackInventory.this.getTagCompound(TravelersBackpackInventory.this.stack));
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !(stack.func_77973_b() instanceof TravelersBackpackItem);
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackInventory.this.markTankDirty();
            }
        };
    }
}

