/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackItemStackRenderer;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TravelersBackpackItem
extends BlockItem {
    public TravelersBackpackItem(Block block) {
        super(block, new Item.Properties().func_200916_a(Reference.TRAVELERS_BACKPACK_TAB).func_200917_a(1).setISTER(() -> TravelersBackpackItemStackRenderer::new));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && handIn == Hand.MAIN_HAND && itemstack.func_77973_b() == this && !playerIn.func_213453_ef()) {
            TravelersBackpackInventory.openGUI((ServerPlayerEntity)playerIn, playerIn.field_71071_by.func_70448_g(), (byte)1);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType actionresulttype = this.func_195942_a(new BlockItemUseContext(context));
        return !actionresulttype.func_226246_a_() ? this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a() : actionresulttype;
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        if (!context.func_196011_b() || context.func_221531_n() == Hand.MAIN_HAND && !context.func_195999_j().func_213453_ef()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.func_219984_b(context);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = this.func_195945_b(blockitemusecontext);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.func_195941_b(blockitemusecontext, blockstate)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity player = blockitemusecontext.func_195999_j();
        ItemStack itemstack = blockitemusecontext.func_195996_i();
        BlockState blockstate1 = world.func_180495_p(blockpos);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            this.func_195943_a(blockpos, world, player, itemstack, blockstate1);
            block.func_180633_a(world, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (itemstack.func_77978_p() != null && world.func_175625_s(blockpos) instanceof TravelersBackpackTileEntity) {
                ((TravelersBackpackTileEntity)world.func_175625_s(blockpos)).loadAllData(itemstack.func_77978_p());
                if (itemstack.func_82837_s()) {
                    ((TravelersBackpackTileEntity)world.func_175625_s(blockpos)).setCustomName(itemstack.func_151000_E());
                }
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((IWorldReader)world, blockpos, (Entity)context.func_195999_j());
        world.func_184133_a(player, blockpos, this.getPlaceSound(blockstate1, world, blockpos, player), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack)).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("block.travelersbackpack.travelers_backpack"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (((Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get()).booleanValue()) {
            if (stack.func_77973_b() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("obtain.travelersbackpack.bat").func_240699_a_(TextFormatting.BLUE));
            }
            if (stack.func_77973_b() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("obtain.travelersbackpack.villager").func_240699_a_(TextFormatting.BLUE));
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (TravelersBackpack.enableCurios()) {
            return new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(TravelersBackpackCurios::createBackpackProvider);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            };
        }
        return null;
    }
}

