/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.altar;

import com.google.common.base.Enums;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.AltarUpgrade;
import wayoftime.bloodmagic.altar.AltarUtil;
import wayoftime.bloodmagic.api.event.BloodMagicCraftedEvent;
import wayoftime.bloodmagic.block.enums.BloodRuneType;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.tile.TileAltar;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class BloodAltar {
    public boolean isActive;
    protected FluidStack fluidOutput = new FluidStack((Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get(), 0);
    protected FluidStack fluidInput = new FluidStack((Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get(), 0);
    protected FluidTank tank = new FluidTank(1000);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private TileAltar tileAltar;
    private int internalCounter = 0;
    private AltarTier altarTier = AltarTier.ONE;
    private AltarUpgrade upgrade;
    private int capacity = 10000;
    private FluidStack fluid = new FluidStack((Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get(), 0);
    private int liquidRequired;
    private boolean canBeFilled;
    private int consumptionRate;
    private int drainRate;
    private float consumptionMultiplier;
    private float efficiencyMultiplier;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier = 1.0f;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private int accelerationUpgrades;
    private boolean isUpgraded;
    private boolean isResultBlock;
    private int bufferCapacity = 1000;
    private int progress;
    private int lockdownDuration;
    private int demonBloodDuration;
    private int totalCharge = 0;
    private int chargingRate = 0;
    private int chargingFrequency = 0;
    private int maxCharge = 0;
    private int cooldownAfterCrafting = 60;
    private RecipeBloodAltar recipe;
    private AltarTier currentTierDisplayed = AltarTier.ONE;

    public BloodAltar(TileAltar tileAltar) {
        this.tileAltar = tileAltar;
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        if (!tagCompound.func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)tagCompound);
            if (fluid != null) {
                this.setMainFluid(new FluidStack((Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get(), fluid.getAmount()));
            }
            FluidStack fluidOut = new FluidStack((Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get(), tagCompound.func_74762_e("outputAmount"));
            this.setOutputFluid(fluidOut);
            FluidStack fluidIn = new FluidStack((Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get(), tagCompound.func_74762_e("inputAmount"));
            this.setInputFluid(fluidIn);
        }
        this.internalCounter = tagCompound.func_74762_e("internalCounter");
        this.altarTier = (AltarTier)((Object)Enums.getIfPresent(AltarTier.class, (String)tagCompound.func_74779_i("upgradeLevel")).or((Object)AltarTier.ONE));
        this.isActive = tagCompound.func_74767_n("isActive");
        this.liquidRequired = tagCompound.func_74762_e("liquidRequired");
        this.canBeFilled = tagCompound.func_74767_n("fillable");
        this.isUpgraded = tagCompound.func_74767_n("isUpgraded");
        this.consumptionRate = tagCompound.func_74762_e("consumptionRate");
        this.drainRate = tagCompound.func_74762_e("drainRate");
        this.consumptionMultiplier = tagCompound.func_74760_g("consumptionMultiplier");
        this.efficiencyMultiplier = tagCompound.func_74760_g("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = tagCompound.func_74760_g("selfSacrificeMultiplier");
        this.sacrificeEfficiencyMultiplier = tagCompound.func_74760_g("sacrificeMultiplier");
        this.capacityMultiplier = tagCompound.func_74760_g("capacityMultiplier");
        this.orbCapacityMultiplier = tagCompound.func_74760_g("orbCapacityMultiplier");
        this.dislocationMultiplier = tagCompound.func_74760_g("dislocationMultiplier");
        this.capacity = tagCompound.func_74762_e("capacity");
        this.bufferCapacity = tagCompound.func_74762_e("bufferCapacity");
        this.progress = tagCompound.func_74762_e("progress");
        this.isResultBlock = tagCompound.func_74767_n("isResultBlock");
        this.lockdownDuration = tagCompound.func_74762_e("lockdownDuration");
        this.accelerationUpgrades = tagCompound.func_74762_e("accelerationUpgrades");
        this.demonBloodDuration = tagCompound.func_74762_e("demonBloodDuration");
        this.cooldownAfterCrafting = tagCompound.func_74762_e("cooldownAfterCrafting");
        this.chargingRate = tagCompound.func_74762_e("chargeRate");
        this.chargingFrequency = tagCompound.func_74762_e("chargeFrequency");
        this.totalCharge = tagCompound.func_74762_e("totalCharge");
        this.maxCharge = tagCompound.func_74762_e("maxCharge");
        this.currentTierDisplayed = (AltarTier)((Object)Enums.getIfPresent(AltarTier.class, (String)tagCompound.func_74779_i("currentTierDisplayed")).or((Object)AltarTier.ONE));
    }

    public void writeToNBT(CompoundNBT tagCompound) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(tagCompound);
        } else {
            tagCompound.func_74778_a("Empty", "");
        }
        if (this.fluidOutput != null) {
            tagCompound.func_74768_a("outputAmount", this.fluidOutput.getAmount());
        }
        if (this.fluidInput != null) {
            tagCompound.func_74768_a("inputAmount", this.fluidInput.getAmount());
        }
        tagCompound.func_74768_a("internalCounter", this.internalCounter);
        tagCompound.func_74778_a("upgradeLevel", this.altarTier.name());
        tagCompound.func_74757_a("isActive", this.isActive);
        tagCompound.func_74768_a("liquidRequired", this.liquidRequired);
        tagCompound.func_74757_a("fillable", this.canBeFilled);
        tagCompound.func_74757_a("isUpgraded", this.isUpgraded);
        tagCompound.func_74768_a("consumptionRate", this.consumptionRate);
        tagCompound.func_74768_a("drainRate", this.drainRate);
        tagCompound.func_74776_a("consumptionMultiplier", this.consumptionMultiplier);
        tagCompound.func_74776_a("efficiencyMultiplier", this.efficiencyMultiplier);
        tagCompound.func_74776_a("sacrificeMultiplier", this.sacrificeEfficiencyMultiplier);
        tagCompound.func_74776_a("selfSacrificeMultiplier", this.selfSacrificeEfficiencyMultiplier);
        tagCompound.func_74757_a("isResultBlock", this.isResultBlock);
        tagCompound.func_74776_a("capacityMultiplier", this.capacityMultiplier);
        tagCompound.func_74776_a("orbCapacityMultiplier", this.orbCapacityMultiplier);
        tagCompound.func_74776_a("dislocationMultiplier", this.dislocationMultiplier);
        tagCompound.func_74768_a("capacity", this.capacity);
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74768_a("bufferCapacity", this.bufferCapacity);
        tagCompound.func_74768_a("lockdownDuration", this.lockdownDuration);
        tagCompound.func_74768_a("accelerationUpgrades", this.accelerationUpgrades);
        tagCompound.func_74768_a("demonBloodDuration", this.demonBloodDuration);
        tagCompound.func_74768_a("cooldownAfterCrafting", this.cooldownAfterCrafting);
        tagCompound.func_74768_a("chargeRate", this.chargingRate);
        tagCompound.func_74768_a("chargeFrequency", this.chargingFrequency);
        tagCompound.func_74768_a("totalCharge", this.totalCharge);
        tagCompound.func_74768_a("maxCharge", this.maxCharge);
        tagCompound.func_74778_a("currentTierDisplayed", this.currentTierDisplayed.name());
    }

    public void startCycle() {
        ItemStack input;
        if (this.tileAltar.func_145831_w() != null) {
            this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
        }
        this.checkTier();
        if ((this.fluid == null || this.fluid.getAmount() <= 0) && this.totalCharge <= 0) {
            return;
        }
        if (!this.isActive) {
            this.progress = 0;
        }
        if (!(input = this.tileAltar.func_70301_a(0)).func_190926_b()) {
            RecipeBloodAltar recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getBloodAltar(this.tileAltar.func_145831_w(), input);
            if (recipe != null) {
                if (recipe.getMinimumTier() <= this.altarTier.ordinal()) {
                    this.isActive = true;
                    this.recipe = recipe;
                    this.liquidRequired = recipe.getSyphon();
                    this.consumptionRate = recipe.getConsumeRate();
                    this.drainRate = recipe.getDrainRate();
                    this.canBeFilled = false;
                    return;
                }
            } else if (input.func_77973_b() instanceof IBloodOrb) {
                this.isActive = true;
                this.canBeFilled = true;
                return;
            }
        }
        this.isActive = false;
    }

    public void update() {
        World world = this.tileAltar.func_145831_w();
        BlockPos pos = this.tileAltar.func_174877_v();
        if (world.field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.lockdownDuration > 0) {
            --this.lockdownDuration;
        }
        if (this.internalCounter % 20 == 0) {
            for (Direction facing : Direction.values()) {
                BlockPos newPos = pos.func_177972_a(facing);
                BlockState block = world.func_180495_p(newPos);
                block.func_177230_c().onNeighborChange(block, (IWorldReader)world, newPos, pos);
            }
        }
        if (this.internalCounter % Math.max(20 - this.accelerationUpgrades, 1) == 0) {
            int syphonMax = (int)(20.0f * this.dislocationMultiplier);
            int fluidInputted = Math.min(syphonMax, -this.fluid.getAmount() + this.capacity);
            fluidInputted = Math.min(this.fluidInput.getAmount(), fluidInputted);
            this.fluid.setAmount(this.fluid.getAmount() + fluidInputted);
            this.fluidInput.setAmount(this.fluidInput.getAmount() - fluidInputted);
            int fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.getAmount());
            fluidOutputted = Math.min(this.fluid.getAmount(), fluidOutputted);
            this.fluidOutput.setAmount(this.fluidOutput.getAmount() + fluidOutputted);
            this.fluid.setAmount(this.fluid.getAmount() - fluidOutputted);
            this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
        }
        if (this.internalCounter % this.getChargingFrequency() == 0 && !this.isActive) {
            int chargeInputted = Math.min(this.chargingRate, this.fluid.getAmount());
            chargeInputted = Math.min(chargeInputted, this.maxCharge - this.totalCharge);
            this.totalCharge += chargeInputted;
            this.fluid.setAmount(this.fluid.getAmount() - chargeInputted);
            this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
        }
        if (this.internalCounter % 100 == 0 && (this.isActive || this.cooldownAfterCrafting <= 0)) {
            this.startCycle();
        }
        this.updateAltar();
    }

    private void updateAltar() {
        if (this.tileAltar.getOutputState()) {
            this.tileAltar.setOutputState(false);
        }
        if (!this.isActive) {
            if (this.cooldownAfterCrafting > 0) {
                --this.cooldownAfterCrafting;
            }
            return;
        }
        if (!this.canBeFilled && this.recipe == null) {
            this.startCycle();
            return;
        }
        ItemStack input = this.tileAltar.func_70301_a(0);
        if (input.func_190926_b()) {
            return;
        }
        World world = this.tileAltar.func_145831_w();
        BlockPos pos = this.tileAltar.func_174877_v();
        if (world.field_72995_K) {
            return;
        }
        if (!this.canBeFilled) {
            boolean hasOperated = false;
            int stackSize = input.func_190916_E();
            if (this.totalCharge > 0) {
                int chargeDrained = Math.min(this.liquidRequired * stackSize - this.progress, this.totalCharge);
                this.totalCharge -= chargeDrained;
                this.progress += chargeDrained;
                hasOperated = true;
            }
            if (this.fluid != null && this.fluid.getAmount() >= 1) {
                int liquidDrained = Math.min((int)((float)this.consumptionRate * (1.0f + this.consumptionMultiplier)), this.fluid.getAmount());
                if (liquidDrained > this.liquidRequired * stackSize - this.progress) {
                    liquidDrained = this.liquidRequired * stackSize - this.progress;
                }
                this.fluid.setAmount(this.fluid.getAmount() - liquidDrained);
                this.progress += liquidDrained;
                hasOperated = true;
                if (this.internalCounter % 4 == 0 && world instanceof ServerWorld) {
                    ServerWorld server = (ServerWorld)world;
                    server.func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
                }
            } else if (!hasOperated && this.progress > 0) {
                this.progress -= (int)(this.efficiencyMultiplier * (float)this.drainRate);
                if (this.internalCounter % 2 == 0 && world instanceof ServerWorld) {
                    ServerWorld server = (ServerWorld)world;
                    server.func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.1, 0.0, 0.1, 0.0);
                }
            }
            if (hasOperated && this.progress >= this.liquidRequired * stackSize) {
                ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)this.recipe.getOutput(), (int)stackSize);
                BloodMagicCraftedEvent.Altar event = new BloodMagicCraftedEvent.Altar(result, input.func_77946_l());
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.tileAltar.func_70299_a(0, event.getOutput());
                if (this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v().func_177977_b()).func_177230_c() instanceof RedstoneLampBlock) {
                    this.tileAltar.setOutputState(true);
                }
                this.progress = 0;
                if (world instanceof ServerWorld) {
                    ServerWorld server = (ServerWorld)world;
                    server.func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 40, 0.3, 0.0, 0.3, 0.0);
                }
                this.cooldownAfterCrafting = 30;
                this.isActive = false;
            }
        } else {
            ItemStack contained = this.tileAltar.func_70301_a(0);
            if (contained.func_190926_b() || !(contained.func_77973_b() instanceof IBloodOrb) || !(contained.func_77973_b() instanceof IBindable)) {
                return;
            }
            BloodOrb orb = ((IBloodOrb)contained.func_77973_b()).getOrb(contained);
            Binding binding = ((IBindable)contained.func_77973_b()).getBinding(contained);
            if (binding == null || orb == null) {
                return;
            }
            if (this.fluid != null && this.fluid.getAmount() >= 1) {
                int liquidDrained = Math.min((int)((float)orb.getFillRate() * (1.0f + this.consumptionMultiplier)), this.fluid.getAmount());
                int drain = NetworkHelper.getSoulNetwork(binding).add(liquidDrained, (int)((float)orb.getCapacity() * this.orbCapacityMultiplier));
                this.fluid.setAmount(this.fluid.getAmount() - drain);
                if (drain > 0 && this.internalCounter % 4 == 0 && world instanceof ServerWorld) {
                    ServerWorld server = (ServerWorld)world;
                    server.func_195598_a((IParticleData)ParticleTypes.field_197607_R, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.001);
                }
            }
        }
        this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
    }

    public void checkTier() {
        AltarTier tier;
        this.altarTier = tier = AltarUtil.getTier(this.tileAltar.func_145831_w(), this.tileAltar.func_174877_v());
        this.upgrade = AltarUtil.getUpgrades(this.tileAltar.func_145831_w(), this.tileAltar.func_174877_v(), tier);
        if (tier.equals((Object)this.currentTierDisplayed)) {
            this.currentTierDisplayed = AltarTier.ONE;
        }
        if (tier.equals((Object)AltarTier.ONE)) {
            this.upgrade = null;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.accelerationUpgrades = 0;
            this.chargingFrequency = 20;
            this.chargingRate = 0;
            this.maxCharge = 0;
            this.totalCharge = 0;
            return;
        }
        if (!tier.equals((Object)AltarTier.ONE)) {
            this.isUpgraded = true;
            this.accelerationUpgrades = this.upgrade.getLevel(BloodRuneType.ACCELERATION);
            this.consumptionMultiplier = (float)(0.2 * (double)this.upgrade.getLevel(BloodRuneType.SPEED));
            this.efficiencyMultiplier = (float)Math.pow(0.85, this.upgrade.getLevel(BloodRuneType.EFFICIENCY));
            this.sacrificeEfficiencyMultiplier = (float)(0.1 * (double)this.upgrade.getLevel(BloodRuneType.SACRIFICE));
            this.selfSacrificeEfficiencyMultiplier = (float)(0.1 * (double)this.upgrade.getLevel(BloodRuneType.SELF_SACRIFICE));
            int cap = this.upgrade.getLevel(BloodRuneType.CAPACITY);
            int cap_aug = this.upgrade.getLevel(BloodRuneType.AUGMENTED_CAPACITY);
            this.capacityMultiplier = (float)((1.0 + 0.2 * (double)cap) * Math.pow(1.075, cap_aug));
            this.dislocationMultiplier = (float)Math.pow(1.2, this.upgrade.getLevel(BloodRuneType.DISPLACEMENT));
            this.orbCapacityMultiplier = (float)(1.0 + 0.02 * (double)this.upgrade.getLevel(BloodRuneType.ORB));
            this.chargingFrequency = Math.max(20 - this.accelerationUpgrades, 1);
            this.chargingRate = (int)((float)(10 * this.upgrade.getLevel(BloodRuneType.CHARGING)) * (1.0f + this.consumptionMultiplier / 2.0f));
            this.maxCharge = (int)(1000.0 * Math.max(0.5 * (double)this.capacityMultiplier, 1.0) * (double)this.upgrade.getLevel(BloodRuneType.CHARGING));
        }
        this.capacity = (int)(10000.0f * this.capacityMultiplier);
        this.bufferCapacity = (int)(1000.0f * this.capacityMultiplier);
        if (this.fluid.getAmount() > this.capacity) {
            this.fluid.setAmount(this.capacity);
        }
        if (this.fluidOutput.getAmount() > this.bufferCapacity) {
            this.fluidOutput.setAmount(this.bufferCapacity);
        }
        if (this.fluidInput.getAmount() > this.bufferCapacity) {
            this.fluidInput.setAmount(this.bufferCapacity);
        }
        if (this.totalCharge > this.maxCharge) {
            this.totalCharge = this.maxCharge;
        }
        this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
    }

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.getAmount(), amount);
        this.fluid.setAmount(this.fluid.getAmount() + filledAmount);
        return filledAmount;
    }

    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        if (this.lockdownDuration > 0) {
            int amt = (int)Math.min((float)(this.bufferCapacity - this.fluidInput.getAmount()), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount);
            this.fluidInput.setAmount(this.fluidInput.getAmount() + amt);
        } else {
            this.fluid.setAmount((int)((float)this.fluid.getAmount() + Math.min((float)(this.capacity - this.fluid.getAmount()), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount)));
        }
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    public AltarUpgrade getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(AltarUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    public int getCurrentBlood() {
        return this.getFluidAmount();
    }

    public AltarTier getTier() {
        return this.altarTier;
    }

    public void setTier(AltarTier tier) {
        this.altarTier = tier;
    }

    public int getProgress() {
        return this.progress;
    }

    public float getSacrificeMultiplier() {
        return this.sacrificeEfficiencyMultiplier;
    }

    public float getSelfSacrificeMultiplier() {
        return this.selfSacrificeEfficiencyMultiplier;
    }

    public float getOrbMultiplier() {
        return this.orbCapacityMultiplier;
    }

    public float getDislocationMultiplier() {
        return this.dislocationMultiplier;
    }

    public float getConsumptionMultiplier() {
        return this.consumptionMultiplier;
    }

    public float getConsumptionRate() {
        return this.consumptionRate;
    }

    public int getLiquidRequired() {
        return this.liquidRequired;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public boolean setCurrentTierDisplayed(AltarTier altarTier) {
        if (this.currentTierDisplayed == altarTier) {
            return false;
        }
        this.currentTierDisplayed = altarTier;
        return true;
    }

    public void addToDemonBloodDuration(int dur) {
        this.demonBloodDuration += dur;
    }

    public boolean hasDemonBlood() {
        return this.demonBloodDuration > 0;
    }

    public void decrementDemonBlood() {
        this.demonBloodDuration = Math.max(0, this.demonBloodDuration - 1);
    }

    public void setActive() {
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void requestPauseAfterCrafting(int amount) {
        if (this.isActive) {
            this.cooldownAfterCrafting = amount;
        }
    }

    public int getChargingRate() {
        return this.chargingRate;
    }

    public int getTotalCharge() {
        return this.totalCharge;
    }

    public int getChargingFrequency() {
        return this.chargingFrequency == 0 ? 1 : this.chargingFrequency;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != BloodMagicBlocks.LIFE_ESSENCE_FLUID.get()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null || this.fluidInput.isEmpty()) {
                return Math.min(this.bufferCapacity, resource.getAmount());
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.getAmount(), resource.getAmount());
        }
        if (this.fluidInput == null || this.fluidInput.isEmpty()) {
            this.fluidInput = new FluidStack(resource, Math.min(this.bufferCapacity, resource.getAmount()));
            return this.fluidInput.getAmount();
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.getAmount();
        if (resource.getAmount() < filled) {
            this.fluidInput.setAmount(this.fluidInput.getAmount() + resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluidInput.setAmount(this.bufferCapacity);
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.fluidOutput)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluidOutput.getAmount() < drained) {
            drained = this.fluidOutput.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.setAmount(this.fluidOutput.getAmount() - drained);
        }
        return stack;
    }

    public AltarTier getCurrentTierDisplayed() {
        return this.currentTierDisplayed;
    }

    public int getAnalogSignalStrength(int redstoneMode) {
        switch (redstoneMode) {
            case 0: {
                return this.getCurrentBlood() * 15 / this.getCapacity();
            }
            case 1: {
                ItemStack contained = this.tileAltar.func_70301_a(0);
                if (contained.func_190926_b() || !(contained.func_77973_b() instanceof IBloodOrb) || !(contained.func_77973_b() instanceof IBindable)) {
                    return 0;
                }
                BloodOrb orb = ((IBloodOrb)contained.func_77973_b()).getOrb(contained);
                Binding binding = ((IBindable)contained.func_77973_b()).getBinding(contained);
                if (binding == null || orb == null) {
                    return 0;
                }
                return NetworkHelper.getSoulNetwork(binding).getCurrentEssence() * 15 / orb.getCapacity();
            }
        }
        return 0;
    }

    public static class VariableSizeFluidHandler
    implements IFluidHandler {
        BloodAltar altar;

        public VariableSizeFluidHandler(BloodAltar altar) {
            this.altar = altar;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.altar.fluid;
        }

        public int getTankCapacity(int tank) {
            return this.altar.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return stack.getFluid() == BloodMagicBlocks.LIFE_ESSENCE_FLUID.get();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.altar.fill(resource, action == IFluidHandler.FluidAction.EXECUTE);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.altar.drain(resource, action == IFluidHandler.FluidAction.EXECUTE);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.altar.drain(maxDrain, action == IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

