/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.tile.TileAlchemyTable;

public class BlockAlchemyTable
extends Block {
    public static final DirectionProperty DIRECTION = DirectionProperty.func_177712_a((String)"direction", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty INVISIBLE = BooleanProperty.func_177716_a((String)"invisible");
    protected static final VoxelShape BODY = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlockAlchemyTable() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_().func_235828_a_(BlockAlchemyTable::isntSolid).func_235847_c_(BlockAlchemyTable::isntSolid));
    }

    private static boolean isntSolid(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BODY;
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAlchemyTable();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAlchemyTable) {
            if (((TileAlchemyTable)tile).isSlave()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)world.func_175625_s(((TileAlchemyTable)tile).getConnectedPos())), (BlockPos)((TileAlchemyTable)tile).getConnectedPos());
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION, INVISIBLE});
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        BlockPos connectedPos;
        TileEntity connectedTile;
        TileAlchemyTable tile = (TileAlchemyTable)world.func_175625_s(pos);
        if (!(tile == null || (connectedTile = world.func_175625_s(connectedPos = tile.getConnectedPos())) instanceof TileAlchemyTable && ((TileAlchemyTable)connectedTile).getConnectedPos().equals((Object)pos))) {
            this.func_176206_d((IWorld)tile.func_145831_w(), pos, state);
            this.removedByPlayer(state, tile.func_145831_w(), pos, null, true, this.func_204507_t(state));
        }
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        TileAlchemyTable forge = (TileAlchemyTable)world.func_175625_s(blockPos);
        if (forge != null && !forge.isSlave()) {
            forge.dropItems();
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileAlchemyTable && !((TileAlchemyTable)tileentity).isSlave()) {
                ((TileAlchemyTable)tileentity).dropItems();
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public Item func_199767_j() {
        return (Item)BloodMagicItems.ALCHEMY_TABLE_ITEM.get();
    }
}

