/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockAlchemicalReactionChamber;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.block.BlockInversionPillarEnd;
import wayoftime.bloodmagic.common.block.BlockRoutingNode;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.base.BlockPillarCap;
import wayoftime.bloodmagic.common.block.type.PillarCapType;

public class GeneratorBlockStates
extends BlockStateProvider {
    public GeneratorBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "bloodmagic", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryObject block : BloodMagicBlocks.BASICBLOCKS.getEntries()) {
            this.buildCubeAll((Block)block.get());
        }
        for (RegistryObject block : BloodMagicBlocks.DUNGEONBLOCKS.getEntries()) {
            this.buildDungeonBlock((Block)block.get());
        }
        this.buildCubeAll((Block)BloodMagicBlocks.BLOOD_LIGHT.get());
        this.buildCubeAll((Block)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.AIR_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.WATER_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.FIRE_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.EARTH_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.DUSK_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.DAWN_RITUAL_STONE.get());
        this.buildFarmland((Block)BloodMagicBlocks.NETHER_SOIL.get(), BloodMagic.rl("block/nether_soil"), new ResourceLocation("block/netherrack"));
        this.buildFurnace((Block)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get());
        this.buildCrystal((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get(), "defaultcrystal");
        this.buildCrystal((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get(), "corrosivecrystal");
        this.buildCrystal((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get(), "destructivecrystal");
        this.buildCrystal((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get(), "vengefulcrystal");
        this.buildCrystal((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get(), "steadfastcrystal");
        this.buildRoutingNode((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get(), "routingnode");
        this.buildRoutingNode((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get(), "inputroutingnode");
        this.buildRoutingNode((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get(), "outputroutingnode");
        this.buildMasterRoutingNode((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get());
        this.buildRandomStone((Block)BloodMagicBlocks.DUNGEON_STONE.get(), BloodMagic.rl("block/dungeon/dungeon_stone"));
        this.stairsBlock((StairsBlock)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get(), BloodMagic.rl("block/dungeon/dungeon_brick1"));
        this.stairsBlock((StairsBlock)BloodMagicBlocks.DUNGEON_POLISHED_STAIRS.get(), BloodMagic.rl("block/dungeon/dungeon_polished"));
        this.buildPillarCenter((Block)BloodMagicBlocks.DUNGEON_PILLAR_CENTER.get(), BloodMagic.rl("block/dungeon/dungeon_pillar"), BloodMagic.rl("block/dungeon/dungeon_pillarheart"));
        this.buildPillarCenter((Block)BloodMagicBlocks.DUNGEON_PILLAR_SPECIAL.get(), BloodMagic.rl("block/dungeon/dungeon_pillarspecial"), BloodMagic.rl("block/dungeon/dungeon_pillarheart"));
        this.buildWallInventory((WallBlock)BloodMagicBlocks.DUNGEON_BRICK_WALL.get(), BloodMagic.rl("block/dungeon/dungeon_brick1"));
        this.buildWallInventory((WallBlock)BloodMagicBlocks.DUNGEON_POLISHED_WALL.get(), BloodMagic.rl("block/dungeon/dungeon_polished"));
        this.fenceGateBlock((FenceGateBlock)BloodMagicBlocks.DUNGEON_BRICK_GATE.get(), BloodMagic.rl("block/dungeon/dungeon_brick1"));
        this.fenceGateBlock((FenceGateBlock)BloodMagicBlocks.DUNGEON_POLISHED_GATE.get(), BloodMagic.rl("block/dungeon/dungeon_polished"));
        this.slabBlock((SlabBlock)BloodMagicBlocks.DUNGEON_BRICK_SLAB.get(), BloodMagic.rl("dungeon_brick1"), BloodMagic.rl("block/dungeon/dungeon_brick1"));
        this.slabBlock((SlabBlock)BloodMagicBlocks.DUNGEON_TILE_SLAB.get(), BloodMagic.rl("dungeon_tile"), BloodMagic.rl("block/dungeon/dungeon_tile"));
        this.buildPillarCap((Block)BloodMagicBlocks.DUNGEON_PILLAR_CAP.get(), BloodMagic.rl("block/dungeon/dungeon_pillarheart"), BloodMagic.rl("block/dungeon/dungeon_pillarbottom"), BloodMagic.rl("block/dungeon/dungeon_pillartop"));
        this.buildAssortedBlock((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get(), this.modLoc("dungeon_brick1"), this.modLoc("dungeon_brick2"), this.modLoc("dungeon_brick3"));
        this.buildCubeAllWithTextureName("etherealopaquemimic");
        this.buildCubeAllWithTextureName("sentientmimic");
        this.buildCubeAllWithTextureName("solidclearmimic");
        this.buildCubeAllWithTextureName("solidlightmimic");
        this.buildCubeAllWithTextureName("solidopaquemimic");
        this.buildCubeAll((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get());
        this.buildCubeAll((Block)BloodMagicBlocks.DUNGEON_SEAL.get());
        this.buildCrop((Block)BloodMagicBlocks.GROWING_DOUBT.get(), CropsBlock.field_176488_a, 7, BloodMagic.rl("block/creeping_doubt_1"), BloodMagic.rl("block/creeping_doubt_2"), BloodMagic.rl("block/creeping_doubt_3"), BloodMagic.rl("block/creeping_doubt_4"), BloodMagic.rl("block/creeping_doubt_5"), BloodMagic.rl("block/creeping_doubt_6"), BloodMagic.rl("block/creeping_doubt_7"), BloodMagic.rl("block/creeping_doubt_8"));
        this.buildCrossCrop((Block)BloodMagicBlocks.WEAK_TAU.get(), CropsBlock.field_176488_a, 7, this.modLoc("block/weak_tau_1"), this.modLoc("block/weak_tau_2"), this.modLoc("block/weak_tau_3"), this.modLoc("block/weak_tau_4"), this.modLoc("block/weak_tau_5"), this.modLoc("block/weak_tau_6"), this.modLoc("block/weak_tau_7"), this.modLoc("block/weak_tau_8"));
        this.buildCrossCrop((Block)BloodMagicBlocks.STRONG_TAU.get(), CropsBlock.field_176488_a, 7, this.modLoc("block/weak_tau_1"), this.modLoc("block/strong_tau_2"), this.modLoc("block/strong_tau_3"), this.modLoc("block/strong_tau_4"), this.modLoc("block/strong_tau_5"), this.modLoc("block/strong_tau_6"), this.modLoc("block/strong_tau_7"), this.modLoc("block/strong_tau_8"));
        this.buildOrientable((Block)BloodMagicBlocks.SHAPED_CHARGE.get(), "shaped_charge", this.modLoc("block/sub/shaped_charge"), this.modLoc("block/dungeon/dungeon_stone"), this.modLoc("block/dungeon/dungeon_tile"), this.modLoc("block/blankrune"), this.modLoc("block/largebloodstonebrick"), this.modLoc("models/defaultcrystal"));
        this.buildOrientable((Block)BloodMagicBlocks.DEFORESTER_CHARGE.get(), "deforester_charge", this.modLoc("block/sub/shaped_charge"), new ResourceLocation("block/oak_log_top"), new ResourceLocation("block/oak_log_top"), this.modLoc("block/blankrune"), new ResourceLocation("block/oak_planks"), this.modLoc("models/defaultcrystal"));
        this.buildOrientable((Block)BloodMagicBlocks.VEINMINE_CHARGE.get(), "veinmine_charge", this.modLoc("block/sub/shaped_charge"), new ResourceLocation("block/sandstone_bottom"), new ResourceLocation("block/sandstone_bottom"), this.modLoc("block/blankrune"), new ResourceLocation("block/sand"), this.modLoc("models/defaultcrystal"));
        this.buildOrientable((Block)BloodMagicBlocks.FUNGAL_CHARGE.get(), "fungal_charge", this.modLoc("block/sub/shaped_charge"), new ResourceLocation("block/nether_wart_block"), new ResourceLocation("block/crimson_planks"), this.modLoc("block/blankrune"), new ResourceLocation("block/crimson_stem"), this.modLoc("models/defaultcrystal"));
        this.getVariantBuilder((Block)BloodMagicBlocks.INVERSION_PILLAR.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("inversion_pillar", this.modLoc("pillar_mid"))).texture("texture", this.modLoc("models/pillar_mid"));
            return builder.modelFile((ModelFile)model).build();
        });
        this.buildInversionPillarCap((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get());
    }

    private void buildInversionPillarCap(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        ModelBuilder bottomModel = ((BlockModelBuilder)this.models().withExistingParent("inversion_pillar_bottom", this.modLoc("pillar_bottom"))).texture("texture", this.modLoc("models/pillar_base"));
        ModelBuilder topModel = ((BlockModelBuilder)this.models().withExistingParent("inversion_pillar_top", this.modLoc("pillar_top"))).texture("texture", this.modLoc("models/pillar_base"));
        builder.partialState().with(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.BOTTOM)).modelForState().modelFile((ModelFile)bottomModel).addModel();
        builder.partialState().with(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.TOP)).modelForState().modelFile((ModelFile)topModel).addModel();
    }

    private void buildOrientable(Block block, String name, ResourceLocation modelPath, ResourceLocation base, ResourceLocation edges, ResourceLocation centerCap, ResourceLocation binding, ResourceLocation core) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, modelPath)).texture("1", edges)).texture("3", base)).texture("4", centerCap)).texture("5", binding)).texture("6", core)).texture("particle", core);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationX(270).addModel();
    }

    private void buildCrop(Block block, IntegerProperty prop, int maxAge, ResourceLocation ... textures) {
        String basePath = block.getRegistryName().func_110623_a();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 0; i <= maxAge; ++i) {
            ModelBuilder modelFile = this.models().crop(basePath + "_" + (i + 1), textures[i]);
            builder.partialState().with((Property)prop, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)modelFile).addModel();
        }
    }

    private void buildCrossCrop(Block block, IntegerProperty prop, int maxAge, ResourceLocation ... textures) {
        String basePath = block.getRegistryName().func_110623_a();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 0; i <= maxAge; ++i) {
            ModelBuilder modelFile = this.models().cross(basePath + "_" + (i + 1), textures[i]);
            builder.partialState().with((Property)prop, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)modelFile).addModel();
        }
    }

    private void buildFarmland(Block block, ResourceLocation top, ResourceLocation side) {
        String basePath = block.getRegistryName().func_110623_a();
        this.getVariantBuilder(block).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            ModelBuilder file = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath, "template_farmland")).texture("top", top)).texture("dirt", side);
            return builder.modelFile((ModelFile)file).build();
        });
    }

    private void buildCubeAllWithTextureName(String texture) {
        ((BlockModelBuilder)this.models().cubeAll(texture, BloodMagic.rl("block/" + texture))).assertExistence();
    }

    private void buildAssortedBlock(Block block, ResourceLocation ... modelResources) {
        this.getVariantBuilder(block).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            for (int i = 0; i < modelResources.length; ++i) {
                ResourceLocation location = modelResources[i];
                ModelFile.ExistingModelFile file = this.models().getExistingFile(location);
                builder = i < modelResources.length - 1 ? builder.modelFile((ModelFile)file).nextModel() : builder.modelFile((ModelFile)file);
            }
            return builder.build();
        });
    }

    private void buildRandomStone(Block block, ResourceLocation texture) {
        String basePath = block.getRegistryName().func_110623_a();
        ModelBuilder modelFile = this.models().cubeAll(basePath, texture);
        ModelBuilder modelFile_mirrored = ((BlockModelBuilder)this.models().withExistingParent(basePath + "_mirrored", "cube_mirrored_all")).texture("all", texture);
        this.getVariantBuilder(block).forAllStates(arg_0 -> GeneratorBlockStates.lambda$buildRandomStone$3((ModelFile)modelFile, (ModelFile)modelFile_mirrored, arg_0));
    }

    private void buildWallInventory(WallBlock block, ResourceLocation texture) {
        String basePath = block.getRegistryName().func_110623_a();
        this.wallBlock(block, texture);
        ModelBuilder file = this.models().wallInventory(basePath + "_inventory", texture);
        file.assertExistence();
    }

    private void buildDungeonBlock(Block block) {
        String basePath = block.getRegistryName().func_110623_a();
        ModelBuilder modelFile = this.models().cubeAll(basePath, BloodMagic.rl("block/dungeon/" + basePath));
        this.getVariantBuilder(block).forAllStates(arg_0 -> GeneratorBlockStates.lambda$buildDungeonBlock$4((ModelFile)modelFile, arg_0));
    }

    private void buildPillarCenter(Block block, ResourceLocation side, ResourceLocation pillarEnd) {
        String basePath = block.getRegistryName().func_110623_a();
        ModelBuilder yModel = this.models().cubeColumn(basePath, side, pillarEnd);
        ModelBuilder.ElementBuilder xElementBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath + "_x", "cube")).texture("particle", side)).texture("end", pillarEnd)).texture("side", side)).element();
        xElementBuilder.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        xElementBuilder.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        xElementBuilder.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        xElementBuilder.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        xElementBuilder.face(Direction.WEST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#end").end();
        xElementBuilder.face(Direction.EAST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#end").end();
        ModelBuilder xModel = xElementBuilder.end();
        ModelBuilder.ElementBuilder zElementBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath + "_z", "cube")).texture("particle", side)).texture("end", pillarEnd)).texture("side", side)).element();
        zElementBuilder.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").end();
        zElementBuilder.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").end();
        zElementBuilder.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#end").end();
        zElementBuilder.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#end").end();
        zElementBuilder.face(Direction.WEST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#side").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        zElementBuilder.face(Direction.EAST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#side").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        ModelBuilder zModel = zElementBuilder.end();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)xModel).addModel();
        builder.partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)yModel).addModel();
        builder.partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)zModel).addModel();
    }

    private void buildPillarCap(Block block, ResourceLocation pillarEnd, ResourceLocation sideBottom, ResourceLocation sideTop) {
        String basePath = block.getRegistryName().func_110623_a();
        ModelBuilder upModel = this.models().cubeBottomTop(basePath, sideTop, pillarEnd, pillarEnd);
        ModelBuilder downModel = this.models().cubeBottomTop(basePath + "_down", sideBottom, pillarEnd, pillarEnd);
        ModelBuilder.ElementBuilder northElementBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath + "_north", "cube")).texture("particle", pillarEnd)).texture("sideBottom", sideBottom)).texture("end", pillarEnd)).texture("sideTop", sideTop)).element();
        northElementBuilder.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideTop").end();
        northElementBuilder.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideBottom").end();
        northElementBuilder.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#end").end();
        northElementBuilder.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#end").end();
        northElementBuilder.face(Direction.WEST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#sideTop").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        northElementBuilder.face(Direction.EAST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#sideBottom").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        ModelBuilder northModel = northElementBuilder.end();
        ModelBuilder.ElementBuilder southElementBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath + "_south", "cube")).texture("particle", pillarEnd)).texture("sideBottom", sideBottom)).texture("end", pillarEnd)).texture("sideTop", sideTop)).element();
        southElementBuilder.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideBottom").end();
        southElementBuilder.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideTop").end();
        southElementBuilder.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#end").end();
        southElementBuilder.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#end").end();
        southElementBuilder.face(Direction.WEST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#sideBottom").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        southElementBuilder.face(Direction.EAST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#sideTop").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        ModelBuilder southModel = southElementBuilder.end();
        ModelBuilder.ElementBuilder westElementBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath + "_west", "cube")).texture("particle", pillarEnd)).texture("sideBottom", sideBottom)).texture("end", pillarEnd)).texture("sideTop", sideTop)).element();
        westElementBuilder.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideTop").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        westElementBuilder.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideTop").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        westElementBuilder.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideBottom").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        westElementBuilder.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideTop").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        westElementBuilder.face(Direction.WEST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#end").end();
        westElementBuilder.face(Direction.EAST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#end").end();
        ModelBuilder westModel = westElementBuilder.end();
        ModelBuilder.ElementBuilder eastElementBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath + "_east", "cube")).texture("particle", pillarEnd)).texture("sideBottom", sideBottom)).texture("end", pillarEnd)).texture("sideTop", sideTop)).element();
        eastElementBuilder.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideBottom").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        eastElementBuilder.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideBottom").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        eastElementBuilder.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideTop").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        eastElementBuilder.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#sideBottom").rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end();
        eastElementBuilder.face(Direction.WEST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#end").end();
        eastElementBuilder.face(Direction.EAST).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#end").end();
        ModelBuilder eastModel = eastElementBuilder.end();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)upModel).addModel();
        builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)downModel).addModel();
        builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)northModel).addModel();
        builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)southModel).addModel();
        builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)westModel).addModel();
        builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)eastModel).addModel();
    }

    private BlockModelBuilder rotateTextureFace(BlockModelBuilder file, Direction face, ModelBuilder.FaceRotation rotation, String texture) {
        return (BlockModelBuilder)file.element().face(face).uvs(16.0f, 0.0f, 0.0f, 16.0f).rotation(rotation).texture("#east").end().end();
    }

    private void buildCubeAll(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.cubeAll(block)).build());
    }

    private void buildCrystal(Block block, String name) {
        int i;
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelFile[] crystalModels = new ModelFile[7];
        for (i = 0; i < 7; ++i) {
            crystalModels[i] = ((BlockModelBuilder)this.models().withExistingParent("block/crystal/" + name + (i + 1), this.modLoc("crystal" + (i + 1)))).texture("crystal", this.modLoc("models/" + name));
        }
        for (i = 0; i < 7; ++i) {
            Comparable[] intArray = new Integer[7 - i];
            for (int j = i; j < 7; ++j) {
                intArray[j - i] = j;
            }
            for (Direction direction : Direction.values()) {
                ConfiguredModel.Builder partBuilder = builder.part().modelFile(crystalModels[i]);
                switch (direction) {
                    case UP: {
                        break;
                    }
                    case DOWN: {
                        partBuilder = partBuilder.rotationX(180);
                        break;
                    }
                    case EAST: {
                        partBuilder = partBuilder.rotationX(90).rotationY(90);
                        break;
                    }
                    case WEST: {
                        partBuilder = partBuilder.rotationX(90).rotationY(270);
                        break;
                    }
                    case NORTH: {
                        partBuilder = partBuilder.rotationX(90);
                        break;
                    }
                    case SOUTH: {
                        partBuilder = partBuilder.rotationX(270);
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)BlockDemonCrystal.AGE, intArray).condition(BlockDemonCrystal.ATTACHED, (Comparable[])new Direction[]{direction}).end();
            }
        }
    }

    private void buildRoutingNode(Block block, String name) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelBuilder nodeModel = ((BlockModelBuilder)this.models().withExistingParent("block/routing/" + name + "core", this.modLoc("routingnodecore"))).texture("core", this.modLoc("models/model" + name));
        ModelBuilder baseModel = ((BlockModelBuilder)this.models().withExistingParent("block/routing/" + name + "base", this.modLoc("routingnodebase"))).texture("base", this.modLoc("models/model" + name));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nodeModel).addModel()).end();
        for (Direction direction : Direction.values()) {
            ConfiguredModel.Builder partBuilder = builder.part().modelFile((ModelFile)baseModel);
            BooleanProperty prop = BlockRoutingNode.UP;
            switch (direction) {
                case UP: {
                    prop = BlockRoutingNode.UP;
                    partBuilder = partBuilder.rotationX(180);
                    break;
                }
                case DOWN: {
                    prop = BlockRoutingNode.DOWN;
                    break;
                }
                case EAST: {
                    prop = BlockRoutingNode.EAST;
                    partBuilder = partBuilder.rotationX(90).rotationY(270);
                    break;
                }
                case WEST: {
                    prop = BlockRoutingNode.WEST;
                    partBuilder = partBuilder.rotationX(90).rotationY(90);
                    break;
                }
                case NORTH: {
                    prop = BlockRoutingNode.NORTH;
                    partBuilder = partBuilder.rotationX(270);
                    break;
                }
                case SOUTH: {
                    prop = BlockRoutingNode.SOUTH;
                    partBuilder = partBuilder.rotationX(90);
                }
            }
            ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)prop, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void buildMasterRoutingNode(Block block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelBuilder nodeModel = this.models().withExistingParent("block/routing/modelmasterroutingnodecore", this.modLoc("masterroutingnodecore"));
        ModelBuilder baseModel = this.models().withExistingParent("block/routing/modelmasterroutingnodebase", this.modLoc("masterroutingnodebase"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nodeModel).addModel()).end();
        for (Direction direction : Direction.values()) {
            ConfiguredModel.Builder partBuilder = builder.part().modelFile((ModelFile)baseModel);
            BooleanProperty prop = BlockRoutingNode.UP;
            switch (direction) {
                case UP: {
                    prop = BlockRoutingNode.UP;
                    partBuilder = partBuilder.rotationX(180);
                    break;
                }
                case DOWN: {
                    prop = BlockRoutingNode.DOWN;
                    break;
                }
                case EAST: {
                    prop = BlockRoutingNode.EAST;
                    partBuilder = partBuilder.rotationX(90).rotationY(270);
                    break;
                }
                case WEST: {
                    prop = BlockRoutingNode.WEST;
                    partBuilder = partBuilder.rotationX(90).rotationY(90);
                    break;
                }
                case NORTH: {
                    prop = BlockRoutingNode.NORTH;
                    partBuilder = partBuilder.rotationX(270);
                    break;
                }
                case SOUTH: {
                    prop = BlockRoutingNode.SOUTH;
                    partBuilder = partBuilder.rotationX(90);
                }
            }
            ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)prop, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void buildFurnace(Block block) {
        ModelBuilder furnace_off = this.models().orientableWithBottom("alchemicalreactionchamber", BloodMagic.rl("block/arc_side"), BloodMagic.rl("block/arc_front"), BloodMagic.rl("block/arc_bottom"), BloodMagic.rl("block/arc_top"));
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.NORTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)furnace_off).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.EAST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)furnace_off).rotationY(90).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.SOUTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)furnace_off).rotationY(180).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.WEST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)furnace_off).rotationY(270).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.NORTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)furnace_off).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.EAST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)furnace_off).rotationY(90).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.SOUTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)furnace_off).rotationY(180).addModel();
        builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.WEST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)furnace_off).rotationY(270).addModel();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buildDungeonBlock$4(ModelFile modelFile, BlockState state) {
        return ConfiguredModel.builder().modelFile(modelFile).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buildRandomStone$3(ModelFile modelFile, ModelFile modelFile_mirrored, BlockState state) {
        return ConfiguredModel.builder().modelFile(modelFile).nextModel().modelFile(modelFile_mirrored).nextModel().modelFile(modelFile).rotationY(180).nextModel().modelFile(modelFile_mirrored).rotationY(180).build();
    }
}

